/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.TitlePopupMenu;
import jadex.tools.comanalyzer.ToolTab;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MessageSliderMenu
extends TitlePopupMenu
implements ChangeListener {
    private ToolTab tool;
    private JLabel label;
    private JSlider slider;

    public MessageSliderMenu(String title, ToolTab tool) {
        super(title);
        this.tool = tool;
        if (tool.plugin.getMessageList().size() == 0) {
            JLabel text = new JLabel("No messages recorded yet");
            text.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 10));
            this.setLayout(new BorderLayout());
            this.add((java.awt.Component)text, "Center");
            return;
        }
        JPanel slider_panel = new JPanel(new GridLayout(2, 0));
        this.slider = new JSlider(0);
        this.slider.setMinimum(0);
        this.slider.setMaximum(tool.plugin.getMessageList().size());
        this.slider.setValue(tool.messagelist.size());
        this.slider.addChangeListener(this);
        this.label = new JLabel();
        String display = "Message " + tool.messagelist.size() + " / " + tool.plugin.getMessageList().size();
        this.label.setText(display);
        this.label.setHorizontalAlignment(0);
        slider_panel.add(this.slider);
        slider_panel.add(this.label);
        this.setLayout(new BorderLayout());
        this.add((java.awt.Component)slider_panel, "Center");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        List list;
        String display = "Message " + this.tool.messagelist.size() + " / " + this.tool.plugin.getMessageList().size();
        this.label.setText(display);
        if (this.tool.componentlist.size() == 0) {
            this.tool.componentlist.addAll(SUtil.arrayToList((Object)this.tool.getPlugin().getAgents()));
            this.tool.componentsChanged(this.tool.componentlist.toArray(new Component[this.tool.componentlist.size()]));
        }
        List messages = this.tool.plugin.getMessageList().getList();
        if (this.tool.messagelist.size() - this.slider.getValue() < 0) {
            list = messages.subList(this.tool.messagelist.size(), this.slider.getValue());
            this.tool.messagelist.addAll(list);
            this.tool.messagesChanged(list.toArray(new Message[list.size()]));
        }
        if (this.tool.messagelist.size() - this.slider.getValue() > 0) {
            list = messages.subList(this.slider.getValue(), this.tool.messagelist.size());
            this.tool.messagesRemoved(list.toArray(new Message[list.size()]));
        }
    }
}

