/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.ToolColor;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;

public class PaintMaps {
    public static final int PAINTMODE_DEFAULT = 0;
    public static final int PAINTMODE_CONVERSATION = 1;
    public static final int PAINTMODE_PERFORMATIV = 2;
    public static final int PAINTMODE_PROTOCOL = 3;
    public static final int COLOR_COMPONENT = 4;
    public static final Paint DEFAULT_COLOR = Color.BLACK;
    protected Map conversationPaints = new HashMap();
    protected Map performativPaints = new HashMap();
    protected Map protocolPaints = new HashMap();
    protected Map agentPaints = new HashMap();
    private Paint defaultPaint;
    private Paint[] paintTable;
    private int conversationCounter = 0;
    private int performativCounter = 0;
    private int protocolCounter = 0;
    private int agentCounter = 0;

    public PaintMaps() {
        this(DEFAULT_COLOR);
    }

    public PaintMaps(Paint defaultPaint) {
        this.defaultPaint = defaultPaint;
        this.paintTable = ToolColor.createDefaultPaintArray();
        this.conversationPaints.put(null, defaultPaint);
        this.performativPaints.put(null, defaultPaint);
        this.protocolPaints.put(null, defaultPaint);
        this.agentPaints.put(null, defaultPaint);
    }

    public void createColor(Message message) {
        Color paint;
        Color paint2;
        String convid = (String)message.getParameter("conversation_id");
        String perform = (String)message.getParameter("performative");
        String protocol = (String)message.getParameter("protocol");
        if (convid != null && !this.conversationPaints.containsKey(convid)) {
            paint2 = (Color)this.paintTable[this.conversationCounter++ % this.paintTable.length];
            this.conversationPaints.put(convid, paint2);
        }
        if (perform != null && !this.performativPaints.containsKey(perform)) {
            paint2 = (Color)this.paintTable[this.performativCounter++ % this.paintTable.length];
            this.performativPaints.put(perform, paint2);
        }
        if (protocol != null && !this.protocolPaints.containsKey(protocol)) {
            paint2 = (Color)this.paintTable[this.protocolCounter++ % this.paintTable.length];
            this.protocolPaints.put(protocol, paint2);
        }
        Component sender = message.getSender();
        Component receiver = message.getReceiver();
        if (!this.agentPaints.containsKey(sender)) {
            paint = (Color)this.paintTable[this.agentCounter++ % this.paintTable.length];
            this.agentPaints.put(sender, paint);
        }
        if (!this.agentPaints.containsKey(receiver)) {
            paint = (Color)this.paintTable[this.agentCounter++ % this.paintTable.length];
            this.agentPaints.put(receiver, paint);
        }
    }

    public Paint getMessagePaint(Message message, int paintMode) {
        Paint paint = this.defaultPaint;
        switch (paintMode) {
            case 1: {
                String convid = (String)message.getParameter("conversation_id");
                paint = (Paint)this.conversationPaints.get(convid);
                break;
            }
            case 2: {
                String perform = (String)message.getParameter("performative");
                paint = (Paint)this.performativPaints.get(perform);
                break;
            }
            case 3: {
                String protocol = (String)message.getParameter("protocol");
                paint = (Paint)this.protocolPaints.get(protocol);
            }
        }
        return paint == null ? this.defaultPaint : paint;
    }

    public Map getPaints(int paintMode) {
        switch (paintMode) {
            case 1: {
                return this.conversationPaints;
            }
            case 2: {
                return this.performativPaints;
            }
            case 3: {
                return this.protocolPaints;
            }
            case 4: {
                return this.agentPaints;
            }
        }
        return null;
    }

    public Paint getPaint(Comparable key, int paintType) {
        return this.getPaint(key, paintType, this.defaultPaint);
    }

    public Paint getPaint(Comparable key, int paintType, Paint defaultPaint) {
        Paint paint = null;
        switch (paintType) {
            case 1: {
                paint = (Paint)this.conversationPaints.get(key);
                break;
            }
            case 2: {
                paint = (Paint)this.performativPaints.get(key);
                break;
            }
            case 3: {
                paint = (Paint)this.protocolPaints.get(key);
                break;
            }
            case 4: {
                paint = (Paint)this.agentPaints.get(key);
            }
        }
        return paint == null ? defaultPaint : paint;
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint defaultPaint) {
        this.defaultPaint = defaultPaint;
    }
}

