/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.collection.MultiCollection;
import jadex.tools.comanalyzer.ParameterElement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class ParameterElementFilter
implements IFilter,
Serializable {
    protected MultiCollection<String, Object> values = new MultiCollection();

    public void addValue(String name, Object value) {
        this.values.add((Object)name, value);
    }

    public void removeValue(String name, Object value) {
        if (this.values.containsKey((Object)name)) {
            this.values.removeObject((Object)name, value);
        }
    }

    public boolean containsValue(String name, Object value) {
        Collection vals;
        return this.values.containsKey((Object)name) && (vals = this.values.getCollection((Object)name)).contains(value);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public boolean filter(Object object) {
        boolean ret = false;
        if (object instanceof ParameterElement) {
            ParameterElement probj = (ParameterElement)object;
            Iterator vkeys = this.values.keySet().iterator();
            ret = true;
            while (vkeys.hasNext() && ret) {
                String vkey = (String)vkeys.next();
                if (!probj.hasParameter(vkey)) {
                    ret = false;
                    break;
                }
                Object val = probj.getParameter(vkey);
                Object[] vals = this.values.get((Object)vkey).toArray();
                ret = false;
                for (int j = 0; j < vals.length && !ret; ++j) {
                    ret = vals[j] == null ? val == null : vals[j].equals(val);
                }
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(values=[");
        if (this.values != null) {
            Object[] vkeys = this.values.getKeys();
            for (int i = 0; i < vkeys.length; ++i) {
                sb.append(vkeys[i] + " = " + this.values.get(vkeys[i]));
                if (i >= vkeys.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("])");
        return sb.toString();
    }
}

