/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class RefreshTask
extends TimerTask {
    private final ComanalyzerPlugin plugin;
    static final int SCHEDULED = 0;
    static final int CANCELLED = 1;
    static final int DONE = 2;
    int state = 0;
    private final Object lock = new Object();
    private List durations = new ArrayList();
    private List messages = new ArrayList();
    private long period;

    public RefreshTask(ComanalyzerPlugin plugin, long period) {
        this.plugin = plugin;
        this.period = period;
    }

    public RefreshTask(ComanalyzerPlugin plugin, long period, List durations) {
        this(plugin, period);
        this.durations = durations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessagesAdded(Message[] messages) {
        Object object = this.lock;
        synchronized (object) {
            this.messages.addAll(0, SUtil.arrayToList((Object)messages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.messages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.messages.size() > 0) {
                this.state = 1;
                return true;
            }
            this.state = 2;
            return super.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message[] msg_array;
        Object object = this.lock;
        synchronized (object) {
            if (this.messages.size() == 0) {
                return;
            }
            msg_array = this.messages.toArray(new Message[this.messages.size()]);
            this.messages.clear();
        }
        long start = System.currentTimeMillis();
        final Future updated = new Future();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RefreshTask.this.plugin.getMessageList().fireMessagesAdded(msg_array);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                updated.setResult(null);
            }
        });
        updated.get();
        this.addExecutionDuration(System.currentTimeMillis() - start);
        if (this.state == 1) {
            this.cancel();
        }
    }

    public boolean isDone() {
        return this.state == 2;
    }

    public boolean isCanceld() {
        return this.state == 1;
    }

    private void addExecutionDuration(long duration) {
        this.durations.add(duration);
    }

    public long getAverageExecutionDuration(int number) {
        long total = 0L;
        int count = 0;
        for (int i = this.durations.size() - 1; i >= 0 && i >= this.durations.size() - number; --i) {
            total += ((Long)this.durations.get(i)).longValue();
            ++count;
        }
        return count > 0 ? total / (long)count : 0L;
    }

    public long getLastExecutionDuration() {
        return (Long)this.durations.get(this.durations.size() - 1);
    }

    protected long getPeriod() {
        return this.period;
    }

    protected List getDurations() {
        return this.durations;
    }
}

