/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitlePopupMenu
extends JPopupMenu {
    protected String title;

    public TitlePopupMenu() {
        this(null);
    }

    public TitlePopupMenu(String title) {
        this.title = title;
        this.setBorder(new TitleBorder(this.getBorder()));
    }

    public void setTitle(String title) {
        this.title = title;
        this.invalidate();
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void setLabel(String label) {
    }

    private class TitleBorder
    extends AbstractBorder {
        protected static final int TEXT_SPACING = 2;
        protected static final int GROOVE_HEIGHT = 5;
        protected Border delegate;

        public TitleBorder(Border delegate) {
            this.delegate = delegate;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets i = this.delegate.getBorderInsets((JPopupMenu)c);
            return this.getBorderInsets(c, new Insets(i.top, i.left, i.bottom, i.right));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            int descent = 0;
            int ascent = 16;
            String title = ((TitlePopupMenu)c).getTitle();
            if (title == null) {
                return insets;
            }
            Font font = UIManager.getFont("PopupMenu.font");
            if (font == null) {
                return insets;
            }
            FontMetrics fm = c.getFontMetrics(font);
            if (fm != null) {
                descent = fm.getDescent();
                ascent = fm.getAscent();
            }
            insets.top += ascent + descent + 2 + 5;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
            Graphics2D g2d = (Graphics2D)g;
            Color background = UIManager.getColor("MenuItem.selectionBackground");
            Color foreground = UIManager.getColor("MenuItem.foreground");
            Font font = UIManager.getFont("PopupMenu.font");
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, TitlePopupMenu.this.getInsets().top - 5, background);
            g2d.setPaint(gradient);
            g2d.fillRect(1, 1, width - 2, TitlePopupMenu.this.getInsets().top - 5);
            String title = ((TitlePopupMenu)c).getTitle();
            if (title == null) {
                return;
            }
            FontMetrics fm = TitlePopupMenu.this.getFontMetrics(font);
            int ascent = fm.getAscent();
            int stringWidth = fm.stringWidth(title);
            Point textLoc = new Point();
            textLoc.y = ascent + 2;
            textLoc.x = (width - stringWidth) / 2;
            g2d.setFont(font);
            g2d.setColor(foreground);
            g2d.drawString(title, textLoc.x, textLoc.y);
        }
    }
}

