/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.gui.BrowserPane;
import jadex.tools.comanalyzer.ToolTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolPanel
extends JPanel {
    public static final String NOTHING = "No element selected for detailed view.\nUse double-click to view element.";
    protected JSplitPane content;
    protected BrowserPane details = new BrowserPane();
    protected JTabbedPane tabs = new JTabbedPane();
    protected ToolTab[] tools;

    public ToolPanel(ToolTab[] tools) {
        this.tools = tools;
        for (int i = 0; i < tools.length; ++i) {
            this.tabs.addTab(tools[i].getName(), tools[i].getIcon(), tools[i]);
        }
        this.tabs.addChangeListener(new PaneChangeListener());
        this.content = new JSplitPane(0, this.tabs, new JScrollPane((Component)this.details));
        this.content.setOneTouchExpandable(true);
        this.content.setResizeWeight(1.0);
        this.content.setDividerLocation(65535);
        this.setLayout(new BorderLayout());
        this.add("Center", this.content);
    }

    public void showElementDetails(Map element) {
        this.details.setText(element.toString());
        if (this.content.getDividerLocation() > this.content.getMaximumDividerLocation()) {
            this.content.setDividerLocation(this.content.getLastDividerLocation());
        }
    }

    public ToolTab[] getTools() {
        return this.tools;
    }

    private final class PaneChangeListener
    implements ChangeListener {
        private PaneChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            ToolTab tab = (ToolTab)pane.getSelectedComponent();
            if (tab != null) {
                tab.refreshToolBar();
            }
        }
    }
}

