/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.commons.gui.SGUI;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.ComponentFilter;
import jadex.tools.comanalyzer.IComponentListListener;
import jadex.tools.comanalyzer.IMessageListListener;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageSliderMenu;
import jadex.tools.comanalyzer.PaintMaps;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolPanel;
import jadex.tools.comanalyzer.table.TablePanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIDefaults;

public abstract class ToolTab
extends JPanel
implements IComponentListListener,
IMessageListListener {
    private static final String COMANALYZER_IMAGES = "/jadex/tools/comanalyzer/images/";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"start", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/start.png"), "stop", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/stop.png"), "arrow2l", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/arrow2l.png"), "arrow1l", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/arrow1l.png"), "slider", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/message_slider.png"), "arrow1r", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/arrow1r.png"), "arrow2r", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/arrow2r.png"), "hide_dummy", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/hide_dummy.png"), "show_dummy", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/show_dummy.png"), "hide_ignored", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/hide_ignored.png"), "show_ignored", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/show_ignored.png"), "hide_dead", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/hide_dead.png"), "show_dead", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/show_dead.png"), "show_zero", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/show_zero.png"), "hide_zero", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/hide_zero.png"), "delete_messagefilter", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/delete_messagefilter.png"), "delete_agentfilter", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/delete_agentfilter.png"), "refresh", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/refresh2.png"), "clear", SGUI.makeIcon(ToolTab.class, (String)"/jadex/tools/comanalyzer/images/clear_panel.png")});
    protected List messagelist;
    protected List componentlist;
    protected ComanalyzerPlugin plugin;
    protected String name;
    protected Icon icon;
    protected boolean active;
    protected Action[] actions;
    protected final AbstractAction STARTSTOP_ACTION = new AbstractAction("Activate Tab", icons.getIcon("start")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.setActive(!ToolTab.this.active);
        }
    };
    protected final AbstractAction REFRESH = new AbstractAction("Refresh", icons.getIcon("refresh")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.refresh();
        }
    };
    protected final AbstractAction CLEAR = new AbstractAction("Clear", icons.getIcon("clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.clear();
        }
    };
    protected final AbstractAction FIRST_MESSAGE = new AbstractAction("Move to first message", icons.getIcon("arrow2l")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.messagesRemoved(ToolTab.this.plugin.getMessages());
            ToolTab.this.componentlist.addAll(SUtil.arrayToList((Object)ToolTab.this.plugin.getAgents()));
            ToolTab.this.componentsChanged(ToolTab.this.plugin.getAgents());
            for (int i = 0; i < ToolTab.this.plugin.getMessageList().size(); ++i) {
                Message message = ToolTab.this.plugin.getMessage(i);
                ToolTab.this.messagelist.add(message);
                ToolTab.this.messagesChanged(new Message[]{message});
                if (message.getEndpoints() != null) break;
            }
        }
    };
    protected final AbstractAction PREVIOUS_MESSAGE = new AbstractAction("Move to previous message", icons.getIcon("arrow1l")){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = ToolTab.this.messagelist.size() - 1; i >= 0; --i) {
                Message message = (Message)ToolTab.this.messagelist.get(i);
                ToolTab.this.messagesRemoved(new Message[]{message});
                if (message.getEndpoints() != null) break;
            }
        }
    };
    protected final AbstractAction OPEN_SLIDER = new AbstractAction("Open Message Slider", icons.getIcon("slider")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton jb = (JButton)e.getSource();
            MessageSliderMenu popup = new MessageSliderMenu("Message Slider", ToolTab.this);
            popup.show(jb, (int)((double)jb.getWidth() - popup.getPreferredSize().getWidth()) / 2, (int)(-popup.getPreferredSize().getHeight()));
        }
    };
    protected final AbstractAction NEXT_MESSAGE = new AbstractAction("Move to next message", icons.getIcon("arrow1r")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolTab.this.componentlist.size() == 0) {
                ToolTab.this.componentlist.addAll(ToolTab.this.plugin.getAgentList().getList());
                ToolTab.this.componentsChanged(ToolTab.this.plugin.getAgents());
            }
            for (int i = ToolTab.this.messagelist.size() + 1; i < ToolTab.this.plugin.getMessageList().size(); ++i) {
                Message message = ToolTab.this.plugin.getMessage(i);
                ToolTab.this.messagelist.add(message);
                ToolTab.this.messagesChanged(new Message[]{message});
                if (message.getEndpoints() != null) break;
            }
        }
    };
    protected final AbstractAction LAST_MESSAGE = new AbstractAction("Move to last message", icons.getIcon("arrow2r")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.refresh();
        }
    };
    protected final AbstractAction SHOW_DUMMY = new AbstractAction("Hide dummy agent.", icons.getIcon("hide_dummy")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.changeAgentFilter("state", "dummy");
        }
    };
    protected final AbstractAction SHOW_IGNORED = new AbstractAction("Hide ignored agents.", icons.getIcon("hide_ignored")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.changeAgentFilter("state", "ignored");
        }
    };
    protected final AbstractAction SHOW_DEAD = new AbstractAction("Hide dead agents.", icons.getIcon("hide_dead")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.changeAgentFilter("state", "dead");
        }
    };
    protected final AbstractAction SHOW_ZERO = new AbstractAction("Hide agents without messages", icons.getIcon("hide_zero")){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ToolTab.this.changeAgentFilter("message_visible", 0);
        }
    };
    protected final AbstractAction DELETE_MESSAGE_FILTER = new AbstractAction("Delete message filter", icons.getIcon("delete_messagefilter")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.plugin.removeMessageFilter();
            ToolTab.this.plugin.applyMessageFilter();
        }
    };
    protected final AbstractAction DELETE_AGENT_FILTER = new AbstractAction("Delete agent filter", icons.getIcon("delete_agentfilter")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTab.this.plugin.removeAgentFilter();
            ToolTab.this.plugin.applyAgentFilter();
        }
    };

    public ToolTab(ComanalyzerPlugin plugin, String name, Icon icon) {
        this.messagelist = new ArrayList();
        this.componentlist = new ArrayList();
        this.name = name;
        this.icon = icon;
        this.plugin = plugin;
    }

    public ToolPanel getToolPanel() {
        return this.plugin.tpanel;
    }

    public ComanalyzerPlugin getPlugin() {
        return this.plugin;
    }

    public PaintMaps getPaintMaps() {
        return this.plugin.paintmaps;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.STARTSTOP_ACTION.putValue("ShortDescription", "Deactivate Tab");
            this.STARTSTOP_ACTION.putValue("SmallIcon", icons.getIcon("stop"));
        } else {
            this.STARTSTOP_ACTION.putValue("ShortDescription", "Activate Tab");
            this.STARTSTOP_ACTION.putValue("SmallIcon", icons.getIcon("start"));
        }
        this.REFRESH.setEnabled(!active);
        this.CLEAR.setEnabled(!active);
        this.FIRST_MESSAGE.setEnabled(!active);
        this.OPEN_SLIDER.setEnabled(!active);
        this.PREVIOUS_MESSAGE.setEnabled(!active);
        this.NEXT_MESSAGE.setEnabled(!active);
        this.LAST_MESSAGE.setEnabled(!active);
        if (active) {
            this.refresh();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract ToolCanvas getCanvas();

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<AbstractAction> actionlist = new ArrayList<AbstractAction>();
            actionlist.add(this.STARTSTOP_ACTION);
            actionlist.add(null);
            actionlist.add(this.REFRESH);
            actionlist.add(this.CLEAR);
            actionlist.add(null);
            actionlist.add(this.FIRST_MESSAGE);
            actionlist.add(this.PREVIOUS_MESSAGE);
            actionlist.add(this.OPEN_SLIDER);
            actionlist.add(this.NEXT_MESSAGE);
            actionlist.add(this.LAST_MESSAGE);
            actionlist.add(null);
            actionlist.add(this.SHOW_DUMMY);
            actionlist.add(this.SHOW_IGNORED);
            actionlist.add(this.SHOW_DEAD);
            actionlist.add(this.SHOW_ZERO);
            actionlist.add(null);
            actionlist.add(this.DELETE_MESSAGE_FILTER);
            actionlist.add(this.DELETE_AGENT_FILTER);
            this.actions = actionlist.toArray(new Action[actionlist.size()]);
        }
        return this.actions;
    }

    public void clear() {
        this.componentlist.clear();
        this.messagelist.clear();
        this.getCanvas().clear();
        this.getCanvas().repaintCanvas();
    }

    public void refresh() {
        this.getCanvas().clear();
        this.componentlist.clear();
        this.componentlist.addAll(SUtil.arrayToList((Object)this.getPlugin().getAgents()));
        for (Component agent : this.componentlist) {
            if (!agent.isVisible()) continue;
            this.getCanvas().updateComponent(agent, false);
        }
        this.messagelist.clear();
        this.messagelist.addAll(SUtil.arrayToList((Object)this.getPlugin().getMessages()));
        for (Message message : this.messagelist) {
            if (!message.isVisible()) continue;
            this.getCanvas().updateMessage(message, false);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void messagesAdded(Message[] messages) {
        if (!this.isActive()) {
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            this.messagelist.add(messages[i]);
            this.getCanvas().updateMessage(messages[i], false);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void messagesChanged(Message[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            if (!this.messagelist.contains(messages[i])) continue;
            this.getCanvas().updateMessage(messages[i], true);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void messagesRemoved(Message[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            this.messagelist.remove(messages[i]);
            this.getCanvas().removeMessage(messages[i]);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void componentsAdded(Component[] agents) {
        if (!this.isActive()) {
            return;
        }
        for (int i = 0; i < agents.length; ++i) {
            this.componentlist.add(agents[i]);
            this.getCanvas().updateComponent(agents[i], false);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void componentsChanged(Component[] agents) {
        for (int i = 0; i < agents.length; ++i) {
            if (!this.componentlist.contains(agents[i])) continue;
            this.getCanvas().updateComponent(agents[i], true);
        }
        this.getCanvas().repaintCanvas();
    }

    @Override
    public void componentsRemoved(Component[] agents) {
        for (int i = 0; i < agents.length; ++i) {
            this.componentlist.remove(agents[i]);
            this.getCanvas().removeComponent(agents[i]);
        }
        this.getCanvas().repaintCanvas();
    }

    protected void refreshToolBar() {
        boolean show_dummy = true;
        boolean show_ignored = true;
        boolean show_dead = true;
        boolean show_zero = true;
        ComponentFilter[] afs = this.plugin.getAgentFilter();
        for (int i = 0; i < afs.length; ++i) {
            if (afs[i].containsValue("state", "dummy")) {
                show_dummy = false;
            }
            if (afs[i].containsValue("state", "ignored")) {
                show_ignored = false;
            }
            if (afs[i].containsValue("state", "dead")) {
                show_dead = false;
            }
            if (!afs[i].containsValue("message_visible", 0)) continue;
            show_zero = false;
        }
        this.SHOW_DUMMY.putValue("ShortDescription", show_dummy ? "Hide dummy agent." : "Show dummy agent.");
        this.SHOW_DUMMY.putValue("SmallIcon", show_dummy ? icons.getIcon("hide_dummy") : icons.getIcon("show_dummy"));
        this.SHOW_IGNORED.putValue("ShortDescription", show_ignored ? "Hide ignored agents." : "Show ignored agents.");
        this.SHOW_IGNORED.putValue("SmallIcon", show_ignored ? icons.getIcon("hide_ignored") : icons.getIcon("show_ignored"));
        this.SHOW_DEAD.putValue("ShortDescription", show_dead ? "Hide dead agents." : "Show dead agents.");
        this.SHOW_DEAD.putValue("SmallIcon", show_dead ? icons.getIcon("hide_dead") : icons.getIcon("show_dead"));
        this.SHOW_ZERO.putValue("ShortDescription", show_zero ? "Hide agents without messages." : "Show agents without messages.");
        this.SHOW_ZERO.putValue("SmallIcon", show_zero ? icons.getIcon("hide_zero") : icons.getIcon("show_zero"));
    }

    protected void changeAgentFilter(String name, Object value) {
        boolean add_filter = true;
        ArrayList<ComponentFilter> filters = new ArrayList<ComponentFilter>();
        ComponentFilter[] afs = this.plugin.getAgentFilter();
        for (int i = 0; i < afs.length; ++i) {
            if (afs[i].containsValue(name, value)) {
                add_filter = false;
                continue;
            }
            filters.add(afs[i]);
        }
        if (add_filter) {
            ComponentFilter filter = new ComponentFilter();
            filter.addValue(name, value);
            filters.add(filter);
        }
        this.plugin.setAgentFilter(filters.toArray(new ComponentFilter[filters.size()]));
        this.refreshToolBar();
        this.plugin.applyAgentFilter();
    }
}

