/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.tools.comanalyzer.chart.KeyedListsTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;

public class CategoryPieDataset
extends AbstractDataset
implements PieDataset,
CategoryDataset,
Serializable {
    public static final int BY_ROW = 0;
    public static final int BY_COLUMN = 1;
    private int extract = 1;
    private KeyedListsTable data = new KeyedListsTable();
    private String nullValueString = "null";

    public void setList(List list, Comparable rowKey, Comparable columnKey) {
        this.data.setList(list, rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void addElement(Object element, Comparable rowKey, Comparable columnKey) {
        this.data.addToList(element, this.convertNull(rowKey), this.convertNull(columnKey));
        this.fireDatasetChanged();
    }

    public void removeElement(Object element, Comparable rowKey, Comparable columnKey) {
        this.data.removeFromList(element, this.convertNull(rowKey), this.convertNull(columnKey));
        this.fireDatasetChanged();
    }

    public List getList(Comparable rowKey, Comparable columnKey) {
        return this.data.getList(this.convertNull(rowKey), this.convertNull(columnKey));
    }

    public void removeRow(int rowIndex) {
        this.data.removeRow(rowIndex);
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable rowKey) {
        this.data.removeRow(rowKey);
        this.fireDatasetChanged();
    }

    public void removeColumn(int columnIndex) {
        this.data.removeColumn(columnIndex);
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable columnKey) {
        this.data.removeColumn(columnKey);
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public Number getValue(int row, int column) {
        return this.data.getValue(row, column);
    }

    public Comparable getRowKey(int row) {
        return this.data.getRowKey(row);
    }

    public int getRowIndex(Comparable key) {
        return this.data.getRowIndex(key);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public Comparable getColumnKey(int column) {
        return this.data.getColumnKey(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.data.getColumnIndex(key);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.data.getValue(rowKey, columnKey);
    }

    public int getExtractMode() {
        return this.extract;
    }

    public void setExtractMode(int extractMode) {
        this.extract = extractMode;
    }

    public List getList(Comparable key) {
        ArrayList elements = new ArrayList();
        for (int i = 0; i < (this.extract == 0 ? this.getColumnCount() : this.getRowCount()); ++i) {
            List n;
            List list = n = this.extract == 0 ? this.getList(key, this.getColumnKey(i)) : this.getList(this.getRowKey(i), key);
            if (n == null) continue;
            elements.addAll(n);
        }
        return elements;
    }

    public List getList(Comparable key, int pieindex) {
        List elements = this.extract == 0 ? this.getList(key, this.getColumnKey(pieindex)) : this.getList(this.getRowKey(pieindex), key);
        return elements;
    }

    public int getItemCount() {
        return this.extract == 0 ? this.getRowCount() : this.getColumnCount();
    }

    public Number getValue(int item) {
        double val = 0.0;
        boolean isnull = true;
        for (int i = 0; i < (this.extract == 0 ? this.getColumnCount() : this.getRowCount()); ++i) {
            Number n;
            Number number = n = this.extract == 0 ? (Number)this.getValue(item, i) : (Number)this.getValue(i, item);
            if (n == null) continue;
            val += n.doubleValue();
            isnull = false;
        }
        return isnull ? null : Double.valueOf(val);
    }

    public int getIndex(Comparable key) {
        return this.extract == 0 ? this.getRowIndex(key) : this.getColumnIndex(key);
    }

    public Comparable getKey(int item) {
        return this.extract == 0 ? this.getRowKey(item) : this.getColumnKey(item);
    }

    public List getKeys() {
        return Collections.unmodifiableList(this.extract == 0 ? this.getRowKeys() : this.getColumnKeys());
    }

    public Number getValue(Comparable key) {
        return this.getValue(this.extract == 0 ? this.getRowIndex(key) : this.getColumnIndex(key));
    }

    private Comparable convertNull(Comparable text) {
        return text == null ? this.nullValueString : text;
    }
}

