/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilterMenu;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.chart.CategoryPieDataset;
import jadex.tools.comanalyzer.chart.ChartGroupedStackedBarRenderer;
import jadex.tools.comanalyzer.chart.ChartLabelGenerator;
import jadex.tools.comanalyzer.chart.ChartMultiplePiePlot;
import jadex.tools.comanalyzer.chart.ChartSubCategoryAxis;
import jadex.tools.comanalyzer.chart.GroupedCategoryDataset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.TableOrder;

public class ChartCanvas
extends ToolCanvas {
    public static final int CHARTTYPE_PIECHART = 0;
    public static final int CHARTTYPE_BARCHART = 1;
    protected List visible_messages = new ArrayList();
    protected List visible_components = new ArrayList();
    protected CategoryPieDataset dataset_sent = new CategoryPieDataset();
    protected CategoryPieDataset dataset_received = new CategoryPieDataset();
    protected CategoryPieDataset dataset_total = new CategoryPieDataset();
    protected ChartPanel chartPanel;
    protected JFreeChart chart = this.chartType == 0 ? this.createPieChart() : this.createBarChart();
    protected int chartType = 0;
    protected int paintMode = 1;
    protected boolean showLabels = true;
    protected boolean showLegend = true;
    protected boolean forceLabels = false;

    public ChartCanvas(ToolTab tool) {
        super(tool);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setMouseZoomable(true, true);
        this.chartPanel.setPopupMenu(null);
        this.setLayout(new BorderLayout());
        this.add("Center", (java.awt.Component)this.chartPanel);
        this.chartPanel.addMouseListener((MouseListener)new ChartMouseListener());
    }

    @Override
    public void updateMessage(Message message, boolean isPresent) {
        if (message.getEndpoints() != null) {
            if (!this.visible_messages.contains(message)) {
                this.addMessage(message);
            }
        } else if (isPresent) {
            this.removeMessage(message);
        }
    }

    @Override
    public void removeMessage(Message message) {
        String type = null;
        switch (this.paintMode) {
            case 1: {
                type = "conversation_id";
                break;
            }
            case 2: {
                type = "performative";
                break;
            }
            case 3: {
                type = "protocol";
            }
        }
        if (this.paintMode == 4) {
            this.dataset_sent.removeElement(message, (Comparable)((Object)"sent"), message.getSender());
            this.dataset_received.removeElement(message, (Comparable)((Object)"received"), message.getReceiver());
            this.dataset_total.removeElement(message, (Comparable)((Object)"sent"), message.getSender());
            this.dataset_total.removeElement(message, (Comparable)((Object)"received"), message.getReceiver());
        } else {
            String key = (String)message.getParameter(type);
            this.dataset_sent.removeElement(message, (Comparable)((Object)key), message.getSender());
            this.dataset_received.removeElement(message, (Comparable)((Object)key), message.getReceiver());
            this.dataset_total.removeElement(message, (Comparable)((Object)type), (Comparable)((Object)key));
        }
        this.visible_messages.remove(message);
    }

    @Override
    public void updateComponent(Component agent, boolean update) {
        if (agent.isVisible()) {
            if (!this.visible_components.contains(agent)) {
                this.addAgent(agent);
            }
        } else if (update) {
            this.removeComponent(agent);
        }
    }

    @Override
    public void removeComponent(Component agent) {
        this.visible_components.remove(agent);
    }

    @Override
    public void clear() {
        this.dataset_sent.clear();
        this.dataset_received.clear();
        this.dataset_total.clear();
        this.visible_messages.clear();
        this.visible_components.clear();
    }

    @Override
    public void repaintCanvas() {
        this.chart.fireChartChanged();
    }

    public void addAgent(Component agent) {
        this.visible_components.add(agent);
    }

    public void addMessage(Message message) {
        String type = null;
        switch (this.paintMode) {
            case 1: {
                type = "conversation_id";
                break;
            }
            case 2: {
                type = "performative";
                break;
            }
            case 3: {
                type = "protocol";
            }
        }
        if (this.paintMode == 4) {
            this.dataset_sent.addElement(message, (Comparable)((Object)"sent"), message.getSender());
            this.dataset_received.addElement(message, (Comparable)((Object)"received"), message.getReceiver());
            this.dataset_total.addElement(message, (Comparable)((Object)"sent"), message.getSender());
            this.dataset_total.addElement(message, (Comparable)((Object)"received"), message.getReceiver());
        } else {
            String key = (String)message.getParameter(type);
            this.dataset_sent.addElement(message, (Comparable)((Object)key), message.getSender());
            this.dataset_received.addElement(message, (Comparable)((Object)key), message.getReceiver());
            this.dataset_total.addElement(message, (Comparable)((Object)type), (Comparable)((Object)key));
        }
        this.visible_messages.add(message);
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
        Plot plot = this.chart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryPlot catplot = (CategoryPlot)plot;
            ((ChartGroupedStackedBarRenderer)catplot.getRenderer()).setPaintMode(paintMode);
        }
        if (plot instanceof ChartMultiplePiePlot) {
            ChartMultiplePiePlot pieplot = (ChartMultiplePiePlot)plot;
            pieplot.setPaintMode(paintMode);
        }
        this.dataset_sent.clear();
        this.dataset_received.clear();
        this.dataset_total.clear();
        ArrayList agents = new ArrayList(this.visible_components);
        ArrayList messages = new ArrayList(this.visible_messages);
        this.visible_components.clear();
        this.visible_messages.clear();
        for (Component agent : agents) {
            this.addAgent(agent);
        }
        for (Message message : messages) {
            this.addMessage(message);
        }
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
        if (this.chart.getPlot() instanceof CategoryPlot) {
            GroupedCategoryDataset dataset = (GroupedCategoryDataset)this.chart.getCategoryPlot().getDataset();
            dataset.cleanup();
            ((CategoryPlot)this.chart.getPlot()).setDataset(null);
        }
        if (this.chart.getPlot() instanceof MultiplePiePlot) {
            ((MultiplePiePlot)this.chart.getPlot()).setDataset(null);
        }
        this.chart = chartType == 0 ? this.createPieChart() : this.createBarChart();
        this.chartPanel.setChart(this.chart);
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        Plot plot = this.chart.getPlot();
        if (plot instanceof MultiplePiePlot) {
            PiePlot pieplot = (PiePlot)((MultiplePiePlot)plot).getPieChart().getPlot();
            ChartLabelGenerator generator = new ChartLabelGenerator("{0} = {2} ({3})");
            generator.setDefaultRenderer(Component.class, new AgentKeyRenderer());
            pieplot.setLabelGenerator((PieSectionLabelGenerator)(showLabels ? generator : null));
        }
        if (plot instanceof CategoryPlot) {
            ((CategoryPlot)plot).getRenderer().setBaseItemLabelsVisible(showLabels);
        }
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
        if (showLegend) {
            this.chart.addLegend(this.createLegend(this.chart.getPlot()));
        } else {
            this.chart.removeLegend();
        }
    }

    public boolean isForceLabels() {
        return this.forceLabels;
    }

    public void setForceLabels(boolean forceLabels) {
        this.forceLabels = forceLabels;
        if (this.chartType == 0) {
            return;
        }
        BarRenderer renderer = (BarRenderer)this.chart.getCategoryPlot().getRenderer();
        if (forceLabels) {
            ItemLabelPosition itemlabelposition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            renderer.setPositiveItemLabelPositionFallback(itemlabelposition);
            renderer.setNegativeItemLabelPositionFallback(itemlabelposition);
        } else {
            renderer.setNegativeItemLabelPositionFallback(null);
            renderer.setPositiveItemLabelPositionFallback(null);
        }
    }

    private JFreeChart createBarChart() {
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ChartSubCategoryAxis categoryAxis = new ChartSubCategoryAxis(null);
        categoryAxis.setCategoryMargin(0.1);
        ChartGroupedStackedBarRenderer renderer = new ChartGroupedStackedBarRenderer(this.tooltab.getPaintMaps());
        renderer.setPaintMode(this.paintMode);
        renderer.setItemMargin(0.04);
        ChartLabelGenerator generator_simple = new ChartLabelGenerator("{0}");
        generator_simple.setDefaultRenderer(Component.class, new AgentKeyRenderer());
        generator_simple.setDefaultRenderer(String.class, new GroupKeyRenderer());
        ChartLabelGenerator generator_advanced = new ChartLabelGenerator("{0} = {2} ({3})");
        generator_advanced.setDefaultRenderer(Component.class, new AgentKeyRenderer());
        generator_advanced.setDefaultRenderer(String.class, new GroupKeyRenderer());
        renderer.setLegendItemLabelGenerator(generator_simple);
        renderer.setBaseItemLabelGenerator(generator_simple);
        renderer.setBaseToolTipGenerator(generator_advanced);
        renderer.setBaseItemLabelsVisible(this.showLabels);
        renderer.setDrawBarOutline(false);
        ItemLabelPosition itemlabelposition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        renderer.setPositiveItemLabelPositionFallback((ItemLabelPosition)(this.forceLabels ? itemlabelposition : null));
        renderer.setNegativeItemLabelPositionFallback((ItemLabelPosition)(this.forceLabels ? itemlabelposition : null));
        CategoryPlot plot = new CategoryPlot(null, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(null, null, (Plot)plot, false);
        GroupedCategoryDataset combined = new GroupedCategoryDataset(chart);
        combined.addCategoryDataset(this.dataset_sent, "sent");
        combined.addCategoryDataset(this.dataset_received, "received");
        plot.setDataset((CategoryDataset)combined);
        if (this.showLegend) {
            chart.addLegend(this.createLegend((Plot)plot));
        }
        return chart;
    }

    private JFreeChart createPieChart() {
        ChartMultiplePiePlot plot = new ChartMultiplePiePlot(this.dataset_total, this.tooltab.getPaintMaps());
        plot.setPaintMode(this.paintMode);
        plot.setDataExtractOrder(TableOrder.BY_ROW);
        ChartLabelGenerator generator_simple = new ChartLabelGenerator("{0}");
        generator_simple.setDefaultRenderer(Component.class, new AgentKeyRenderer());
        ChartLabelGenerator generator_advanced = new ChartLabelGenerator("{0} = {2} ({3})");
        generator_advanced.setDefaultRenderer(Component.class, new AgentKeyRenderer());
        plot.setLegendItemLabelGenerator(generator_simple);
        PiePlot pieplot = (PiePlot)plot.getPieChart().getPlot();
        pieplot.setLabelGenerator((PieSectionLabelGenerator)(this.showLabels ? generator_advanced : null));
        pieplot.setToolTipGenerator((PieToolTipGenerator)generator_advanced);
        pieplot.setIgnoreNullValues(true);
        JFreeChart chart = new JFreeChart(null, null, (Plot)plot, false);
        if (this.showLegend) {
            chart.addLegend(this.createLegend((Plot)plot));
        }
        return chart;
    }

    private LegendTitle createLegend(Plot plot) {
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legend.setFrame((BlockFrame)new LineBorder());
        legend.setBackgroundPaint((Paint)Color.white);
        legend.setPosition(RectangleEdge.BOTTOM);
        return legend;
    }

    public static final class AgentKeyRenderer
    implements ChartLabelGenerator.KeyRenderer {
        @Override
        public String render(Comparable key) {
            return ((Component)key).getId();
        }
    }

    private final class GroupKeyRenderer
    implements ChartLabelGenerator.KeyRenderer {
        private GroupKeyRenderer() {
        }

        @Override
        public String render(Comparable key) {
            GroupedCategoryDataset dataset = (GroupedCategoryDataset)ChartCanvas.this.chart.getCategoryPlot().getDataset();
            Comparable orgRowKey = dataset.getOriginalRowKey(key);
            return orgRowKey.toString();
        }
    }

    protected final class ChartMouseListener
    extends MouseAdapter {
        protected ChartMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                CategoryItemEntity entity;
                ChartEntity ce = ChartCanvas.this.chartPanel.getEntityForPoint(e.getX(), e.getY());
                List messages = null;
                if (ce instanceof CategoryItemEntity) {
                    entity = (CategoryItemEntity)ce;
                    GroupedCategoryDataset dataset = (GroupedCategoryDataset)entity.getDataset();
                    messages = dataset.getList(entity.getRowKey(), entity.getColumnKey());
                }
                if (ce instanceof PieSectionEntity) {
                    entity = (PieSectionEntity)ce;
                    messages = ChartCanvas.this.dataset_total.getList(entity.getSectionKey(), entity.getPieIndex());
                }
                if (messages != null) {
                    MessageFilterMenu mpopup = new MessageFilterMenu(ChartCanvas.this.tooltab.getPlugin(), messages.toArray(new Message[messages.size()]));
                    mpopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

