/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.tools.comanalyzer.PaintMaps;
import jadex.tools.comanalyzer.chart.GroupedCategoryDataset;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.LegendItem;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;

public class ChartGroupedStackedBarRenderer
extends GroupedStackedBarRenderer {
    protected DrawingSupplier drawingSupplier;
    protected PaintMaps paintMaps;
    protected int paintMode;
    protected Map sectionPaints;

    public ChartGroupedStackedBarRenderer(PaintMaps paintMaps) {
        this.paintMaps = paintMaps;
        this.sectionPaints = new HashMap();
        this.drawingSupplier = new DefaultDrawingSupplier();
    }

    public Paint getItemPaint(int row, int column) {
        GroupedCategoryDataset dataset = (GroupedCategoryDataset)this.getPlot().getDataset();
        if (this.paintMode == 4) {
            Comparable key = dataset.getColumnKey(column);
            return this.lookupSeriesPaint(key);
        }
        Comparable rowKey = dataset.getRowKey(row);
        Comparable key = dataset.getOriginalRowKey(rowKey);
        return this.lookupSeriesPaint(key);
    }

    public Paint lookupSeriesPaint(int series) {
        GroupedCategoryDataset dataset = (GroupedCategoryDataset)this.getPlot().getDataset();
        Comparable rowKey = dataset.getRowKey(series);
        Comparable key = dataset.getOriginalRowKey(rowKey);
        return this.lookupSeriesPaint(key);
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        return super.getLegendItem(datasetIndex, series);
    }

    public Paint lookupSeriesPaint(Comparable key) {
        return this.paintMaps.getPaint(key, this.paintMode, Color.LIGHT_GRAY);
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
        this.sectionPaints.clear();
        this.drawingSupplier = new DefaultDrawingSupplier();
    }
}

