/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import java.text.AttributedString;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.DataUtilities;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class ChartLabelGenerator
implements PieSectionLabelGenerator,
PieToolTipGenerator,
CategorySeriesLabelGenerator,
CategoryItemLabelGenerator,
CategoryToolTipGenerator {
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({2}, {3})";
    public static final String DEFAULT_ITEM_LABEL_FORMAT = "{0} = {2} ({3})";
    protected Hashtable defaultRenderer;
    private String labelFormat;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;
    private String nullValueString;

    public ChartLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT, null, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance(), "null");
    }

    public ChartLabelGenerator(String labelFormat) {
        this(labelFormat, null, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance(), "null");
    }

    public ChartLabelGenerator(String labelFormat, DateFormat dateFormat, NumberFormat numberFormat, NumberFormat percentFormat, String nullValueString) {
        this.labelFormat = labelFormat;
        this.dateFormat = dateFormat;
        this.numberFormat = numberFormat;
        this.percentFormat = percentFormat;
        this.nullValueString = nullValueString;
        this.createDefaultRenderers();
    }

    public AttributedString generateAttributedSectionLabel(PieDataset dataset, Comparable key) {
        return null;
    }

    public String generateSectionLabel(PieDataset dataset, Comparable key) {
        String result = null;
        if (dataset != null) {
            Object[] items = this.createItemArray(dataset, key);
            result = MessageFormat.format(this.labelFormat, items);
        }
        return result;
    }

    public String generateToolTip(PieDataset dataset, Comparable key) {
        return this.generateSectionLabel(dataset, key);
    }

    public String generateLabel(CategoryDataset dataset, int series) {
        return this.generateRowLabel(dataset, series);
    }

    public String generateRowLabel(CategoryDataset dataset, int row) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String label = MessageFormat.format(this.labelFormat, this.createRowItemArray(dataset, row));
        return label;
    }

    public String generateColumnLabel(CategoryDataset dataset, int column) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String label = MessageFormat.format(this.labelFormat, this.createColumnItemArray(dataset, column));
        return label;
    }

    public String generateLabel(CategoryDataset dataset, int row, int column) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result = null;
        Object[] items = this.createItemArray(dataset, row, column);
        result = MessageFormat.format(this.labelFormat, items);
        return result;
    }

    public String generateToolTip(CategoryDataset dataset, int row, int column) {
        return this.generateLabel(dataset, row, column);
    }

    protected Object[] createColumnItemArray(CategoryDataset dataset, int column) {
        Object[] result = new Object[]{this.getRenderedKeyString(dataset.getColumnKey(column))};
        return result;
    }

    protected Object[] createRowItemArray(CategoryDataset dataset, int row) {
        Object[] result = new Object[]{this.getRenderedKeyString(dataset.getRowKey(row))};
        return result;
    }

    protected Object[] createItemArray(PieDataset dataset, Comparable key) {
        double v;
        Object[] result = new Object[5];
        double total = DatasetUtilities.calculatePieDatasetTotal((PieDataset)dataset);
        result[0] = this.getRenderedKeyString(key);
        result[1] = null;
        Number value = dataset.getValue(key);
        result[2] = value != null ? this.numberFormat.format(value) : this.nullValueString;
        double percent = 0.0;
        if (value != null && (v = value.doubleValue()) > 0.0) {
            percent = v / total;
        }
        result[3] = this.percentFormat.format(percent);
        result[4] = this.numberFormat.format(total);
        return result;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[5];
        result[0] = this.getRenderedKeyString(dataset.getRowKey(row));
        result[1] = this.getRenderedKeyString(dataset.getColumnKey(column));
        Number value = dataset.getValue(row, column);
        if (value != null) {
            if (this.numberFormat != null) {
                result[2] = this.numberFormat.format(value);
            } else if (this.dateFormat != null) {
                result[2] = this.dateFormat.format(value);
            }
        } else {
            result[2] = this.nullValueString;
        }
        if (value != null) {
            double total = DataUtilities.calculateColumnTotal((Values2D)dataset, (int)column);
            double percent = value.doubleValue() / total;
            result[3] = this.percentFormat.format(percent);
            result[4] = total;
        }
        return result;
    }

    public void setDefaultRenderer(Class columnClass, KeyRenderer renderer) {
        if (renderer != null) {
            this.defaultRenderer.put(columnClass, renderer);
        } else {
            this.defaultRenderer.remove(columnClass);
        }
    }

    public KeyRenderer getDefaultRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object renderer = this.defaultRenderer.get(clazz);
        if (renderer != null) {
            return (KeyRenderer)renderer;
        }
        return this.getDefaultRenderer(clazz.getSuperclass());
    }

    private String getRenderedKeyString(Comparable key) {
        KeyRenderer renderer = this.getDefaultRenderer(key.getClass());
        return renderer.render(key);
    }

    private void createDefaultRenderers() {
        this.defaultRenderer = new Hashtable();
        this.defaultRenderer.put(Object.class, new DefaultKeyRenderer());
    }

    public static interface KeyRenderer {
        public String render(Comparable var1);
    }

    private class DefaultKeyRenderer
    implements KeyRenderer {
        private DefaultKeyRenderer() {
        }

        @Override
        public String render(Comparable key) {
            return key.toString();
        }
    }
}

