/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.tools.comanalyzer.PaintMaps;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.TableOrder;

public class ChartMultiplePiePlot
extends MultiplePiePlot {
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private CategoryToolTipGenerator baseToolTipGenerator;
    private CategoryURLGenerator baseItemURLGenerator;
    private CategoryItemLabelGenerator legendItemLabelGenerator;
    protected DrawingSupplier drawingSupplier;
    protected PaintMaps paintMaps;
    protected int paintMode;
    protected Map sectionPaints;

    public ChartMultiplePiePlot(CategoryDataset dataset, PaintMaps paintMaps) {
        super(dataset);
        this.paintMaps = paintMaps;
        this.sectionPaints = new HashMap();
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.baseItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        this.legendItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        dataset.addChangeListener((DatasetChangeListener)this);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        int displayRows;
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        if (DatasetUtilities.isEmptyOrNull((CategoryDataset)this.getDataset())) {
            this.drawNoDataMessage(g2, area);
            return;
        }
        int pieCount = 0;
        pieCount = this.getDataExtractOrder() == TableOrder.BY_ROW ? this.getDataset().getRowCount() : this.getDataset().getColumnCount();
        int displayCols = (int)Math.ceil(Math.sqrt(pieCount));
        if (displayCols > (displayRows = (int)Math.ceil((double)pieCount / (double)displayCols)) && area.getWidth() < area.getHeight()) {
            int temp = displayCols;
            displayCols = displayRows;
            displayRows = temp;
        }
        this.prefetchSectionPaints();
        int x = (int)area.getX();
        int y = (int)area.getY();
        int width = (int)area.getWidth() / displayCols;
        int height = (int)area.getHeight() / displayRows;
        int row = 0;
        int column = 0;
        int diff = displayRows * displayCols - pieCount;
        int xoffset = 0;
        Rectangle rect = new Rectangle();
        for (int pieIndex = 0; pieIndex < pieCount; ++pieIndex) {
            rect.setBounds(x + xoffset + width * column, y + height * row, width, height);
            String title = null;
            title = this.getDataExtractOrder() == TableOrder.BY_ROW ? this.getDataset().getRowKey(pieIndex).toString() : this.getDataset().getColumnKey(pieIndex).toString();
            this.getPieChart().setTitle(title);
            Object piedataset = null;
            CategoryToPieDataset dd = new CategoryToPieDataset(this.getDataset(), this.getDataExtractOrder(), pieIndex);
            piedataset = this.getLimit() > 0.0 ? DatasetUtilities.createConsolidatedPieDataset((PieDataset)dd, (Comparable)this.getAggregatedItemsKey(), (double)this.getLimit()) : dd;
            PiePlot piePlot = (PiePlot)this.getPieChart().getPlot();
            piePlot.setDataset((PieDataset)piedataset);
            piePlot.setPieIndex(pieIndex);
            for (int i = 0; i < piedataset.getItemCount(); ++i) {
                Comparable key = piedataset.getKey(i);
                Paint p = key.equals(this.getAggregatedItemsKey()) ? this.getAggregatedItemsPaint() : (Paint)this.sectionPaints.get(key);
                piePlot.setSectionPaint(key, p);
            }
            ChartRenderingInfo subinfo = null;
            if (info != null) {
                subinfo = new ChartRenderingInfo();
            }
            this.getPieChart().draw(g2, (Rectangle2D)rect, subinfo);
            if (info != null) {
                info.getOwner().getEntityCollection().addAll(subinfo.getEntityCollection());
                info.addSubplotInfo(subinfo.getPlotInfo());
            }
            if (++column != displayCols) continue;
            column = 0;
            if (++row != displayRows - 1 || diff == 0) continue;
            xoffset = diff * width / 2;
        }
    }

    private void prefetchSectionPaints() {
        if (this.getDataExtractOrder() == TableOrder.BY_ROW) {
            for (int c = 0; c < this.getDataset().getColumnCount(); ++c) {
                Comparable key = this.getDataset().getColumnKey(c);
                Paint p = null;
                if (p == null && (p = this.lookupSectionPaint(key)) == null) {
                    p = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(key, p);
            }
        } else {
            for (int r = 0; r < this.getDataset().getRowCount(); ++r) {
                Comparable key = this.getDataset().getRowKey(r);
                Paint p = null;
                if (p == null && (p = this.lookupSectionPaint(key)) == null) {
                    p = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(key, p);
            }
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.getDataset() != null) {
            List keys = null;
            this.prefetchSectionPaints();
            if (this.getDataExtractOrder() == TableOrder.BY_ROW) {
                keys = this.getDataset().getColumnKeys();
            } else if (this.getDataExtractOrder() == TableOrder.BY_COLUMN) {
                keys = this.getDataset().getRowKeys();
            }
            if (keys != null) {
                for (Comparable key : keys) {
                    String label = null;
                    if (this.getDataExtractOrder() == TableOrder.BY_COLUMN) {
                        int row = this.getDataset().getRowIndex(key);
                        label = this.getLegendItemLabelGenerator().generateRowLabel(this.getDataset(), row);
                    } else if (this.getDataExtractOrder() == TableOrder.BY_ROW) {
                        int column = this.getDataset().getColumnIndex(key);
                        label = this.getLegendItemLabelGenerator().generateColumnLabel(this.getDataset(), column);
                    }
                    if (label == null) continue;
                    String description = label;
                    Paint paint = (Paint)this.sectionPaints.get(key);
                    LegendItem item = new LegendItem(label, description, null, null, Plot.DEFAULT_LEGEND_ITEM_CIRCLE, paint, Plot.DEFAULT_OUTLINE_STROKE, paint);
                    item.setDataset((Dataset)this.getDataset());
                    result.add(item);
                }
            }
            if (this.getLimit() > 0.0) {
                result.add(new LegendItem(this.getAggregatedItemsKey().toString(), this.getAggregatedItemsKey().toString(), null, null, Plot.DEFAULT_LEGEND_ITEM_CIRCLE, this.getAggregatedItemsPaint(), Plot.DEFAULT_OUTLINE_STROKE, this.getAggregatedItemsPaint()));
            }
        }
        return result;
    }

    protected Paint lookupSectionPaint(Comparable key) {
        return this.paintMaps.getPaint(key, this.paintMode, Color.LIGHT_GRAY);
    }

    public PiePlot getPiePlot() {
        return (PiePlot)this.getPieChart().getPlot();
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
        this.sectionPaints.clear();
        this.drawingSupplier = new DefaultDrawingSupplier();
    }

    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator baseItemLabelGenerator) {
        this.baseItemLabelGenerator = baseItemLabelGenerator;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator baseItemURLGenerator) {
        this.baseItemURLGenerator = baseItemURLGenerator;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public CategoryToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(CategoryToolTipGenerator baseToolTipGenerator) {
        this.baseToolTipGenerator = baseToolTipGenerator;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public CategoryItemLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(CategoryItemLabelGenerator legendItemLabelGenerator) {
        this.legendItemLabelGenerator = legendItemLabelGenerator;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }
}

