/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.commons.SUtil;
import jadex.commons.gui.SGUI;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.chart.ChartCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class ChartPanel
extends ToolTab
implements ActionListener {
    protected ChartCanvas panelcan = new ChartCanvas(this);
    private JScrollPane options = new JScrollPane();
    private JSplitPane main;
    private JRadioButton g_mgraph;
    private JRadioButton g_dgraph;
    private JCheckBox l_labels;
    private JCheckBox l_legend;
    private JRadioButton d_message;
    private JRadioButton d_convid;
    private JRadioButton d_perform;
    private JRadioButton d_protocol;
    private JCheckBox l_label_force;

    public ChartPanel(ComanalyzerPlugin plugin) {
        super(plugin, "Chart", null);
        this.addBottomControls(this.options);
        this.main = new JSplitPane(1, this.panelcan, new JScrollPane(this.options));
        this.main.setOneTouchExpandable(true);
        this.main.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add("North", SGUI.createToolBar((String)"BDI Viewer Options", (Action[])this.getActions()));
        this.add("Center", this.main);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double scrollWidth;
                double optionsWidth;
                double mainWidth = ChartPanel.this.main.getSize().getWidth();
                double loc = (mainWidth - (optionsWidth = ChartPanel.this.options.getPreferredSize().getWidth()) - (scrollWidth = ChartPanel.this.options.getVerticalScrollBar().isVisible() ? (double)ChartPanel.this.options.getVerticalScrollBar().getWidth() : 0.0)) / mainWidth;
                if (loc >= 0.0 && loc <= 1.0) {
                    ChartPanel.this.main.setDividerLocation(loc);
                }
            }
        });
    }

    @Override
    public ToolCanvas getCanvas() {
        return this.panelcan;
    }

    @Override
    public Action[] getActions() {
        if (this.actions == null) {
            List actionlist = SUtil.arrayToList((Object)super.getActions());
            this.actions = actionlist.toArray(new Action[actionlist.size()]);
        }
        return this.actions;
    }

    protected void addBottomControls(JScrollPane options) {
        JPanel control_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        Box graph_panel = Box.createVerticalBox();
        graph_panel.setBorder(BorderFactory.createTitledBorder("Chart"));
        ButtonGroup bg_graph = new ButtonGroup();
        this.g_mgraph = new JRadioButton("Pie Chart");
        this.g_mgraph.setSelected(this.panelcan.chartType == 0);
        this.g_mgraph.addActionListener(this);
        this.g_dgraph = new JRadioButton("Bar Chart");
        this.g_dgraph.setSelected(this.panelcan.chartType == 1);
        this.g_dgraph.addActionListener(this);
        bg_graph.add(this.g_mgraph);
        bg_graph.add(this.g_dgraph);
        graph_panel.add(this.g_mgraph);
        graph_panel.add(this.g_dgraph);
        control_panel.add((Component)graph_panel, gbc);
        Box layout_panel = Box.createVerticalBox();
        layout_panel.setBorder(BorderFactory.createTitledBorder("Layout"));
        JPanel v_label_panel = new JPanel(new GridLayout(2, 0));
        this.l_labels = new JCheckBox("Show Labels");
        this.l_labels.setSelected(this.panelcan.showLabels);
        this.l_labels.addActionListener(this);
        this.l_label_force = new JCheckBox("Force Labels");
        this.l_label_force.setEnabled(this.l_labels.isSelected() && this.panelcan.chartType != 0);
        this.l_label_force.setSelected(this.panelcan.forceLabels);
        this.l_label_force.addActionListener(this);
        v_label_panel.add(this.l_labels);
        v_label_panel.add(this.l_label_force);
        JPanel v_legend_panel = new JPanel(new GridLayout(1, 0));
        this.l_legend = new JCheckBox("Show Legend");
        this.l_legend.setSelected(this.panelcan.showLegend);
        this.l_legend.addActionListener(this);
        v_legend_panel.add(this.l_legend);
        layout_panel.add(v_label_panel);
        layout_panel.add(v_legend_panel);
        control_panel.add((Component)layout_panel, gbc);
        JPanel color_panel = new JPanel(new GridLayout(4, 0));
        color_panel.setBorder(BorderFactory.createTitledBorder("Distribution Of"));
        ButtonGroup bg_colors = new ButtonGroup();
        this.d_message = new JRadioButton("Messages");
        this.d_message.setSelected(this.panelcan.getPaintMode() == 4);
        this.d_message.addActionListener(this);
        this.d_convid = new JRadioButton("Converstation");
        this.d_convid.setSelected(this.panelcan.getPaintMode() == 1);
        this.d_convid.addActionListener(this);
        this.d_perform = new JRadioButton("Performative");
        this.d_perform.setSelected(this.panelcan.getPaintMode() == 2);
        this.d_perform.addActionListener(this);
        this.d_protocol = new JRadioButton("Protocol");
        this.d_protocol.setSelected(this.panelcan.getPaintMode() == 3);
        this.d_protocol.addActionListener(this);
        bg_colors.add(this.d_message);
        bg_colors.add(this.d_convid);
        bg_colors.add(this.d_perform);
        bg_colors.add(this.d_protocol);
        color_panel.add(this.d_message);
        color_panel.add(this.d_convid);
        color_panel.add(this.d_perform);
        color_panel.add(this.d_protocol);
        control_panel.add((Component)color_panel, gbc);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)control_panel, "North");
        options.setViewportView(jp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.g_mgraph) {
            this.panelcan.setChartType(0);
            this.l_label_force.setEnabled(this.l_labels.isSelected() && this.panelcan.chartType != 0);
        } else if (source == this.g_dgraph) {
            this.panelcan.setChartType(1);
            this.l_label_force.setEnabled(this.l_labels.isSelected() && this.panelcan.chartType != 0);
        } else if (source == this.l_labels) {
            this.panelcan.setShowLabels(source.isSelected());
            this.l_label_force.setEnabled(source.isSelected() && this.panelcan.chartType != 0);
            this.panelcan.chartPanel.repaint();
        } else if (source == this.l_label_force) {
            this.panelcan.setForceLabels(source.isSelected());
        } else if (source == this.l_legend) {
            this.panelcan.setShowLegend(source.isSelected());
        } else if (source == this.d_message) {
            this.panelcan.setPaintMode(4);
        } else if (source == this.d_convid) {
            this.panelcan.setPaintMode(1);
        } else if (source == this.d_perform) {
            this.panelcan.setPaintMode(2);
        } else if (source == this.d_protocol) {
            this.panelcan.setPaintMode(3);
        }
    }
}

