/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ShapeUtilities;

public class ChartSubCategoryAxis
extends SubCategoryAxis {
    private CategoryLabelPositions usedCategoryLabelPositions;

    public ChartSubCategoryAxis(String label) {
        super(label);
    }

    public ChartSubCategoryAxis() {
        super(null);
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            return new AxisState(cursor);
        }
        if (!this.isTickLabelsVisible()) {
            return super.draw(g2, cursor, plotArea, dataArea, edge, plotState);
        }
        if (this.usedCategoryLabelPositions == null) {
            this.usedCategoryLabelPositions = this.getCategoryLabelPositions();
        }
        double max = 0.0;
        float l = 0.0f;
        float r = 0.0f;
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        CategoryDataset dataset = plot.getDataset();
        List categories = plot.getCategoriesForAxis((CategoryAxis)this);
        CategoryLabelPosition position = this.usedCategoryLabelPositions.getLabelPosition(edge);
        r = this.getMaximumCategoryLabelWidthRatio();
        if ((double)r <= 0.0) {
            r = position.getWidthRatio();
        }
        l = position.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(categories.size(), dataArea, edge) : (RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? (float)dataArea.getWidth() : (float)dataArea.getHeight());
        for (Comparable category : categories) {
            CategoryItemLabelGenerator generator = plot.getRenderer().getBaseItemLabelGenerator();
            String text = generator != null ? generator.generateColumnLabel(dataset, dataset.getColumnIndex(category)) : category.toString();
            FontMetrics fm = g2.getFontMetrics();
            int textWidth = fm.stringWidth(text);
            int textHeight = fm.getHeight();
            RectangleInsets insets = this.getTickLabelInsets();
            Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, textWidth, textHeight);
            Shape rotatedBox = ShapeUtilities.rotateShape((Shape)box, (double)position.getAngle(), (float)0.0f, (float)0.0f);
            max = Math.max(max, rotatedBox.getBounds2D().getWidth() + insets.getTop() + insets.getBottom());
        }
        if (max > (double)(l * r) && this.usedCategoryLabelPositions == this.getCategoryLabelPositions()) {
            this.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.45));
            return new AxisState(cursor);
        }
        if (max < (double)(l * r) && this.usedCategoryLabelPositions != this.getCategoryLabelPositions()) {
            this.setCategoryLabelPositions(this.usedCategoryLabelPositions);
            return new AxisState(cursor);
        }
        return super.draw(g2, cursor, plotArea, dataArea, edge, plotState);
    }

    protected TextBlock createLabel(Comparable category, float width, RectangleEdge edge, Graphics2D g2) {
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        CategoryDataset dataset = plot.getDataset();
        CategoryItemLabelGenerator generator = plot.getRenderer().getBaseItemLabelGenerator();
        String text = generator != null ? generator.generateColumnLabel(dataset, dataset.getColumnIndex(category)) : category.toString();
        TextBlock label = TextUtilities.createTextBlock((String)text, (Font)this.getTickLabelFont(category), (Paint)this.getTickLabelPaint(category), (float)width, (int)this.getMaximumCategoryLabelLines(), (TextMeasurer)new G2TextMeasurer(g2));
        return label;
    }
}

