/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import jadex.tools.comanalyzer.chart.CategoryPieDataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;

public class GroupedCategoryDataset
extends AbstractDataset
implements CategoryDataset,
DatasetChangeListener,
Serializable {
    protected Map datasets = new HashMap();
    protected SubCategoryAxis axis;
    protected GroupedStackedBarRenderer renderer;
    protected KeyToGroupMap keytogroupmap;
    protected List keyToGroup = new ArrayList();
    protected Map keyToRowKey = new HashMap();
    protected Map keyToDataset = new HashMap();

    public GroupedCategoryDataset() {
    }

    public GroupedCategoryDataset(GroupedStackedBarRenderer renderer, SubCategoryAxis axis) {
        this.renderer = renderer;
        this.axis = axis;
    }

    public GroupedCategoryDataset(JFreeChart chart) {
        this.renderer = (GroupedStackedBarRenderer)chart.getCategoryPlot().getRenderer();
        this.axis = (SubCategoryAxis)chart.getCategoryPlot().getDomainAxis();
    }

    public void addCategoryDataset(CategoryDataset dataset, String name) {
        this.datasets.put(dataset, name);
        boolean changed = false;
        for (Comparable key : dataset.getRowKeys()) {
            String groupKey = key + "_" + name;
            if (this.keyToRowKey.containsKey(groupKey)) continue;
            changed = true;
            this.keyToRowKey.put(groupKey, key);
            this.keyToDataset.put(groupKey, dataset);
            if (this.keytogroupmap == null) {
                this.keytogroupmap = new KeyToGroupMap((Comparable)((Object)name));
            }
            this.keytogroupmap.mapKeyToGroup((Comparable)((Object)groupKey), (Comparable)((Object)name));
        }
        if (changed) {
            this.renderer.setSeriesToGroupMap(this.keytogroupmap);
        }
        this.axis.addSubCategory((Comparable)((Object)name));
        dataset.addChangeListener((DatasetChangeListener)this);
    }

    public void cleanup() {
        for (CategoryDataset dataset : this.datasets.keySet()) {
            dataset.removeChangeListener((DatasetChangeListener)this);
        }
        this.datasets.clear();
        this.renderer = null;
        this.axis = null;
    }

    public int getRowCount() {
        return this.getRowKeys().size();
    }

    public int getColumnCount() {
        return this.getColumnKeys().size();
    }

    public List getColumnKeys() {
        HashSet colKeys = new HashSet();
        for (CategoryDataset dataset : this.datasets.keySet()) {
            colKeys.addAll(dataset.getColumnKeys());
        }
        return new ArrayList(colKeys);
    }

    public List getRowKeys() {
        return new ArrayList(this.keyToRowKey.keySet());
    }

    public int getRowIndex(Comparable key) {
        return this.getRowKeys().indexOf(key);
    }

    public int getColumnIndex(Comparable key) {
        return this.getColumnKeys().indexOf(key);
    }

    public Comparable getRowKey(int row) {
        return (Comparable)this.getRowKeys().get(row);
    }

    public Comparable getColumnKey(int column) {
        return (Comparable)this.getColumnKeys().get(column);
    }

    public Number getValue(int row, int column) {
        Comparable rowKey = this.getRowKey(row);
        Comparable columnKey = this.getColumnKey(column);
        Comparable orgRowKey = (Comparable)this.keyToRowKey.get(rowKey);
        CategoryDataset dataset = (CategoryDataset)this.keyToDataset.get(rowKey);
        if (dataset.getColumnKeys().contains(columnKey) && dataset.getRowKeys().contains(orgRowKey)) {
            return dataset.getValue(orgRowKey, columnKey);
        }
        return null;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        CategoryDataset dataset = (CategoryDataset)this.keyToDataset.get(rowKey);
        Comparable orgRowKey = (Comparable)this.keyToRowKey.get(rowKey);
        return dataset.getValue(orgRowKey, columnKey);
    }

    public void datasetChanged(DatasetChangeEvent event) {
        CategoryDataset dataset = (CategoryDataset)event.getDataset();
        if (dataset == null) {
            return;
        }
        boolean changed = false;
        ArrayList<String> newKeys = new ArrayList<String>();
        for (Comparable key : dataset.getRowKeys()) {
            String string = (String)this.datasets.get(dataset);
            String groupKey = key + "_" + string;
            newKeys.add(groupKey);
            if (this.keyToRowKey.containsKey(groupKey)) continue;
            changed = true;
            this.keyToRowKey.put(groupKey, key);
            this.keyToDataset.put(groupKey, dataset);
            if (this.keytogroupmap == null) {
                this.keytogroupmap = new KeyToGroupMap((Comparable)((Object)string));
            }
            this.keytogroupmap.mapKeyToGroup((Comparable)((Object)groupKey), (Comparable)((Object)string));
        }
        ArrayList collection = new ArrayList(this.keyToDataset.entrySet());
        for (Map.Entry entry : collection) {
            if (newKeys.contains(entry.getKey()) || !dataset.equals(entry.getValue())) continue;
            this.keyToDataset.remove(entry.getKey());
            this.keyToRowKey.remove(entry.getKey());
        }
        if (changed) {
            this.renderer.setSeriesToGroupMap(this.keytogroupmap);
        } else {
            this.fireDatasetChanged();
        }
    }

    public List getList(Comparable rowKey, Comparable columnKey) {
        CategoryDataset dataset = (CategoryDataset)this.keyToDataset.get(rowKey);
        Comparable orgRowKey = (Comparable)this.keyToRowKey.get(rowKey);
        if (dataset instanceof CategoryPieDataset) {
            CategoryPieDataset cpdataset = (CategoryPieDataset)dataset;
            return cpdataset.getList(orgRowKey, columnKey);
        }
        return null;
    }

    public Comparable getOriginalRowKey(Comparable rowKey) {
        return (Comparable)this.keyToRowKey.get(rowKey);
    }
}

