/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.KeyedValues2D;
import org.jfree.data.UnknownKeyException;

public class KeyedListsTable
implements KeyedValues2D,
Cloneable,
Serializable {
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private Map rows = new HashMap();
    private boolean sortRowKeys;

    public KeyedListsTable() {
        this(false);
    }

    public KeyedListsTable(boolean sortRowKeys) {
        this.sortRowKeys = sortRowKeys;
    }

    public List getList(Comparable rowKey, Comparable columnKey) {
        if (rowKey == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (columnKey == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + columnKey);
        }
        if (!this.rowKeys.contains(rowKey)) {
            throw new UnknownKeyException("Unrecognised rowKey: " + rowKey);
        }
        List element = null;
        if (this.rows.containsKey(rowKey) && ((Map)this.rows.get(rowKey)).containsKey(columnKey)) {
            element = (List)((Map)this.rows.get(rowKey)).get(columnKey);
        }
        return element;
    }

    public void setList(List list, Comparable rowKey, Comparable columnKey) {
        if (!this.rowKeys.contains(rowKey)) {
            this.rowKeys.add(rowKey);
        }
        if (!this.columnKeys.contains(columnKey)) {
            this.columnKeys.add(columnKey);
        }
        if (!this.rows.containsKey(rowKey)) {
            this.rows.put(rowKey, new HashMap());
        }
        ((Map)this.rows.get(rowKey)).put(columnKey, list);
    }

    public void addToList(Object element, Comparable rowKey, Comparable columnKey) {
        if (!this.rowKeys.contains(rowKey)) {
            this.rowKeys.add(rowKey);
        }
        if (!this.columnKeys.contains(columnKey)) {
            this.columnKeys.add(columnKey);
        }
        if (!this.rows.containsKey(rowKey)) {
            this.rows.put(rowKey, new HashMap());
        }
        if (!((Map)this.rows.get(rowKey)).containsKey(columnKey)) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            ((Map)this.rows.get(rowKey)).put(columnKey, list);
        } else {
            List list = (List)((Map)this.rows.get(rowKey)).get(columnKey);
            list.add(element);
        }
    }

    public void removeList(Comparable rowKey, Comparable columnKey) {
        if (this.rows.containsKey(rowKey)) {
            ((Map)this.rows.get(rowKey)).remove(columnKey);
        }
        if (((Map)this.rows.get(rowKey)).isEmpty()) {
            this.rowKeys.remove(rowKey);
            this.rows.remove(rowKey);
        }
        boolean allNull = true;
        for (Comparable key : this.rows.keySet()) {
            if (!((Map)this.rows.get(key)).containsKey(columnKey)) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            this.columnKeys.remove(columnKey);
        }
        if (this.rows.isEmpty()) {
            this.columnKeys.clear();
        }
    }

    public void removeFromList(Object element, Comparable rowKey, Comparable columnKey) {
        List list;
        if (this.rows.containsKey(rowKey) && (list = (List)((Map)this.rows.get(rowKey)).get(columnKey)) != null) {
            list.remove(element);
            if (list.isEmpty()) {
                this.removeList(rowKey, columnKey);
            }
        }
    }

    public void removeRow(int rowIndex) {
        Comparable rowKey = this.getRowKey(rowIndex);
        this.removeRow(rowKey);
    }

    public void removeRow(Comparable rowKey) {
        this.rowKeys.remove(rowKey);
        this.rows.remove(rowKey);
        Comparable cKey2 = null;
        for (Comparable rKey : this.rows.keySet()) {
            boolean allNull = true;
            for (Comparable cKey2 : this.columnKeys) {
                if (!((Map)this.rows.get(rKey)).containsKey(cKey2)) continue;
                allNull = false;
                break;
            }
            if (!allNull) continue;
            this.columnKeys.remove(cKey2);
        }
        if (this.rowKeys.isEmpty()) {
            this.columnKeys.clear();
        }
    }

    public void removeColumn(int columnIndex) {
        Comparable columnKey = this.getColumnKey(columnIndex);
        this.removeColumn(columnKey);
    }

    public void removeColumn(Comparable columnKey) {
        for (Comparable rowKey : this.rows.keySet()) {
            ((Map)this.rows.get(rowKey)).remove(columnKey);
            if (!((Map)this.rows.get(rowKey)).isEmpty()) continue;
            this.rows.remove(rowKey);
            this.rowKeys.remove(rowKey);
        }
        this.columnKeys.remove(columnKey);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int row, int column) {
        if (this.columnKeys.isEmpty() || this.rowKeys.isEmpty()) {
            System.err.println(this.columnKeys + " " + this.rowKeys + " " + row + " " + column);
            return null;
        }
        Integer result = null;
        Comparable columnKey = (Comparable)this.columnKeys.get(column);
        Comparable rowKey = (Comparable)this.rowKeys.get(row);
        if (this.rows.containsKey(rowKey) && ((Map)this.rows.get(rowKey)).containsKey(columnKey)) {
            result = ((Collection)((Map)this.rows.get(rowKey)).get(columnKey)).size();
        }
        return result;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        if (rowKey == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (columnKey == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + columnKey);
        }
        if (!this.rowKeys.contains(rowKey)) {
            throw new UnknownKeyException("Unrecognised rowKey: " + rowKey);
        }
        Integer result = null;
        if (this.rows.containsKey(rowKey) && ((Map)this.rows.get(rowKey)).containsKey(columnKey)) {
            result = ((Collection)((Map)this.rows.get(rowKey)).get(columnKey)).size();
        }
        return result;
    }

    public Comparable getRowKey(int row) {
        return (Comparable)this.rowKeys.get(row);
    }

    public int getRowIndex(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, key);
        }
        return this.rowKeys.indexOf(key);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int column) {
        return (Comparable)this.columnKeys.get(column);
    }

    public int getColumnIndex(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.columnKeys.indexOf(key);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }
}

