/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.diagram;

import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.diagram.DiagramCanvas;
import jadex.tools.comanalyzer.diagram.DiagramConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class ComponentCanvas
extends JPanel {
    public static final Font componentFont = new Font("Helvetica", 0, 12);
    protected DiagramCanvas panelcan;

    public ComponentCanvas(DiagramCanvas panelcan) {
        this.setBackground(Color.white);
        this.panelcan = panelcan;
    }

    public void setPreferredSize() {
        Dimension preferredSize = new Dimension();
        preferredSize.width = this.panelcan.visible_components.size() * 80;
        preferredSize.height = 65;
        this.setPreferredSize(preferredSize);
        this.setSize(preferredSize);
    }

    public Component getComponent(int x, int y) {
        int y1 = 20;
        int y2 = y1 + 30;
        for (int i = 0; i < this.panelcan.visible_components.size(); ++i) {
            Component component = (Component)this.panelcan.visible_components.get(i);
            int x1 = 20 + i * 80;
            int x2 = x1 + 50;
            if (x < x1 || x > x2 || y < y1 || y > y2) continue;
            return component;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        for (int i = 0; i < this.panelcan.visible_components.size(); ++i) {
            Component component = (Component)this.panelcan.visible_components.get(i);
            int x = 20 + i * 80;
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawRect(x + 3, 23, 50, 30);
            g2d.setColor(Color.GRAY);
            g2d.drawRect(x + 2, 22, 50, 30);
            g2d.setColor(Color.DARK_GRAY);
            g2d.drawRect(x + 1, 21, 50, 30);
            if (component.getState().equals("dummy")) {
                g2d.setColor(Color.YELLOW);
            } else if (component.getState().equals("dead")) {
                g2d.setColor(Color.GRAY);
            } else {
                g2d.setColor(new Color(41, 123, 198));
            }
            g2d.drawRect(x, 20, 50, 30);
            GradientPaint gradient = null;
            gradient = component.getState().equals("dummy") ? new GradientPaint(x, 50.0f, Color.WHITE, x, 20.0f, Color.YELLOW) : (component.getState().equals("dead") ? new GradientPaint(x, 50.0f, Color.WHITE, x, 20.0f, Color.GRAY) : new GradientPaint(x, 50.0f, Color.WHITE, x, 20.0f, new Color(41, 123, 198)));
            g2d.setPaint(gradient);
            g2d.fillRect(x + 1, 21, 49, 29);
            g2d.setColor(Color.black);
            g2d.setFont(componentFont);
            FontMetrics fm = g2d.getFontMetrics();
            String aName = component.getId();
            int nameWidth = fm.stringWidth(aName);
            if (nameWidth < 50) {
                g2d.drawString(aName, x + (50 - nameWidth) / 2, 35 + fm.getAscent() / 2);
            } else {
                String part3;
                String part2;
                String part1;
                int len = aName.length();
                if (nameWidth < 100) {
                    part1 = aName.substring(0, len / 2);
                    part2 = aName.substring(len / 2);
                    g2d.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.2));
                    g2d.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.9));
                } else if (nameWidth < 150) {
                    part1 = aName.substring(0, len / 3);
                    part2 = aName.substring(len / 3, 2 * len / 3);
                    part3 = aName.substring(2 * len / 3);
                    g2d.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.65));
                    g2d.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.3));
                    g2d.drawString(part3, x + (50 - fm.stringWidth(part3)) / 2, 35 + (int)((double)fm.getAscent() * 0.95));
                } else {
                    int approxCharWidth = nameWidth / component.getId().length();
                    int charCount = 50 / approxCharWidth;
                    part1 = aName.substring(0, charCount);
                    if (aName.length() < charCount * 2) {
                        part2 = aName.substring(charCount);
                        part3 = "";
                    } else {
                        part2 = aName.substring(charCount, charCount * 2);
                        part3 = charCount * 3 > aName.length() ? aName.substring(charCount * 2) : aName.substring(charCount * 2, charCount * 3);
                    }
                    g2d.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.65));
                    g2d.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.3));
                    g2d.drawString(part3, x + (50 - fm.stringWidth(part3)) / 2, 35 + (int)((double)fm.getAscent() * 0.95));
                }
            }
            int x2 = DiagramConstants.getTimelineX(i);
            float[] dotting = new float[]{1.0f, 3.0f};
            BasicStroke DOTTED = new BasicStroke(1.0f, 2, 2, 1.0f, dotting, 0.0f);
            g2d.setStroke(DOTTED);
            g2d.setColor(DiagramConstants.COLOR_TIMELINE);
            Line2D.Double l = new Line2D.Double(x2, 53.0, x2, 65.0);
            g2d.draw(l);
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }
}

