/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.diagram;

import edu.uci.ics.jung.graph.util.Pair;
import jadex.commons.collection.SortedList;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.ComponentFilterMenu;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilterMenu;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.diagram.ComponentCanvas;
import jadex.tools.comanalyzer.diagram.MessageCanvas;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JScrollPane;

public class DiagramCanvas
extends ToolCanvas {
    protected ComponentCanvas header;
    protected MessageCanvas detail;
    protected SortedList visible_components = new SortedList();
    protected SortedMap visible_messages = new TreeMap();
    protected boolean autoScroll = true;

    public DiagramCanvas(final ToolTab tooltab) {
        super(tooltab);
        this.header = new ComponentCanvas(this);
        this.detail = new MessageCanvas(this);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.detail);
        scroll.setColumnHeaderView(this.header);
        this.setLayout(new BorderLayout());
        this.add("Center", scroll);
        this.header.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Component selectedComponent = DiagramCanvas.this.header.getComponent(e.getX(), e.getY());
                if (selectedComponent != null) {
                    DiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    DiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Component selectedComponent;
                if (e.getButton() == 3 && (selectedComponent = DiagramCanvas.this.header.getComponent(e.getX(), e.getY())) != null) {
                    ComponentFilterMenu mpopup = new ComponentFilterMenu(tooltab.getPlugin(), selectedComponent);
                    mpopup.show(e.getComponent(), e.getX(), e.getY());
                }
                if (e.getButton() == 1 && e.getClickCount() == 2 && (selectedComponent = DiagramCanvas.this.header.getComponent(e.getX(), e.getY())) != null) {
                    tooltab.getToolPanel().showElementDetails(selectedComponent.getParameters());
                }
            }
        });
        this.detail.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Message selectedMessage = DiagramCanvas.this.detail.getMessage(e.getX(), e.getY());
                if (selectedMessage != null) {
                    DiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    DiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.detail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Message mess;
                if (e.getButton() == 3 && (mess = DiagramCanvas.this.detail.getMessage(e.getX(), e.getY())) != null) {
                    MessageFilterMenu mpopup = new MessageFilterMenu(tooltab.getPlugin(), mess);
                    mpopup.show(e.getComponent(), e.getX(), e.getY());
                }
                if (e.getButton() == 1 && e.getClickCount() == 2 && (mess = DiagramCanvas.this.detail.getMessage(e.getX(), e.getY())) != null) {
                    tooltab.getToolPanel().showElementDetails(mess.getParameters());
                }
            }
        });
    }

    @Override
    public void updateMessage(Message message, boolean isPresent) {
        Pair newPair = message.getEndpoints();
        if (newPair != null) {
            Component sender = (Component)newPair.getFirst();
            Component receiver = (Component)newPair.getSecond();
            if (this.visible_messages.containsKey(message)) {
                Pair oldPair = (Pair)this.visible_messages.get(message);
                if (oldPair.getFirst().equals(sender) && oldPair.getSecond().equals(receiver)) {
                    return;
                }
                this.removeMessage(message);
            }
            this.addMessage(message, sender, receiver);
        } else if (isPresent) {
            this.removeMessage(message);
        }
    }

    @Override
    public void removeMessage(Message message) {
        this.visible_messages.remove(message);
    }

    @Override
    public void updateComponent(Component component, boolean update) {
        if (component.isVisible()) {
            if (!this.visible_components.contains((Object)component)) {
                this.addComponent(component);
            }
        } else if (update) {
            this.removeComponent(component);
        }
    }

    @Override
    public void removeComponent(Component component) {
        this.visible_components.remove((Object)component);
    }

    @Override
    public void repaintCanvas() {
        this.header.setPreferredSize();
        this.detail.setPreferredSize();
        if (this.autoScroll) {
            Point p = new Point(0, this.detail.getSize().height);
            this.detail.scrollRectToVisible(new Rectangle(p));
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void clear() {
        this.visible_components.clear();
        this.visible_messages.clear();
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public void addComponent(Component component) {
        this.visible_components.add((Object)component);
    }

    public void addMessage(Message message, Component sender, Component receiver) {
        this.visible_messages.put(message, new Pair((Object)sender, (Object)receiver));
    }
}

