/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.diagram;

import jadex.commons.SUtil;
import jadex.commons.gui.SGUI;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.diagram.DiagramCanvas;
import jadex.tools.comanalyzer.table.TablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;

public class DiagramPanel
extends ToolTab
implements ActionListener {
    private static final String COMANALYZER_IMAGES = "/jadex/tools/comanalyzer/images/";
    protected static final UIDefaults defaults = new UIDefaults(new Object[]{"scrolllock", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/scrolllock.png"), "autoscroll", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/autoscroll.png")});
    protected DiagramCanvas panelcan;
    protected JScrollPane options;
    protected JSplitPane main;
    protected JCheckBox e_label;
    protected JCheckBox e_font;
    protected JRadioButton e_nocolor;
    protected JRadioButton e_convid;
    protected JRadioButton e_perform;
    protected JRadioButton e_protocol;
    protected final AbstractAction SCROLL_LOCK = new AbstractAction("Scroll Lock", defaults.getIcon("scrolllock")){

        @Override
        public void actionPerformed(ActionEvent ae) {
            DiagramPanel.this.panelcan.setAutoScroll(!DiagramPanel.this.panelcan.isAutoScroll());
            DiagramPanel.this.SCROLL_LOCK.putValue("ShortDescription", DiagramPanel.this.panelcan.isAutoScroll() ? "Scroll Lock" : "Auto Scroll");
            DiagramPanel.this.SCROLL_LOCK.putValue("SmallIcon", DiagramPanel.this.panelcan.isAutoScroll() ? defaults.getIcon("scrolllock") : defaults.getIcon("autoscroll"));
        }
    };

    public DiagramPanel(ComanalyzerPlugin plugin) {
        super(plugin, "Diagram", null);
        this.panelcan = new DiagramCanvas(this);
        this.options = new JScrollPane();
        this.addBottomControls(this.options);
        this.main = new JSplitPane(1, this.panelcan, this.options);
        this.main.setOneTouchExpandable(true);
        this.main.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add("North", SGUI.createToolBar((String)"Diagram Panal Options", (Action[])this.getActions()));
        this.add("Center", this.main);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double scrollWidth;
                double optionsWidth;
                double mainWidth = DiagramPanel.this.main.getWidth();
                double loc = (mainWidth - (optionsWidth = DiagramPanel.this.options.getPreferredSize().getWidth()) - (scrollWidth = DiagramPanel.this.options.getVerticalScrollBar().isVisible() ? (double)DiagramPanel.this.options.getVerticalScrollBar().getWidth() : 0.0)) / mainWidth;
                if (loc >= 0.0 && loc <= 1.0) {
                    DiagramPanel.this.main.setDividerLocation(loc);
                }
            }
        });
    }

    @Override
    public ToolCanvas getCanvas() {
        return this.panelcan;
    }

    @Override
    public Action[] getActions() {
        if (this.actions == null) {
            List actionlist = SUtil.arrayToList((Object)super.getActions());
            actionlist.add(null);
            actionlist.add(this.SCROLL_LOCK);
            this.actions = actionlist.toArray(new Action[actionlist.size()]);
        }
        return this.actions;
    }

    protected void addBottomControls(JScrollPane options) {
        JPanel control_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        Box message_panel = Box.createVerticalBox();
        message_panel.setBorder(BorderFactory.createTitledBorder("Messages"));
        JPanel e_label_panel = new JPanel(new GridLayout(2, 0));
        this.e_label = new JCheckBox("Show Labels");
        this.e_label.setSelected(this.panelcan.detail.show_label);
        this.e_label.addActionListener(this);
        this.e_font = new JCheckBox("Bold Text");
        this.e_font.setSelected(this.panelcan.detail.label_bold);
        this.e_font.setEnabled(this.e_label.isSelected());
        this.e_font.addActionListener(this);
        e_label_panel.add(this.e_label);
        e_label_panel.add(this.e_font);
        JPanel color_panel = new JPanel(new GridLayout(4, 0));
        color_panel.setBorder(BorderFactory.createTitledBorder("Color By"));
        ButtonGroup bg_colors = new ButtonGroup();
        this.e_nocolor = new JRadioButton("No colors");
        this.e_nocolor.setSelected(this.panelcan.detail.getPaintMode() == 0);
        this.e_nocolor.addActionListener(this);
        this.e_convid = new JRadioButton("Converstation");
        this.e_convid.setSelected(this.panelcan.detail.getPaintMode() == 1);
        this.e_convid.addActionListener(this);
        this.e_perform = new JRadioButton("Performative");
        this.e_perform.setSelected(this.panelcan.detail.getPaintMode() == 2);
        this.e_perform.addActionListener(this);
        this.e_protocol = new JRadioButton("Protocol");
        this.e_protocol.setSelected(this.panelcan.detail.getPaintMode() == 3);
        this.e_protocol.addActionListener(this);
        bg_colors.add(this.e_nocolor);
        bg_colors.add(this.e_convid);
        bg_colors.add(this.e_perform);
        bg_colors.add(this.e_protocol);
        color_panel.add(this.e_nocolor);
        color_panel.add(this.e_convid);
        color_panel.add(this.e_perform);
        color_panel.add(this.e_protocol);
        message_panel.add(e_label_panel);
        message_panel.add(color_panel);
        control_panel.add((Component)message_panel, gbc);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)control_panel, "North");
        options.setViewportView(jp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.e_nocolor) {
            this.panelcan.detail.setPaintMode(0);
            this.panelcan.repaintCanvas();
        } else if (source == this.e_convid) {
            this.panelcan.detail.setPaintMode(1);
            this.panelcan.repaintCanvas();
        } else if (source == this.e_perform) {
            this.panelcan.detail.setPaintMode(2);
            this.panelcan.repaintCanvas();
        } else if (source == this.e_protocol) {
            this.panelcan.detail.setPaintMode(3);
            this.panelcan.repaintCanvas();
        } else if (source == this.e_label) {
            this.panelcan.detail.show_label = source.isSelected();
            this.e_font.setEnabled(source.isSelected());
            this.panelcan.repaintCanvas();
        } else if (source == this.e_font) {
            this.panelcan.detail.label_bold = source.isSelected();
            this.panelcan.repaintCanvas();
        }
    }
}

