/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.diagram;

import edu.uci.ics.jung.graph.util.Pair;
import jadex.commons.SUtil;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.diagram.DiagramCanvas;
import jadex.tools.comanalyzer.diagram.DiagramConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.JPanel;

public class MessageCanvas
extends JPanel
implements Serializable {
    public static final int V_TOL = 4;
    public static final int H_TOL = 4;
    public static final Font plain_font = new Font("SanSerif", 0, 12);
    public static final Font bold_font = new Font("SanSerif", 1, 12);
    private int paintMode;
    protected DiagramCanvas panelcan;
    protected boolean show_label;
    protected boolean label_bold;

    public MessageCanvas(DiagramCanvas panelcan) {
        this.setBackground(Color.white);
        this.panelcan = panelcan;
        this.show_label = true;
        this.label_bold = false;
        this.paintMode = 0;
    }

    public void setPreferredSize() {
        Dimension preferredSize = new Dimension();
        preferredSize.width = this.panelcan.visible_components.size() * 80;
        preferredSize.height = 30 + this.panelcan.visible_messages.size() * 30;
        this.setPreferredSize(preferredSize);
        this.setSize(preferredSize);
    }

    public Message getMessage(int x, int y) {
        int msgnr = 0;
        for (Message message : this.panelcan.visible_messages.keySet()) {
            boolean inRangeY;
            Component sender = (Component)((Pair)this.panelcan.visible_messages.get(message)).getFirst();
            Component receiver = (Component)((Pair)this.panelcan.visible_messages.get(message)).getSecond();
            int posSource = this.panelcan.visible_components.indexOf((Object)sender);
            int posDest = this.panelcan.visible_components.indexOf((Object)receiver);
            int x1 = DiagramConstants.getTimelineX(posSource);
            int x2 = DiagramConstants.getTimelineX(posDest);
            int yt = DiagramConstants.getTimelineY(msgnr++);
            boolean inRangeX = x1 < x2 ? x >= x1 - 4 && x <= x2 + 4 : x >= x2 - 4 && x <= x1 + 4;
            boolean bl = inRangeY = y >= yt - 4 && y <= yt + 4;
            if (!inRangeX || !inRangeY) continue;
            return message;
        }
        return null;
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int agntnr = 0;
        int msgcount = this.panelcan.visible_messages.size();
        Iterator iter = this.panelcan.visible_components.iterator();
        while (iter.hasNext()) {
            iter.next();
            int x = DiagramConstants.getTimelineX(agntnr++);
            float[] dotting = new float[]{1.0f, 3.0f};
            BasicStroke DOTTED = new BasicStroke(1.0f, 2, 2, 1.0f, dotting, 0.0f);
            g2d.setStroke(DOTTED);
            g2d.setColor(DiagramConstants.COLOR_TIMELINE);
            Line2D.Double l = new Line2D.Double(x, 0.0, x, 30 * (msgcount + 1));
            g2d.draw(l);
        }
        int msgnr = 0;
        String lastId = null;
        for (Message message : this.panelcan.visible_messages.keySet()) {
            Component sender = (Component)((Pair)this.panelcan.visible_messages.get(message)).getFirst();
            Component receiver = (Component)((Pair)this.panelcan.visible_messages.get(message)).getSecond();
            int posSource = this.panelcan.visible_components.indexOf((Object)sender);
            int posDest = this.panelcan.visible_components.indexOf((Object)receiver);
            int x1 = DiagramConstants.getTimelineX(posSource);
            int x2 = DiagramConstants.getTimelineX(posDest);
            int y = DiagramConstants.getTimelineY(msgnr++);
            if (this.show_label) {
                g2d.setColor(Color.black);
                g2d.setFont(this.label_bold ? bold_font : plain_font);
                String perf = (String)message.getParameter("performative");
                perf = perf + " (" + this.head(30, message.getParameter("content")) + " )";
                int perfWidth = g2d.getFontMetrics().stringWidth(perf);
                int xString = (x2 > x1 ? x1 + (x2 - x1) / 2 : x2 + (x1 - x2) / 2) - perfWidth / 2;
                g2d.drawString(perf, xString, y + -8);
            }
            Paint msgColor = this.panelcan.getToolTab().getPaintMaps().getMessagePaint(message, this.paintMode);
            GradientPaint msgPaint = new GradientPaint(x1, y, Color.WHITE, x2, y, (Color)msgColor, true);
            Line2D.Double msgLine = new Line2D.Double(x1, y, x2, y);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setPaint(msgPaint);
            g2d.draw(msgLine);
            boolean combine = SUtil.equals((Object)message.getId(), lastId);
            int ext = combine ? 30 : 0;
            Line2D.Double multiLine = new Line2D.Double(x1, y - ext - 5, x1, y + 5);
            g2d.setPaint(msgColor);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.draw(multiLine);
            GeneralPath s = this.getArrow(x2, y, x2 <= x1);
            g2d.setStroke(new BasicStroke(2.0f, 1, 1));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(Color.lightGray);
            g2d.fill(s);
            g2d.setPaint(Color.darkGray);
            g2d.draw(s);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            String msgNumber = message.getParameter("seq-no").toString();
            g2d.setColor(DiagramConstants.COLOR_MESSAGENUMBER);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawString(msgNumber, 10, y + 3);
            lastId = message.getId();
        }
    }

    private String head(int n, Object o) {
        String s = " ";
        if (o == null) {
            return s;
        }
        s = o instanceof String ? (String)o : o.toString();
        try {
            return s.substring(0, n) + "...";
        }
        catch (Exception exception) {
            return s;
        }
    }

    private GeneralPath getArrow(float x, float y, boolean rotate) {
        GeneralPath arrow = new GeneralPath();
        float height = 10 * (rotate ? -1 : 1);
        float width = 8 * (rotate ? -1 : 1);
        float notch_width = 4 * (rotate ? -1 : 1);
        arrow.moveTo(x, y);
        arrow.lineTo(x - width, y + height / 2.0f);
        arrow.lineTo(x - (width - notch_width), y);
        arrow.lineTo(x - width, y - height / 2.0f);
        arrow.lineTo(x, y);
        return arrow;
    }
}

