/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import jadex.commons.collection.SortedList;
import jadex.tools.comanalyzer.graph.ComponentGroup;
import jadex.tools.comanalyzer.graph.IComponentGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections15.Factory;

public class ComponentGroupMultiGraph
implements Graph {
    protected Factory vertex_factory;
    protected Factory edge_factory;
    protected Map edge_elemets;
    protected Map vertex_elemets;
    protected Graph delegate;
    protected GenericSortedList edge_weights;
    protected GenericSortedList vertex_weights;

    public static ComponentGroupMultiGraph createInstance(Factory vertex_factory, Factory edge_factory, Graph delegate) {
        return new ComponentGroupMultiGraph(vertex_factory, edge_factory, delegate);
    }

    protected ComponentGroupMultiGraph(Factory vertex_factory, Factory edge_factory, Graph delegate) {
        this.delegate = delegate;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
        this.edge_elemets = new HashMap();
        this.vertex_elemets = new HashMap();
        this.edge_weights = new GenericSortedList(new Comparator(){

            public int compare(Object e1, Object e2) {
                return ((ComponentGroup)e1).size() - ((ComponentGroup)e2).size();
            }
        });
        this.vertex_weights = new GenericSortedList(new Comparator(){

            public int compare(Object v1, Object v2) {
                return ComponentGroupMultiGraph.this.degree(v1) - ComponentGroupMultiGraph.this.degree(v2);
            }
        });
    }

    public void clear() {
        ArrayList vertices = new ArrayList(this.getVertices());
        for (int i = 0; i < vertices.size(); ++i) {
            this.removeVertex(vertices.get(i));
        }
        this.edge_elemets.clear();
        this.vertex_elemets.clear();
        this.edge_weights.clear();
        this.vertex_weights.clear();
    }

    public boolean addVertexElement(Object ve) {
        if (ve == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertexElement(ve)) {
            IComponentGroup v = (IComponentGroup)this.vertex_factory.create();
            v.addElement(ve);
            this.addVertex(v);
            return true;
        }
        return false;
    }

    public boolean appendVertexElement(Object ve, Object v) {
        if (ve == null || v == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(v)) {
            this.addVertex(v);
        }
        if (!this.containsVertexElement(ve)) {
            ((IComponentGroup)v).addElement(ve);
            this.vertex_elemets.put(ve, v);
            this.vertex_weights.replace(v);
            return true;
        }
        return false;
    }

    public boolean addEdgeElement(Object ee, Object ve1, Object ve2, EdgeType edgeType) {
        if (ee == null || ve1 == null || ve2 == null) {
            throw new IllegalArgumentException("graph elements may not be null");
        }
        if (!this.containsVertexElement(ve1)) {
            this.addVertexElement(ve1);
        }
        if (!this.containsVertexElement(ve2)) {
            this.addVertexElement(ve2);
        }
        Object v1 = this.vertex_elemets.get(ve1);
        Object v2 = this.vertex_elemets.get(ve2);
        IComponentGroup e = (IComponentGroup)this.edge_factory.create();
        e.addElement(ee);
        this.addEdge(e, v1, v2, edgeType);
        return true;
    }

    public boolean addEdgeElement(Object ee, Object ve1, Object ve2) {
        return this.addEdgeElement(ee, ve1, ve2, EdgeType.DIRECTED);
    }

    public boolean appendEdgeElement(Object ee, Object ve1, Object ve2) {
        return this.appendEdgeElement(ee, ve1, ve2, EdgeType.DIRECTED);
    }

    public boolean appendEdgeElement(Object ee, Object ve1, Object ve2, EdgeType edgeType) {
        Object v2;
        Object v1;
        IComponentGroup e;
        if (ee == null || ve1 == null || ve2 == null) {
            throw new IllegalArgumentException("graph elements may not be null");
        }
        if (!this.containsVertexElement(ve1)) {
            this.addVertexElement(ve1);
        }
        if (!this.containsVertexElement(ve2)) {
            this.addVertexElement(ve2);
        }
        if ((e = (IComponentGroup)this.findEdge(v1 = this.vertex_elemets.get(ve1), v2 = this.vertex_elemets.get(ve2))) == null) {
            e = (IComponentGroup)this.edge_factory.create();
            e.addElement(ee);
            this.addEdge(e, v1, v2, edgeType);
        } else {
            e.addElement(ee);
            this.edge_elemets.put(ee, e);
            this.edge_weights.replace(e);
        }
        return true;
    }

    public IComponentGroup findEdge(Object ee) {
        return (IComponentGroup)this.edge_elemets.get(ee);
    }

    public IComponentGroup findVertex(Object ve) {
        return (IComponentGroup)this.vertex_elemets.get(ve);
    }

    public boolean containsEdgeElement(Object ee) {
        return this.edge_elemets.containsKey(ee);
    }

    public boolean containsVertexElement(Object ve) {
        return this.vertex_elemets.containsKey(ve);
    }

    public boolean removeEdgeElement(Object ee) {
        if (!this.containsEdgeElement(ee)) {
            return false;
        }
        IComponentGroup e = this.findEdge(ee);
        e.removeElement(ee);
        this.edge_elemets.remove(ee);
        if (e.size() == 0) {
            this.removeEdge(e);
        } else {
            this.edge_weights.replace(e);
        }
        return true;
    }

    public boolean removeVertexElement(Object ve) {
        if (!this.containsVertexElement(ve)) {
            return false;
        }
        IComponentGroup v = this.findVertex(ve);
        v.removeElement(ve);
        this.vertex_elemets.remove(ve);
        if (v.size() == 0) {
            this.removeVertex(v);
        } else {
            this.vertex_weights.replace(v);
        }
        return true;
    }

    public Collection getAllEdgeElements() {
        return Collections.unmodifiableCollection(this.edge_elemets.keySet());
    }

    public Collection getAllVertexElements() {
        return Collections.unmodifiableCollection(this.vertex_elemets.keySet());
    }

    public int getHighestEdgeWeight() {
        if (!this.edge_weights.isEmpty()) {
            return ((IComponentGroup)this.edge_weights.getLast()).getElements().size();
        }
        System.err.println("edgeweight=0");
        return 0;
    }

    public int getHighestVertexWeight() {
        if (!this.vertex_weights.isEmpty()) {
            return this.degree(this.vertex_weights.getLast());
        }
        System.err.println("vertexweight=0");
        return 0;
    }

    public boolean addEdge(Object edge, Collection vertices) {
        Pair pair = null;
        pair = vertices instanceof Pair ? (Pair)vertices : new Pair(vertices);
        return this.addEdge(edge, pair.getFirst(), pair.getSecond());
    }

    public boolean addEdge(Object e, Object v1, Object v2, EdgeType edgeType) {
        if (this.delegate.addEdge(e, v1, v2, edgeType)) {
            this.internal_addEdge(e);
            this.internal_addVertex(v1);
            this.internal_addVertex(v2);
            return true;
        }
        return false;
    }

    public boolean addEdge(Object edge, Collection vertices, EdgeType edge_type) {
        if (this.delegate.addEdge(edge, vertices, edge_type)) {
            this.internal_addEdge(edge);
            Iterator it = vertices.iterator();
            while (it.hasNext()) {
                this.internal_addVertex(it.next());
            }
            return true;
        }
        return false;
    }

    public boolean addEdge(Object e, Object v1, Object v2) {
        if (this.delegate.addEdge(e, v1, v2)) {
            this.internal_addEdge(e);
            this.internal_addVertex(v1);
            this.internal_addVertex(v2);
            return true;
        }
        return false;
    }

    public boolean addVertex(Object vertex) {
        if (this.delegate.addVertex(vertex)) {
            this.internal_addVertex(vertex);
            return true;
        }
        return false;
    }

    public boolean removeEdge(Object edge) {
        this.internal_removeEdge(edge);
        return this.delegate.removeEdge(edge);
    }

    public boolean removeVertex(Object vertex) {
        this.internal_removeVertex(vertex);
        return this.delegate.removeVertex(vertex);
    }

    public boolean isIncident(Object vertex, Object edge) {
        return this.delegate.isIncident(vertex, edge);
    }

    public boolean isNeighbor(Object v1, Object v2) {
        return this.delegate.isNeighbor(v1, v2);
    }

    public boolean containsEdge(Object edge) {
        return this.delegate.containsEdge(edge);
    }

    public boolean containsVertex(Object vertex) {
        return this.delegate.containsVertex(vertex);
    }

    public int degree(Object vertex) {
        return this.delegate.degree(vertex);
    }

    public Object findEdge(Object v1, Object v2) {
        return (IComponentGroup)this.delegate.findEdge(v1, v2);
    }

    public Collection findEdgeSet(Object v1, Object v2) {
        return this.delegate.findEdgeSet(v1, v2);
    }

    public Object getDest(Object directed_edge) {
        return this.delegate.getDest(directed_edge);
    }

    public int getEdgeCount() {
        return this.delegate.getEdgeCount();
    }

    public int getEdgeCount(EdgeType et) {
        return this.delegate.getEdgeCount(et);
    }

    public Collection getEdges() {
        return this.delegate.getEdges();
    }

    public Collection getEdges(EdgeType edgeType) {
        return this.delegate.getEdges(edgeType);
    }

    public EdgeType getEdgeType(Object edge) {
        return this.delegate.getEdgeType(edge);
    }

    public Pair getEndpoints(Object edge) {
        return this.delegate.getEndpoints(edge);
    }

    public int getIncidentCount(Object edge) {
        return this.delegate.getIncidentCount(edge);
    }

    public Collection getIncidentEdges(Object vertex) {
        return this.delegate.getIncidentEdges(vertex);
    }

    public Collection getIncidentVertices(Object edge) {
        return this.delegate.getIncidentVertices(edge);
    }

    public Collection getInEdges(Object vertex) {
        return this.delegate.getInEdges(vertex);
    }

    public int getNeighborCount(Object vertex) {
        return this.delegate.getNeighborCount(vertex);
    }

    public Collection getNeighbors(Object vertex) {
        return this.delegate.getNeighbors(vertex);
    }

    public Object getOpposite(Object vertex, Object edge) {
        return this.delegate.getOpposite(vertex, edge);
    }

    public Collection getOutEdges(Object vertex) {
        return this.delegate.getOutEdges(vertex);
    }

    public int getPredecessorCount(Object vertex) {
        return this.delegate.getPredecessorCount(vertex);
    }

    public Collection getPredecessors(Object vertex) {
        return this.delegate.getPredecessors(vertex);
    }

    public Object getSource(Object directed_edge) {
        return this.delegate.getSource(directed_edge);
    }

    public int getSuccessorCount(Object vertex) {
        return this.delegate.getSuccessorCount(vertex);
    }

    public Collection getSuccessors(Object vertex) {
        return this.delegate.getSuccessors(vertex);
    }

    public int getVertexCount() {
        return this.delegate.getVertexCount();
    }

    public Collection getVertices() {
        return this.delegate.getVertices();
    }

    public int inDegree(Object vertex) {
        return this.delegate.inDegree(vertex);
    }

    public boolean isDest(Object vertex, Object edge) {
        return this.delegate.isDest(vertex, edge);
    }

    public boolean isPredecessor(Object v1, Object v2) {
        return this.delegate.isPredecessor(v1, v2);
    }

    public boolean isSource(Object vertex, Object edge) {
        return this.delegate.isSource(vertex, edge);
    }

    public boolean isSuccessor(Object v1, Object v2) {
        return this.delegate.isSuccessor(v1, v2);
    }

    public int outDegree(Object vertex) {
        return this.delegate.outDegree(vertex);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Vertices:");
        Iterator it = this.getVertices().iterator();
        while (it.hasNext()) {
            sb.append("(");
            Iterator it2 = ((IComponentGroup)it.next()).getElements().iterator();
            while (it2.hasNext()) {
                sb.append(it2.next() + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("),");
        }
        sb.setLength(sb.length() - 1);
        sb.append("\nEdges:");
        it = this.getEdges().iterator();
        while (it.hasNext()) {
            sb.append("(");
            for (Object ee : ((IComponentGroup)it.next()).getElements()) {
                Pair ep = this.getEndpoints(ee);
                sb.append(ee + "[" + ep.getFirst() + "," + ep.getSecond() + "]");
            }
            sb.setLength(sb.length() - 1);
            sb.append("),");
        }
        return sb.toString();
    }

    private void internal_addVertex(Object vertex) {
        Iterator it = ((IComponentGroup)vertex).getElements().iterator();
        while (it.hasNext()) {
            this.vertex_elemets.put(it.next(), vertex);
        }
        this.vertex_weights.replace(vertex);
    }

    private void internal_removeVertex(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return;
        }
        Iterator it = ((IComponentGroup)vertex).getElements().iterator();
        while (it.hasNext()) {
            this.vertex_elemets.remove(it.next());
        }
        this.vertex_weights.remove(vertex);
        ArrayList incident = new ArrayList(this.getIncidentEdges(vertex));
        Iterator it2 = incident.iterator();
        while (it2.hasNext()) {
            this.internal_removeEdge(it2.next());
        }
    }

    private void internal_addEdge(Object edge) {
        Iterator it = ((IComponentGroup)edge).getElements().iterator();
        while (it.hasNext()) {
            this.edge_elemets.put(it.next(), edge);
        }
        this.edge_weights.replace(edge);
    }

    private void internal_removeEdge(Object edge) {
        if (!this.containsEdge(edge)) {
            return;
        }
        Iterator it = ((IComponentGroup)edge).getElements().iterator();
        while (it.hasNext()) {
            this.edge_elemets.remove(it.next());
        }
        this.edge_weights.remove(edge);
    }

    public EdgeType getDefaultEdgeType() {
        return null;
    }

    private class GenericSortedList
    extends SortedList {
        public GenericSortedList(Comparator comperator) {
            super(comperator, true);
        }

        public Object getLast() {
            return super.getLast();
        }

        public void replace(Object t) {
            super.remove(t);
            super.add(t);
        }
    }
}

