/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.decorators.GradientEdgePaintTransformer;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.PaintMaps;
import jadex.tools.comanalyzer.graph.ComponentGroupMultiGraph;
import jadex.tools.comanalyzer.graph.GraphCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections15.Transformer;

public class EdgeTransformer {

    public static final class ToolTips
    implements Transformer {
        public Object transform(Object group) {
            if (((GraphCanvas.MessageGroup)group).isSingelton()) {
                return ((Message)((GraphCanvas.MessageGroup)group).getSingelton()).getId();
            }
            return null;
        }
    }

    public static final class GradientPaint
    extends GradientEdgePaintTransformer {
        public static final int GRADIENT_NONE = 0;
        public static final int GRADIENT_RELATIVE = 1;
        protected Transformer defaultTransformer;
        protected int gradientLevel;

        public GradientPaint(Transformer defaultTransformer, VisualizationViewer vv, int gradientLevel) {
            super(Color.WHITE, Color.BLACK, vv);
            this.defaultTransformer = defaultTransformer;
            this.gradientLevel = gradientLevel;
        }

        public Paint transform(Object group) {
            if (this.gradientLevel == 0) {
                return (Paint)this.defaultTransformer.transform(group);
            }
            return super.transform(group);
        }

        public void setDefaultTransformer(Transformer defaultTransformer) {
            this.defaultTransformer = defaultTransformer;
        }

        public void setGradientLevel(int gradient_level) {
            this.gradientLevel = gradient_level;
        }

        public int getGradientLevel() {
            return this.gradientLevel;
        }

        protected Color getColor1(Object e) {
            return this.vv.getPickedEdgeState().isPicked(e) ? (Color)this.defaultTransformer.transform(e) : Color.WHITE;
        }

        protected Color getColor2(Object e) {
            return this.vv.getPickedEdgeState().isPicked(e) ? Color.WHITE : (Color)this.defaultTransformer.transform(e);
        }
    }

    public static final class PaintMode
    implements Transformer {
        protected PaintMaps paintMaps;
        protected int paintMode;

        public PaintMode(PaintMaps paintMaps, int paintMode) {
            this.paintMaps = paintMaps;
            this.paintMode = paintMode;
        }

        public Object transform(Object group) {
            if (((GraphCanvas.MessageGroup)group).isSingelton()) {
                return this.paintMaps.getMessagePaint((Message)((GraphCanvas.MessageGroup)group).getSingelton(), this.paintMode);
            }
            HashSet<Paint> paints = new HashSet<Paint>();
            Iterator it = ((GraphCanvas.MessageGroup)group).getElements().iterator();
            while (it.hasNext()) {
                paints.add(this.paintMaps.getMessagePaint((Message)it.next(), this.paintMode));
            }
            if (paints.size() == 1) {
                return paints.iterator().next();
            }
            return this.paintMaps.getDefaultPaint();
        }

        public int getPaintMode() {
            return this.paintMode;
        }

        public void setPaintMode(int paintMode) {
            this.paintMode = paintMode;
        }
    }

    public static final class WeightStroke
    implements Transformer {
        public static final int MIN_EDGE_SIZE = 1;
        public static final int MAX_EDGE_SIZE = 20;
        public static final Stroke basic = new BasicStroke(1.0f);
        public static final Stroke heavy = new BasicStroke(2.0f);
        public static final Stroke dotted = RenderContext.DOTTED;
        protected ComponentGroupMultiGraph graph;
        protected boolean scale = false;
        protected int scaleRange = 1;
        protected int propFactor = 50;

        public WeightStroke(ComponentGroupMultiGraph graph) {
            this.graph = graph;
        }

        public Object transform(Object group) {
            if (this.scale) {
                int highest = this.graph.getHighestEdgeWeight();
                double factor = (double)(100 - this.propFactor) / (double)this.propFactor;
                double strokesize = Math.pow((double)((GraphCanvas.MessageGroup)group).size() / (double)highest, factor) * (double)this.scaleRange;
                return strokesize > 1.0 ? new BasicStroke((float)strokesize) : heavy;
            }
            return heavy;
        }

        public void setScaling(boolean scale) {
            this.scale = scale;
        }

        public boolean isScaling() {
            return this.scale;
        }

        public void setScaleRange(int scaleRange) {
            this.scaleRange = scaleRange;
        }

        public void setPropValue(int value) {
            this.propFactor = value;
        }
    }

    public static class LabelFont
    implements Transformer {
        public static final Font f = new Font("Helvetica", 0, 12);
        public static final Font b = new Font("Helvetica", 1, 12);
        protected boolean bold = false;

        public Object transform(Object e) {
            if (this.bold) {
                return b;
            }
            return f;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public boolean getBold() {
            return this.bold;
        }
    }

    public static final class Label
    implements Transformer {
        protected boolean enabled;

        public Object transform(Object group) {
            String ret = null;
            if (this.enabled) {
                ret = Integer.toString(((GraphCanvas.MessageGroup)group).size());
            }
            return ret;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

