/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.util.VisRunner;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbsoluteCrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Animator;
import jadex.commons.gui.SGUI;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.graph.ComponentGroup;
import jadex.tools.comanalyzer.graph.ComponentGroupMultiGraph;
import jadex.tools.comanalyzer.graph.EdgeTransformer;
import jadex.tools.comanalyzer.graph.GraphCircleLayout;
import jadex.tools.comanalyzer.graph.GraphEdgeBetweennessClusterer;
import jadex.tools.comanalyzer.graph.GraphLayoutTransition;
import jadex.tools.comanalyzer.graph.GraphPanel;
import jadex.tools.comanalyzer.graph.MessageNumberIndexFunction;
import jadex.tools.comanalyzer.graph.MultidirectedMultiGraph;
import jadex.tools.comanalyzer.graph.PopupGraphMousePlugin;
import jadex.tools.comanalyzer.graph.VertexTransformer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.UIDefaults;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class GraphCanvas
extends ToolCanvas {
    private static final String COMANALYZER_IMAGES = "/jadex/tools/comanalyzer/images/";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"agent_standard_big", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_standard_big.png"), "agent_standard_small", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_standard_small.png"), "agent_dummy_big", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_dummy_big.png"), "agent_dummy_small", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_dummy_small.png"), "agent_dead_big", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_dead_big.png"), "agent_dead_small", SGUI.makeIcon(GraphCanvas.class, (String)"/jadex/tools/comanalyzer/images/agent_dead_small.png")});
    protected static final int DIRECTED_MULTIGRAPH = 0;
    protected static final int DIRECTED_GRAPH = 1;
    protected static final int UNDIRECTED_GRAPH = 2;
    protected int graphType = 0;
    protected boolean autolayout = false;
    protected boolean animate = false;
    protected boolean cluster;
    protected List visible_messages;
    protected List visible_agents = new ArrayList();
    protected VisualizationViewer vv;
    protected ComponentGroupMultiGraph graph;
    protected StaticLayout staticLayout;
    protected AggregateLayout layout;
    protected Factory graphFactory;
    protected DefaultModalGraphMouse gm;
    protected AbsoluteCrossoverScalingControl scaler;
    protected VertexTransformer.Label v_string;
    protected VertexTransformer.LabelFont v_font;
    protected VertexTransformer.ShapeSize v_shape;
    protected VertexTransformer.IconSize v_icon;
    protected EdgeTransformer.Label e_string;
    protected EdgeTransformer.LabelFont e_font;
    protected EdgeShape.Line e_line;
    protected EdgeShape.QuadCurve e_quad;
    protected EdgeShape.Wedge e_wedge;
    protected EdgeTransformer.PaintMode e_paint;
    protected EdgeTransformer.GradientPaint e_gradient;
    protected EdgeTransformer.WeightStroke e_stroke;
    protected DirectionDisplayPredicate e_arrow;

    public GraphCanvas(GraphPanel tooltab) {
        super(tooltab);
        this.visible_messages = new ArrayList();
        final Factory vertexFactory = new Factory(){

            public Object create() {
                return new AgentGroup();
            }
        };
        final Factory edgeFactory = new Factory(){

            public Object create() {
                return new MessageGroup();
            }
        };
        this.graphFactory = new Factory(){

            public Object create() {
                Graph delegate = MultidirectedMultiGraph.create();
                return ComponentGroupMultiGraph.createInstance(vertexFactory, edgeFactory, delegate);
            }
        };
        this.graph = (ComponentGroupMultiGraph)this.graphFactory.create();
        this.layout = new AggregateLayout((Layout)new KKLayout((Graph)this.graph));
        this.layout.setSize(new Dimension(300, 300));
        this.staticLayout = new StaticLayout((Graph)this.graph, (Transformer)this.layout);
        this.vv = new VisualizationViewer((Layout)this.staticLayout);
        this.vv.setBackground(Color.white);
        this.v_string = new VertexTransformer.Label();
        this.v_font = new VertexTransformer.LabelFont();
        this.v_icon = new VertexTransformer.IconSize(this.graph);
        this.v_shape = new VertexTransformer.ShapeSize(this.graph, this.v_icon);
        this.v_icon.setScaling(false);
        this.e_string = new EdgeTransformer.Label();
        this.e_font = new EdgeTransformer.LabelFont();
        this.e_line = new EdgeShape.Line();
        this.e_quad = new EdgeShape.QuadCurve();
        this.e_wedge = new EdgeShape.Wedge(10);
        this.e_paint = new EdgeTransformer.PaintMode(tooltab.getPaintMaps(), 1);
        this.e_gradient = new EdgeTransformer.GradientPaint(this.e_paint, this.vv, 1);
        this.e_stroke = new EdgeTransformer.WeightStroke(this.graph);
        this.e_arrow = new DirectionDisplayPredicate(true, false);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)this.v_string);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        this.vv.getRenderContext().setVertexFontTransformer((Transformer)this.v_font);
        this.vv.getRenderContext().setVertexIconTransformer((Transformer)this.v_icon);
        this.vv.getRenderContext().setVertexShapeTransformer((Transformer)this.v_shape);
        this.vv.setVertexToolTipTransformer((Transformer)new VertexTransformer.ToolTips());
        this.vv.getRenderContext().setEdgeLabelTransformer((Transformer)this.e_string);
        this.vv.getRenderContext().setEdgeFontTransformer((Transformer)this.e_font);
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)this.e_quad);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)this.e_gradient);
        this.vv.getRenderContext().setEdgeStrokeTransformer((Transformer)this.e_stroke);
        this.vv.getRenderContext().setArrowFillPaintTransformer((Transformer)new ConstantTransformer((Object)Color.lightGray));
        this.vv.getRenderContext().setArrowDrawPaintTransformer((Transformer)new ConstantTransformer((Object)Color.darkGray));
        this.vv.getRenderContext().setEdgeArrowPredicate((Predicate)this.e_arrow);
        this.vv.setEdgeToolTipTransformer((Transformer)new EdgeTransformer.ToolTips());
        this.e_quad.setEdgeIndexFunction((EdgeIndexFunction)new MessageNumberIndexFunction());
        GraphZoomScrollPane scrollPane = new GraphZoomScrollPane(this.vv);
        this.gm = new DefaultModalGraphMouse();
        this.gm.setMode(ModalGraphMouse.Mode.PICKING);
        this.gm.add((GraphMousePlugin)new PopupGraphMousePlugin(this));
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)this.gm);
        this.scaler = new AbsoluteCrossoverScalingControl();
        this.setLayout(new BorderLayout());
        this.add("Center", (java.awt.Component)scrollPane);
    }

    @Override
    public void updateMessage(Message message, boolean isPresent) {
        Pair newpair = message.getEndpoints();
        if (newpair != null) {
            Component sender = (Component)newpair.getFirst();
            Component receiver = (Component)newpair.getSecond();
            MessageGroup edge = (MessageGroup)this.graph.findEdge(message);
            if (edge != null) {
                Pair endpoints = this.graph.getEndpoints(edge);
                if (endpoints.getFirst().equals(sender) && endpoints.getSecond().equals(receiver)) {
                    return;
                }
                if (isPresent) {
                    this.removeMessage(message);
                }
            }
            this.addMessage(message, sender, receiver);
        } else if (isPresent) {
            this.removeMessage(message);
        }
    }

    @Override
    public void removeMessage(Message message) {
        this.graph.removeEdgeElement(message);
        this.visible_messages.remove(message);
    }

    @Override
    public void updateComponent(Component agent, boolean update) {
        if (agent.isVisible()) {
            if (!this.graph.containsVertexElement(agent)) {
                this.addAgent(agent);
            }
        } else if (update) {
            this.removeComponent(agent);
        }
    }

    @Override
    public void removeComponent(Component agent) {
        this.graph.removeVertexElement(agent);
        this.visible_agents.remove(agent);
    }

    @Override
    public void clear() {
        this.graph.clear();
    }

    @Override
    public void repaintCanvas() {
        if (this.autolayout) {
            this.layout.initialize();
            VisRunner relaxer = new VisRunner((IterativeContext)this.layout);
            relaxer.stop();
            relaxer.prerelax();
            StaticLayout staticLayout = new StaticLayout((Graph)this.graph, (Transformer)this.layout);
            if (!this.animate) {
                this.vv.setGraphLayout((Layout)staticLayout);
            } else {
                staticLayout.setSize(this.layout.getSize());
                GraphLayoutTransition lt = new GraphLayoutTransition(this.vv, this.vv.getGraphLayout(), (Layout)staticLayout);
                Animator animator = new Animator((IterativeContext)lt);
                animator.start();
            }
        } else {
            this.vv.repaint();
        }
    }

    public void reinitializeCanvas() {
        this.layout.initialize();
        VisRunner relaxer = new VisRunner((IterativeContext)this.layout);
        relaxer.stop();
        relaxer.prerelax();
        StaticLayout staticLayout = new StaticLayout((Graph)this.graph, (Transformer)this.layout);
        if (!this.animate) {
            this.vv.setGraphLayout((Layout)staticLayout);
        } else {
            staticLayout.setSize(this.layout.getSize());
            GraphLayoutTransition lt = new GraphLayoutTransition(this.vv, this.vv.getGraphLayout(), (Layout)staticLayout);
            Animator animator = new Animator((IterativeContext)lt);
            animator.start();
        }
    }

    public void addMessage(Message message, Component sender, Component receiver) {
        switch (this.graphType) {
            case 0: {
                this.graph.addEdgeElement(message, sender, receiver);
                break;
            }
            case 1: {
                this.graph.appendEdgeElement(message, sender, receiver);
                break;
            }
            case 2: {
                this.graph.appendEdgeElement(message, sender, receiver, EdgeType.UNDIRECTED);
                break;
            }
            default: {
                System.err.println("graphtype is not set");
            }
        }
        this.visible_messages.add(message);
    }

    public void addAgent(Component agent) {
        this.graph.addVertexElement(agent);
        VisRunner runner = new VisRunner((IterativeContext)this.layout);
        this.layout.initialize();
        runner.prerelax();
        this.visible_agents.add(agent);
    }

    public void clusterGraph(int numEdgesToRemove, boolean groupClusters) {
        if (numEdgesToRemove < 0 || numEdgesToRemove > this.graph.getEdgeCount()) {
            return;
        }
        this.layout.removeAll();
        GraphEdgeBetweennessClusterer clusterer = new GraphEdgeBetweennessClusterer(numEdgesToRemove);
        Set clusterSet = (Set)clusterer.transform(this.graph);
        for (Set vertices : clusterSet) {
            if (!groupClusters) continue;
            this.groupCluster(vertices);
        }
    }

    public int getGraphType() {
        return this.graphType;
    }

    public void setGraphType(int graphType) {
        this.graphType = graphType;
        ArrayList egdes = new ArrayList(this.graph.getEdges());
        Iterator it = egdes.iterator();
        while (it.hasNext()) {
            this.graph.removeEdge(it.next());
        }
        ArrayList messages = new ArrayList(this.visible_messages);
        this.visible_messages.clear();
        for (Message message : messages) {
            this.updateMessage(message, false);
        }
        this.repaintCanvas();
    }

    protected void lockAgents() {
        Iterator it = this.graph.getVertices().iterator();
        while (it.hasNext()) {
            this.layout.lock(it.next(), true);
        }
    }

    protected void unlockAgents() {
        Iterator it = this.graph.getVertices().iterator();
        while (it.hasNext()) {
            this.layout.lock(it.next(), false);
        }
    }

    protected void groupCluster(Set vertices) {
        if (vertices.size() > 1 && vertices.size() < this.graph.getVertexCount()) {
            Point2D center = this.layout.transform(vertices.iterator().next());
            Graph subGraph = (Graph)this.graphFactory.create();
            Iterator it = vertices.iterator();
            while (it.hasNext()) {
                subGraph.addVertex(it.next());
            }
            GraphCircleLayout subLayout = new GraphCircleLayout(subGraph);
            subLayout.setInitializer((Transformer)this.vv.getGraphLayout());
            subLayout.setSize(new Dimension(40, 40));
            this.layout.put((Layout)subLayout, center);
        }
    }

    public class MessageGroup
    extends ComponentGroup {
        public MessageGroup() {
        }

        public MessageGroup(Message message) {
            this.addElement(message);
        }
    }

    public class AgentGroup
    extends ComponentGroup {
        public AgentGroup() {
        }

        public AgentGroup(Component agent) {
            this.addElement(agent);
        }
    }

    protected static final class DirectionDisplayPredicate
    implements Predicate {
        protected boolean show_d;
        protected boolean show_u;

        public DirectionDisplayPredicate(boolean show_d, boolean show_u) {
            this.show_d = show_d;
            this.show_u = show_u;
        }

        public void showDirected(boolean b) {
            this.show_d = b;
        }

        public void showUndirected(boolean b) {
            this.show_u = b;
        }

        public boolean evaluate(Object context) {
            Graph graph = (Graph)((Context)context).graph;
            MessageGroup e = (MessageGroup)((Context)context).element;
            if (graph.getEdgeType((Object)e) == EdgeType.DIRECTED && this.show_d) {
                return true;
            }
            return graph.getEdgeType((Object)e) == EdgeType.UNDIRECTED && this.show_u;
        }
    }
}

