/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Transformer;

public class GraphEdgeBetweennessClusterer
implements Transformer {
    private int mNumEdgesToRemove;
    private List mEdgesRemoved;
    private Map mEdgeWeights = new HashMap();

    public GraphEdgeBetweennessClusterer(int numEdgesToRemove) {
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.mEdgesRemoved = new ArrayList();
    }

    public GraphEdgeBetweennessClusterer(int numEdgesToRemove, Map edgeWeights) {
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.mEdgesRemoved = new ArrayList();
        this.mEdgeWeights = edgeWeights;
    }

    public Object transform(Object graph) {
        if (this.mNumEdgesToRemove < 0 || this.mNumEdgesToRemove > ((Graph)graph).getEdgeCount()) {
            throw new IllegalArgumentException("Invalid number of edges passed in.");
        }
        HashMap<Object, Pair> removedEdges = new HashMap<Object, Pair>();
        this.mEdgesRemoved.clear();
        for (int k = 0; k < this.mNumEdgesToRemove; ++k) {
            BetweennessCentrality bc = new BetweennessCentrality((Graph)graph, false);
            bc.setEdgeWeights(this.mEdgeWeights);
            bc.setRemoveRankScoresOnFinalize(true);
            bc.evaluate();
            Ranking highestBetweenness = (Ranking)bc.getRankings().get(0);
            Object removedEdge = highestBetweenness.getRanked();
            Pair removedEdgeEndpoints = ((Graph)graph).getEndpoints(removedEdge);
            removedEdges.put(removedEdge, removedEdgeEndpoints);
            this.mEdgesRemoved.add(highestBetweenness.getRanked());
            ((Graph)graph).removeEdge(highestBetweenness.getRanked());
        }
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        Set clusterSet = wcSearch.transform((Graph)graph);
        for (Object o : this.mEdgesRemoved) {
            Pair endpoints = (Pair)removedEdges.get(o);
            ((Graph)graph).addEdge(o, endpoints.getFirst(), endpoints.getSecond());
        }
        return clusterSet;
    }

    public List getEdgesRemoved() {
        return this.mEdgesRemoved;
    }
}

