/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.RadiusGraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

public class GraphISOMLayout
extends AbstractLayout
implements IterativeContext {
    Map isomVertexData = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

        public Object create() {
            return new ISOMVertexData();
        }
    });
    private int maxEpoch;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    protected GraphElementAccessor elementAccessor = new RadiusGraphElementAccessor();
    private double coolingFactor;
    private List queue = new ArrayList();
    private String status = null;
    ISOMVertexData tempISOM;
    Point2D tempXYD;

    public String getStatus() {
        return this.status;
    }

    public GraphISOMLayout(Graph g) {
        super(g);
    }

    public void initialize() {
        this.setInitializer((Transformer)new RandomLocationTransformer(this.getSize()));
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    public void step() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
        }
    }

    private synchronized void adjust() {
        this.tempISOM = new ISOMVertexData();
        this.tempXYD = new Point2D.Double();
        this.tempXYD.setLocation(10.0 + Math.random() * this.getSize().getWidth(), 10.0 + Math.random() * this.getSize().getHeight());
        Object winner = this.elementAccessor.getVertex((Layout)this, this.tempXYD.getX(), this.tempXYD.getY());
        if (winner == null) {
            return;
        }
        while (true) {
            try {
                Iterator it = this.getGraph().getVertices().iterator();
                while (it.hasNext()) {
                    ISOMVertexData ivd = this.getISOMVertexData(it.next());
                    ivd.distance = 0;
                    ivd.visited = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.adjustVertex(winner);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(Object v) {
        this.queue.clear();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        block2: while (!this.queue.isEmpty()) {
            Object current = this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            Point2D currXYData = this.transform(current);
            double dx = this.tempXYD.getX() - currXYData.getX();
            double dy = this.tempXYD.getY() - currXYData.getY();
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            currXYData.setLocation(currXYData.getX() + factor * dx, currXYData.getY() + factor * dy);
            if (currData.distance >= this.radius) continue;
            Collection s = this.getGraph().getNeighbors(current);
            while (true) {
                try {
                    for (Object child : s) {
                        ISOMVertexData childData = this.getISOMVertexData(child);
                        if (childData == null || childData.visited) continue;
                        childData.visited = true;
                        childData.distance = currData.distance + 1;
                        this.queue.add(child);
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }

    public ISOMVertexData getISOMVertexData(Object v) {
        return (ISOMVertexData)this.isomVertexData.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean done() {
        return this.epoch >= this.maxEpoch;
    }

    public void reset() {
        this.epoch = 0;
    }

    public static class ISOMVertexData {
        public DoubleMatrix1D disp;
        int distance;
        boolean visited;

        public ISOMVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
            this.distance = 0;
            this.visited = false;
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

