/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;

public class GraphLayoutTransition
extends LayoutTransition {
    public GraphLayoutTransition(VisualizationViewer vv, Layout startLayout, Layout endLayout) {
        super(vv, startLayout, endLayout);
    }

    public void step() {
        Graph g = this.transitionLayout.getGraph();
        try {
            for (Object v : g.getVertices()) {
                Point2D tp = (Point2D)this.transitionLayout.transform(v);
                Point2D fp = (Point2D)this.endLayout.transform(v);
                double dx = (fp.getX() - tp.getX()) / (double)(this.count - this.counter);
                double dy = (fp.getY() - tp.getY()) / (double)(this.count - this.counter);
                this.transitionLayout.setLocation(v, (Point2D)new Point2D.Double(tp.getX() + dx, tp.getY() + dy));
            }
        }
        catch (ConcurrentModificationException e) {
            this.counter = this.count;
        }
        ++this.counter;
        if (this.counter >= this.count) {
            this.done = true;
            this.vv.setGraphLayout(this.endLayout);
        }
        this.vv.repaint();
    }
}

