/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import jadex.commons.SUtil;
import jadex.commons.gui.SGUI;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.graph.GraphCanvas;
import jadex.tools.comanalyzer.graph.GraphCircleLayout;
import jadex.tools.comanalyzer.graph.GraphISOMLayout;
import jadex.tools.comanalyzer.table.TablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphPanel
extends ToolTab
implements ActionListener,
ChangeListener {
    private static final String COMANALYZER_IMAGES = "/jadex/tools/comanalyzer/images/";
    protected static final UIDefaults defaults = new UIDefaults(new Object[]{"refresh", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/refresh2.png"), "zoom", SGUI.makeIcon(TablePanel.class, (String)"/jadex/tools/comanalyzer/images/zoom.png")});
    public static final Map LAYOUTS = new LinkedHashMap();
    protected GraphCanvas panelcan = new GraphCanvas(this);
    protected JRadioButton g_mgraph;
    protected JRadioButton g_dgraph;
    protected JRadioButton g_ugraph;
    protected JComboBox l_layout;
    protected JButton l_refresh;
    protected JCheckBox l_init;
    protected JCheckBox l_animate;
    protected JCheckBox l_gmmode;
    protected JSlider l_zoom_slider;
    protected JButton l_identity;
    protected JCheckBox v_label;
    protected JCheckBox v_font;
    protected JCheckBox v_size;
    protected JSlider v_size_slider;
    protected JSlider v_prop_slider;
    protected JCheckBox e_label;
    protected JCheckBox e_font;
    protected JCheckBox e_size;
    protected JSlider e_size_slider;
    protected JSlider e_prop_slider;
    protected JRadioButton e_nocolor;
    protected JRadioButton e_convid;
    protected JRadioButton e_perform;
    protected JRadioButton e_protocol;
    protected JToggleButton cluster;
    protected JSlider cluster_slider;

    public GraphPanel(ComanalyzerPlugin plugin) {
        super(plugin, "Graph", null);
        final JScrollPane options = new JScrollPane();
        this.addBottomControls(options);
        final JSplitPane main = new JSplitPane(1, this.panelcan, options);
        main.setOneTouchExpandable(true);
        main.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add("North", SGUI.createToolBar((String)"Graph Panel Options", (Action[])this.getActions()));
        this.add("Center", main);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double scrollWidth;
                double optionsWidth;
                double mainWidth = main.getWidth();
                double loc = (mainWidth - (optionsWidth = options.getPreferredSize().getWidth()) - (scrollWidth = options.getVerticalScrollBar().isVisible() ? (double)options.getVerticalScrollBar().getWidth() : 0.0)) / mainWidth;
                if (loc >= 0.0 && loc <= 1.0) {
                    main.setDividerLocation(loc);
                }
            }
        });
    }

    @Override
    public ToolCanvas getCanvas() {
        return this.panelcan;
    }

    @Override
    public Action[] getActions() {
        if (this.actions == null) {
            List actionlist = SUtil.arrayToList((Object)super.getActions());
            this.actions = actionlist.toArray(new Action[actionlist.size()]);
        }
        return this.actions;
    }

    protected void addBottomControls(JScrollPane options) {
        JPanel control_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = -1;
        Box graph_panel = Box.createVerticalBox();
        graph_panel.setBorder(BorderFactory.createTitledBorder("Graph"));
        ButtonGroup bg_graph = new ButtonGroup();
        this.g_mgraph = new JRadioButton("Directed Multigraph");
        this.g_mgraph.setSelected(this.panelcan.getGraphType() == 0);
        this.g_mgraph.addActionListener(this);
        this.g_dgraph = new JRadioButton("Directed Graph");
        this.g_dgraph.setSelected(this.panelcan.getGraphType() == 1);
        this.g_dgraph.addActionListener(this);
        this.g_ugraph = new JRadioButton("Undirected Graph");
        this.g_ugraph.setSelected(this.panelcan.getGraphType() == 2);
        this.g_ugraph.addActionListener(this);
        bg_graph.add(this.g_mgraph);
        bg_graph.add(this.g_dgraph);
        bg_graph.add(this.g_ugraph);
        graph_panel.add(this.g_mgraph);
        graph_panel.add(this.g_dgraph);
        graph_panel.add(this.g_ugraph);
        control_panel.add((Component)graph_panel, gbc);
        Box layout_panel = Box.createVerticalBox();
        layout_panel.setBorder(BorderFactory.createTitledBorder("Layout"));
        JPanel l_layout_panel = new JPanel(new GridBagLayout());
        this.l_layout = new JComboBox<String>(LAYOUTS.keySet().toArray(new String[LAYOUTS.keySet().size()]));
        this.l_layout.setSelectedIndex(0);
        this.l_layout.addActionListener(new LayoutComboListener());
        this.l_refresh = new JButton(defaults.getIcon("refresh"));
        this.l_refresh.setToolTipText("Reinitialize Layout");
        this.l_refresh.addActionListener(this);
        JPanel l_control_panel = new JPanel(new GridLayout(4, 0));
        this.l_init = new JCheckBox("Initialize On Change");
        this.l_init.setSelected(this.panelcan.autolayout);
        this.l_init.addActionListener(this);
        this.l_animate = new JCheckBox("Animate Transitions");
        this.l_animate.setSelected(this.panelcan.animate);
        this.l_animate.addActionListener(this);
        this.l_gmmode = new JCheckBox("Enable Transforming");
        this.l_gmmode.setSelected(this.panelcan.gm.getSelectedObjects()[0] == ModalGraphMouse.Mode.TRANSFORMING);
        this.l_gmmode.addActionListener(this);
        this.l_zoom_slider = new JSlider(0);
        this.l_zoom_slider.setMinimum(1);
        this.l_zoom_slider.setMaximum(300);
        this.l_zoom_slider.setValue(50);
        this.l_zoom_slider.setPreferredSize(new Dimension(60, 0));
        this.l_zoom_slider.addChangeListener(this);
        this.l_identity = new JButton(defaults.getIcon("zoom"));
        this.l_identity.setToolTipText("Set Zoom To Identity");
        this.l_identity.addActionListener(this);
        JPanel zp = new JPanel(new GridBagLayout());
        zp.add((Component)new JLabel("Zoom"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 6, 2, 2), 0, 0));
        zp.add((Component)this.l_zoom_slider, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        zp.add((Component)this.l_identity, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        l_layout_panel.add((Component)this.l_layout, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 3, 2, 2), 0, 0));
        l_layout_panel.add((Component)this.l_refresh, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        l_control_panel.add(this.l_init);
        l_control_panel.add(this.l_animate);
        l_control_panel.add(this.l_gmmode);
        l_control_panel.add(zp);
        layout_panel.add(l_layout_panel);
        layout_panel.add(l_control_panel);
        control_panel.add((Component)layout_panel, gbc);
        Box agent_panel = Box.createVerticalBox();
        agent_panel.setBorder(BorderFactory.createTitledBorder("Agents"));
        JPanel v_label_panel = new JPanel(new GridLayout(0, 2));
        this.v_label = new JCheckBox("Show Labels");
        this.v_label.setSelected(this.panelcan.v_string.isEnabled());
        this.v_label.addActionListener(this);
        this.v_font = new JCheckBox("Bold Text");
        this.v_font.setSelected(this.panelcan.v_font.getBold());
        this.v_font.setEnabled(this.v_label.isSelected());
        this.v_font.addActionListener(this);
        v_label_panel.add(this.v_label);
        v_label_panel.add(this.v_font);
        JPanel v_size_panel = new JPanel(new BorderLayout());
        this.v_size = new JCheckBox("Size by Degree");
        this.v_size.addActionListener(this);
        this.v_size.setSelected(this.panelcan.v_icon.isScaling());
        this.v_size_slider = new JSlider(0);
        this.v_size_slider.setEnabled(this.v_size.isSelected());
        this.v_size_slider.setMinimum(0);
        this.v_size_slider.setMaximum(76);
        this.v_size_slider.setValue(0);
        this.v_size_slider.setPreferredSize(new Dimension(60, 0));
        this.v_size_slider.addChangeListener(this);
        this.v_prop_slider = new JSlider(0);
        this.v_prop_slider.setEnabled(this.v_size.isSelected());
        this.v_prop_slider.setMinimum(1);
        this.v_prop_slider.setMaximum(100);
        this.v_prop_slider.setValue(50);
        this.v_prop_slider.setPreferredSize(new Dimension(60, 0));
        this.v_prop_slider.addChangeListener(this);
        v_size_panel.add((Component)this.v_size, "West");
        v_size_panel.add((Component)this.v_size_slider, "Center");
        v_size_panel.add((Component)this.v_prop_slider, "East");
        agent_panel.add(v_label_panel);
        agent_panel.add(v_size_panel);
        control_panel.add((Component)agent_panel, gbc);
        Box message_panel = Box.createVerticalBox();
        message_panel.setBorder(BorderFactory.createTitledBorder("Messages"));
        JPanel e_label_panel = new JPanel(new GridLayout(0, 2));
        this.e_label = new JCheckBox("Show Labels");
        this.e_label.setSelected(this.panelcan.e_string.isEnabled());
        this.e_label.addActionListener(this);
        this.e_font = new JCheckBox("Bold Text");
        this.e_font.setSelected(this.panelcan.e_font.getBold());
        this.e_font.setEnabled(this.e_label.isSelected());
        this.e_font.addActionListener(this);
        e_label_panel.add(this.e_label);
        e_label_panel.add(this.e_font);
        JPanel e_size_panel = new JPanel(new BorderLayout());
        this.e_size = new JCheckBox("Size by Degree");
        this.e_size.addActionListener(this);
        this.e_size.setSelected(this.panelcan.e_stroke.isScaling());
        this.e_size_slider = new JSlider(0);
        this.e_size_slider.setEnabled(this.e_size.isSelected());
        this.e_size_slider.setPreferredSize(new Dimension(60, 0));
        this.e_size_slider.setMinimum(0);
        this.e_size_slider.setMaximum(19);
        this.e_size_slider.setValue(0);
        this.e_size_slider.addChangeListener(this);
        this.e_prop_slider = new JSlider(0);
        this.e_prop_slider.setEnabled(this.e_size.isSelected());
        this.e_prop_slider.setMinimum(1);
        this.e_prop_slider.setMaximum(100);
        this.e_prop_slider.setValue(50);
        this.e_prop_slider.setPreferredSize(new Dimension(60, 0));
        this.e_prop_slider.addChangeListener(this);
        e_size_panel.add((Component)this.e_size, "West");
        e_size_panel.add((Component)this.e_size_slider, "Center");
        e_size_panel.add((Component)this.e_prop_slider, "East");
        JPanel color_panel = new JPanel(new GridLayout(2, 2));
        color_panel.setBorder(BorderFactory.createTitledBorder("Color By"));
        ButtonGroup bg_colors = new ButtonGroup();
        this.e_nocolor = new JRadioButton("No colors");
        this.e_nocolor.setSelected(this.panelcan.e_paint.getPaintMode() == 0);
        this.e_nocolor.addActionListener(this);
        this.e_convid = new JRadioButton("Converstation");
        this.e_convid.setSelected(this.panelcan.e_paint.getPaintMode() == 1);
        this.e_convid.addActionListener(this);
        this.e_perform = new JRadioButton("Performative");
        this.e_perform.setSelected(this.panelcan.e_paint.getPaintMode() == 2);
        this.e_perform.addActionListener(this);
        this.e_protocol = new JRadioButton("Protocol");
        this.e_protocol.setSelected(this.panelcan.e_paint.getPaintMode() == 3);
        this.e_protocol.addActionListener(this);
        bg_colors.add(this.e_nocolor);
        bg_colors.add(this.e_convid);
        bg_colors.add(this.e_perform);
        bg_colors.add(this.e_protocol);
        color_panel.add(this.e_nocolor);
        color_panel.add(this.e_convid);
        color_panel.add(this.e_perform);
        color_panel.add(this.e_protocol);
        message_panel.add(e_label_panel);
        message_panel.add(e_size_panel);
        message_panel.add(color_panel);
        control_panel.add((Component)message_panel, gbc);
        Box cluster_panel = Box.createVerticalBox();
        cluster_panel.setBorder(BorderFactory.createTitledBorder("Cluster"));
        JPanel cl_panel = new JPanel(new GridLayout(2, 0));
        this.cluster = new JCheckBox("Enable Edge-Betweenness");
        this.cluster.setAlignmentX(0.0f);
        this.cluster.setSelected(this.panelcan.cluster);
        this.cluster.addActionListener(this);
        this.cluster_slider = new JSlider(0);
        this.cluster_slider.setMaximum(100);
        this.cluster_slider.setMinimum(0);
        this.cluster_slider.setValue(0);
        this.cluster_slider.setPreferredSize(new Dimension(100, 0));
        this.cluster_slider.addChangeListener(this);
        cl_panel.add(this.cluster);
        cl_panel.add(this.cluster_slider);
        cluster_panel.add(cl_panel);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)control_panel, "North");
        options.setViewportView(jp);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.l_zoom_slider) {
            int val = source.getValue();
            this.panelcan.scaler.scale(this.panelcan.vv, (float)val / 50.0f, this.panelcan.vv.getCenter());
        } else if (source == this.v_size_slider) {
            this.panelcan.v_icon.setScaleRange(source.getValue());
            this.panelcan.vv.repaint();
        } else if (source == this.v_prop_slider) {
            this.panelcan.v_icon.setPropFactor(source.getValue());
            this.panelcan.vv.repaint();
        } else if (source == this.e_size_slider) {
            this.panelcan.e_stroke.setScaleRange(source.getValue());
            this.panelcan.vv.repaint();
        } else if (source == this.e_prop_slider) {
            this.panelcan.e_stroke.setPropValue(source.getValue());
            this.panelcan.vv.repaint();
        } else if (source == this.cluster_slider && !source.getValueIsAdjusting()) {
            this.panelcan.lockAgents();
            this.panelcan.clusterGraph(this.cluster_slider.getValue(), this.cluster.isSelected());
            this.panelcan.repaintCanvas();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.g_mgraph) {
            this.panelcan.setGraphType(0);
        } else if (source == this.g_dgraph) {
            this.panelcan.setGraphType(1);
        } else if (source == this.g_ugraph) {
            this.panelcan.setGraphType(2);
        } else if (source == this.l_refresh) {
            this.l_layout.setSelectedIndex(this.l_layout.getSelectedIndex());
        } else if (source == this.l_init) {
            this.panelcan.autolayout = source.isSelected();
            this.l_animate.setEnabled(source.isSelected());
        } else if (source == this.l_animate) {
            this.panelcan.animate = source.isSelected();
        } else if (source == this.l_gmmode) {
            this.panelcan.gm.setMode(source.isSelected() ? ModalGraphMouse.Mode.TRANSFORMING : ModalGraphMouse.Mode.PICKING);
        } else if (source == this.l_identity) {
            this.panelcan.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
            this.l_zoom_slider.setValue(50);
        } else if (source == this.e_nocolor) {
            this.panelcan.e_paint.setPaintMode(0);
            this.panelcan.vv.repaint();
        } else if (source == this.e_convid) {
            this.panelcan.e_paint.setPaintMode(1);
            this.panelcan.vv.repaint();
        } else if (source == this.e_perform) {
            this.panelcan.e_paint.setPaintMode(2);
            this.panelcan.vv.repaint();
        } else if (source == this.e_protocol) {
            this.panelcan.e_paint.setPaintMode(3);
            this.panelcan.vv.repaint();
        } else if (source == this.v_label) {
            this.panelcan.v_string.setEnabled(source.isSelected());
            this.v_font.setEnabled(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.e_label) {
            this.panelcan.e_string.setEnabled(source.isSelected());
            this.e_font.setEnabled(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.v_font) {
            this.panelcan.v_font.setBold(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.e_font) {
            this.panelcan.e_font.setBold(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.v_size) {
            this.panelcan.v_icon.setScaling(source.isSelected());
            this.v_size_slider.setEnabled(source.isSelected());
            this.v_prop_slider.setEnabled(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.e_size) {
            this.panelcan.e_stroke.setScaling(source.isSelected());
            this.e_size_slider.setEnabled(source.isSelected());
            this.e_prop_slider.setEnabled(source.isSelected());
            this.panelcan.vv.repaint();
        } else if (source == this.cluster) {
            this.panelcan.lockAgents();
            this.panelcan.clusterGraph(this.cluster_slider.getValue(), source.isSelected());
            this.cluster_slider.setEnabled(source.isSelected());
            this.panelcan.repaintCanvas();
        }
    }

    static {
        LAYOUTS.put("Kamada-Kawai", KKLayout.class);
        LAYOUTS.put("Fruchterman-Reingold ", FRLayout.class);
        LAYOUTS.put("Circle Layout", GraphCircleLayout.class);
        LAYOUTS.put("Spring Layout", SpringLayout2.class);
        LAYOUTS.put("Meyer's self-organizing", GraphISOMLayout.class);
    }

    protected final class LayoutComboListener
    implements ActionListener {
        protected LayoutComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JComboBox jcb = (JComboBox)arg0.getSource();
            Object[] constructorArgs = new Object[]{GraphPanel.this.panelcan.graph};
            Class layoutC = (Class)LAYOUTS.get(jcb.getSelectedItem());
            try {
                Constructor constructor = layoutC.getConstructor(Graph.class);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                l.setSize(GraphPanel.this.panelcan.vv.getSize());
                GraphPanel.this.panelcan.layout.removeAll();
                GraphPanel.this.panelcan.layout.setDelegate(l);
                GraphPanel.this.panelcan.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                GraphPanel.this.l_zoom_slider.setValue(50);
                GraphPanel.this.panelcan.reinitializeCanvas();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

