/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.Pair;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.graph.GraphCanvas;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MessageNumberIndexFunction
implements EdgeIndexFunction {
    protected Map edge_index = new HashMap();

    public int getIndex(Graph graph, Object group) {
        Integer index = (Integer)this.edge_index.get(group);
        if (index == null) {
            if (((GraphCanvas.MessageGroup)group).isSingelton()) {
                Pair ep = graph.getEndpoints(group);
                ArrayList comedgeset = new ArrayList();
                comedgeset.addAll(graph.findEdgeSet(ep.getFirst(), ep.getSecond()));
                Collections.sort(comedgeset, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        GraphCanvas.MessageGroup mg1 = (GraphCanvas.MessageGroup)o1;
                        GraphCanvas.MessageGroup mg2 = (GraphCanvas.MessageGroup)o2;
                        if (mg1.isSingelton() && mg2.isSingelton()) {
                            Message m1 = (Message)mg1.getSingelton();
                            Message m2 = (Message)mg2.getSingelton();
                            return m1.compareTo(m2);
                        }
                        return 0;
                    }
                });
                int count = 0;
                for (GraphCanvas.MessageGroup other : comedgeset) {
                    Message m2;
                    Message m1 = (Message)((GraphCanvas.MessageGroup)group).getSingelton();
                    if (m1.equals(m2 = (Message)other.getSingelton())) continue;
                    this.edge_index.put(other, count);
                    ++count;
                }
                this.edge_index.put(group, count);
                index = count;
            } else {
                index = 0;
            }
        }
        return index;
    }

    public void reset(Graph graph, Object group) {
        Pair endpoints = graph.getEndpoints(group);
        this.getIndex(graph, (GraphCanvas.MessageGroup)group, (GraphCanvas.AgentGroup)endpoints.getFirst());
        this.getIndex(graph, (GraphCanvas.MessageGroup)group, (GraphCanvas.AgentGroup)endpoints.getFirst(), (GraphCanvas.AgentGroup)endpoints.getSecond());
    }

    public void reset() {
        this.edge_index.clear();
    }

    protected int getIndex(Graph graph, GraphCanvas.MessageGroup group, GraphCanvas.AgentGroup agents1, GraphCanvas.AgentGroup agents2) {
        HashSet commonEdgeSet = new HashSet(graph.getIncidentEdges((Object)agents1));
        int count = 0;
        for (GraphCanvas.MessageGroup other : commonEdgeSet) {
            if (group.equals(other)) continue;
            this.edge_index.put(other, count);
            ++count;
        }
        this.edge_index.put(group, count);
        return count;
    }

    protected int getIndex(Graph graph, GraphCanvas.MessageGroup e, GraphCanvas.AgentGroup v) {
        HashSet<GraphCanvas.MessageGroup> commonedgeset = new HashSet<GraphCanvas.MessageGroup>();
        for (GraphCanvas.MessageGroup other : graph.getIncidentEdges((Object)v)) {
            GraphCanvas.AgentGroup u = (GraphCanvas.AgentGroup)graph.getOpposite((Object)v, (Object)other);
            if (!u.equals(v)) continue;
            commonedgeset.add(other);
        }
        int count = 0;
        for (GraphCanvas.MessageGroup other : commonedgeset) {
            if (e.equals(other)) continue;
            this.edge_index.put(other, count);
            ++count;
        }
        this.edge_index.put(e, count);
        return count;
    }
}

