/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections15.Factory;

public class MultidirectedMultiGraph
extends SparseGraph
implements Graph,
Serializable {
    protected static final int INCOMING = 0;
    protected static final int OUTGOING = 1;
    protected static final int INCIDENT = 2;
    protected Map mvertex_maps = new HashMap();
    protected Map mdirected_edges = new HashMap();
    protected Map mundirected_edges = new HashMap();

    public static Factory getFactory() {
        return new Factory(){

            public Object create() {
                return new MultidirectedMultiGraph();
            }
        };
    }

    public static Graph create() {
        return new MultidirectedMultiGraph();
    }

    public boolean addEdge(Object edge, Pair endpoints) {
        return this.addEdge(edge, endpoints, EdgeType.DIRECTED);
    }

    public boolean addEdge(Object edge, Pair endpoints, EdgeType edgeType) {
        Pair new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        Object v1 = new_endpoints.getFirst();
        Object v2 = new_endpoints.getSecond();
        if (!this.containsVertex(v1)) {
            this.addVertex(v1);
        }
        if (!this.containsVertex(v2)) {
            this.addVertex(v2);
        }
        if (edgeType == EdgeType.DIRECTED) {
            this.getOutgoing_internal(v1).add(edge);
            this.getIncoming_internal(v2).add(edge);
            this.mdirected_edges.put(edge, new_endpoints);
        } else {
            this.getIncident_internal(v1).add(edge);
            this.getIncident_internal(v2).add(edge);
            this.mundirected_edges.put(edge, new_endpoints);
        }
        return true;
    }

    public boolean addEdge(Object e, Object v1, Object v2) {
        return this.addEdge(e, new Pair(v1, v2));
    }

    public boolean addEdge(Object e, Object v1, Object v2, EdgeType edgeType) {
        return this.addEdge(e, new Pair(v1, v2), edgeType);
    }

    public Object findEdge(Object v1, Object v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        for (Object e : this.getOutEdges(v1)) {
            if (!this.getOpposite(v1, e).equals(v2)) continue;
            return e;
        }
        return null;
    }

    public Collection findEdgeSet(Object v1, Object v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList edges = new ArrayList();
        for (Object e : this.getOutEdges(v1)) {
            if (!this.getOpposite(v1, e).equals(v2)) continue;
            edges.add(e);
        }
        return Collections.unmodifiableCollection(edges);
    }

    public Collection getInEdges(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet in = new HashSet();
        in.addAll(this.getIncoming_internal(vertex));
        in.addAll(this.getIncident_internal(vertex));
        return Collections.unmodifiableCollection(in);
    }

    public Collection getOutEdges(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet out = new HashSet();
        out.addAll(this.getIncident_internal(vertex));
        out.addAll(this.getOutgoing_internal(vertex));
        return Collections.unmodifiableCollection(out);
    }

    public Collection getPredecessors(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<Object> preds = new HashSet<Object>();
        Iterator it = this.getIncoming_internal(vertex).iterator();
        while (it.hasNext()) {
            preds.add(this.getSource(it.next()));
        }
        return Collections.unmodifiableCollection(preds);
    }

    public Collection getSuccessors(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<Object> succs = new HashSet<Object>();
        Iterator it = this.getOutgoing_internal(vertex).iterator();
        while (it.hasNext()) {
            succs.add(this.getDest(it.next()));
        }
        return Collections.unmodifiableCollection(succs);
    }

    public Collection getEdges(EdgeType edgeType) {
        if (edgeType == EdgeType.DIRECTED) {
            return Collections.unmodifiableCollection(this.mdirected_edges.keySet());
        }
        if (edgeType == EdgeType.UNDIRECTED) {
            return Collections.unmodifiableCollection(this.mundirected_edges.keySet());
        }
        return null;
    }

    public Pair getEndpoints(Object edge) {
        Pair endpoints = (Pair)this.mdirected_edges.get(edge);
        if (endpoints == null) {
            return (Pair)this.mundirected_edges.get(edge);
        }
        return endpoints;
    }

    public EdgeType getEdgeType(Object edge) {
        if (this.mdirected_edges.containsKey(edge)) {
            return EdgeType.DIRECTED;
        }
        if (this.mundirected_edges.containsKey(edge)) {
            return EdgeType.UNDIRECTED;
        }
        return null;
    }

    public Object getSource(Object directed_edge) {
        if (this.getEdgeType(directed_edge) == EdgeType.DIRECTED) {
            return ((Pair)this.mdirected_edges.get(directed_edge)).getFirst();
        }
        return null;
    }

    public Object getDest(Object directed_edge) {
        if (this.getEdgeType(directed_edge) == EdgeType.DIRECTED) {
            return ((Pair)this.mdirected_edges.get(directed_edge)).getSecond();
        }
        return null;
    }

    public boolean isSource(Object vertex, Object edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        Object source = this.getSource(edge);
        if (source != null) {
            return source.equals(vertex);
        }
        return false;
    }

    public boolean isDest(Object vertex, Object edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        Object dest = this.getDest(edge);
        if (dest != null) {
            return dest.equals(vertex);
        }
        return false;
    }

    public Collection getEdges() {
        ArrayList edges = new ArrayList();
        edges.addAll(this.mdirected_edges.keySet());
        edges.addAll(this.mundirected_edges.keySet());
        return Collections.unmodifiableCollection(edges);
    }

    public Collection getVertices() {
        return Collections.unmodifiableCollection(this.mvertex_maps.keySet());
    }

    public boolean containsVertex(Object vertex) {
        return this.mvertex_maps.containsKey(vertex);
    }

    public boolean containsEdge(Object edge) {
        return this.mdirected_edges.containsKey(edge) || this.mundirected_edges.containsKey(edge);
    }

    public int getEdgeCount() {
        return this.mdirected_edges.size() + this.mundirected_edges.size();
    }

    public int getVertexCount() {
        return this.mvertex_maps.size();
    }

    public Collection getNeighbors(Object vertex) {
        HashSet<Object> neighbors = new HashSet<Object>();
        Iterator it = this.getIncoming_internal(vertex).iterator();
        while (it.hasNext()) {
            neighbors.add(this.getSource(it.next()));
        }
        it = this.getOutgoing_internal(vertex).iterator();
        while (it.hasNext()) {
            neighbors.add(this.getDest(it.next()));
        }
        it = this.getIncident_internal(vertex).iterator();
        while (it.hasNext()) {
            Pair endpoints = this.getEndpoints(it.next());
            Object e_a = endpoints.getFirst();
            Object e_b = endpoints.getSecond();
            if (vertex.equals(e_a)) {
                neighbors.add(e_b);
                continue;
            }
            neighbors.add(e_a);
        }
        return Collections.unmodifiableCollection(neighbors);
    }

    public int degree(Object vertex) {
        return this.getIncidentEdges(vertex).size();
    }

    public Collection getIncidentEdges(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet incident = new HashSet();
        incident.addAll(this.getIncident_internal(vertex));
        incident.addAll(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        return Collections.unmodifiableCollection(incident);
    }

    public boolean addVertex(Object vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.mvertex_maps.put(vertex, new HashSet[]{new HashSet(), new HashSet(), new HashSet()});
            return true;
        }
        return false;
    }

    public boolean removeVertex(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        if (this.getIncidentEdges(vertex) == null) {
            System.err.println("no edge in main");
        }
        ArrayList incident = new ArrayList(this.getIncidentEdges(vertex));
        for (int i = 0; i < incident.size(); ++i) {
            this.removeEdge(incident.get(i));
        }
        this.mvertex_maps.remove(vertex);
        return true;
    }

    public boolean removeEdge(Object edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair endpoints = this.getEndpoints(edge);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        if (this.getEdgeType(edge) == EdgeType.DIRECTED) {
            this.getOutgoing_internal(v1).remove(edge);
            this.getIncoming_internal(v2).remove(edge);
            this.mdirected_edges.remove(edge);
        } else {
            this.getIncident_internal(v1).remove(edge);
            this.getIncident_internal(v2).remove(edge);
            this.mundirected_edges.remove(edge);
        }
        return true;
    }

    protected Collection getIncoming_internal(Object vertex) {
        return (Collection)((Object[])this.mvertex_maps.get(vertex))[0];
    }

    protected Collection getIncident_internal(Object vertex) {
        return (Collection)((Object[])this.mvertex_maps.get(vertex))[2];
    }

    protected Collection getOutgoing_internal(Object vertex) {
        return (Collection)((Object[])this.mvertex_maps.get(vertex))[1];
    }
}

