/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.ComponentFilterMenu;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilterMenu;
import jadex.tools.comanalyzer.graph.GraphCanvas;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class PopupGraphMousePlugin
extends AbstractPopupGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private final GraphCanvas canvas;

    public PopupGraphMousePlugin(GraphCanvas canvas) {
        this(canvas, 20);
    }

    public PopupGraphMousePlugin(GraphCanvas canvas, int modifiers) {
        super(modifiers);
        this.canvas = canvas;
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        GraphElementAccessor pickSupport = this.canvas.vv.getPickSupport();
        if (pickSupport != null) {
            GraphCanvas.AgentGroup agents = (GraphCanvas.AgentGroup)pickSupport.getVertex(this.canvas.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            GraphCanvas.MessageGroup edge = (GraphCanvas.MessageGroup)pickSupport.getEdge(this.canvas.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            if (edge != null && edge.isSingelton() && e.getButton() == 1 && e.getClickCount() == 2) {
                this.canvas.getToolTab().getToolPanel().showElementDetails(((Message)edge.getSingelton()).getParameters());
            }
            if (agents != null && agents.isSingelton() && e.getButton() == 1 && e.getClickCount() == 2) {
                this.canvas.getToolTab().getToolPanel().showElementDetails(((Component)agents.getSingelton()).getParameters());
            }
        }
    }

    protected void handlePopup(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        Point p = e.getPoint();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        if (pickSupport != null) {
            GraphCanvas.AgentGroup v = (GraphCanvas.AgentGroup)pickSupport.getVertex(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            if (v != null) {
                ComponentFilterMenu apopup;
                Set picked = vv.getPickedVertexState().getPicked();
                if (picked.contains(v)) {
                    ArrayList agents = new ArrayList();
                    Iterator it = picked.iterator();
                    while (it.hasNext()) {
                        agents.addAll(((GraphCanvas.AgentGroup)it.next()).getElements());
                    }
                    apopup = new ComponentFilterMenu(this.canvas.getToolTab().getPlugin(), agents.toArray(new Component[agents.size()]));
                } else {
                    vv.getPickedVertexState().clear();
                    vv.getPickedVertexState().pick((Object)v, true);
                    vv.repaint();
                    List agents = v.getElements();
                    apopup = new ComponentFilterMenu(this.canvas.getToolTab().getPlugin(), agents.toArray(new Component[agents.size()]));
                }
                apopup.show((java.awt.Component)vv, e.getX(), e.getY());
            } else {
                GraphCanvas.MessageGroup edge = (GraphCanvas.MessageGroup)pickSupport.getEdge(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (edge != null) {
                    MessageFilterMenu mpopup;
                    Set picked = vv.getPickedEdgeState().getPicked();
                    if (picked.contains(edge)) {
                        ArrayList messages = new ArrayList();
                        Iterator it = picked.iterator();
                        while (it.hasNext()) {
                            messages.addAll(((GraphCanvas.MessageGroup)it.next()).getElements());
                        }
                        mpopup = new MessageFilterMenu(this.canvas.getToolTab().getPlugin(), messages.toArray(new Message[messages.size()]));
                    } else {
                        vv.getPickedEdgeState().clear();
                        vv.getPickedEdgeState().pick((Object)edge, true);
                        vv.repaint();
                        List messages = edge.getElements();
                        mpopup = new MessageFilterMenu(this.canvas.getToolTab().getPlugin(), messages.toArray(new Message[messages.size()]));
                    }
                    mpopup.show((java.awt.Component)vv, e.getX(), e.getY());
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        GraphElementAccessor pickSupport = this.canvas.vv.getPickSupport();
        if (pickSupport != null) {
            GraphCanvas.AgentGroup v = (GraphCanvas.AgentGroup)pickSupport.getVertex(this.canvas.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            GraphCanvas.MessageGroup ml = (GraphCanvas.MessageGroup)pickSupport.getEdge(this.canvas.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            if (v == null && ml == null) {
                this.canvas.vv.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.canvas.vv.setCursor(this.cursor);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

