/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.FourPassImageShaper;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.graph.ComponentGroupMultiGraph;
import jadex.tools.comanalyzer.graph.GraphCanvas;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.collections15.Transformer;

public class VertexTransformer {

    public static final class ToolTips
    implements Transformer {
        public Object transform(Object group) {
            if (((GraphCanvas.AgentGroup)group).isSingelton()) {
                return ((Component)((GraphCanvas.AgentGroup)group).getSingelton()).getId();
            }
            return null;
        }
    }

    public static final class ShapeSize
    implements Transformer {
        protected Graph graph;
        protected IconSize iconTransformer;
        protected Map shapeMap = new HashMap();

        public ShapeSize(Graph graph, IconSize iconTransformer) {
            this.graph = graph;
            this.iconTransformer = iconTransformer;
        }

        public Object transform(Object group) {
            Icon icon = (Icon)this.iconTransformer.transform(group);
            if (icon != null && icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                Shape shape = (Shape)this.shapeMap.get(image);
                if (shape == null && (shape = FourPassImageShaper.getShape((Image)image, (int)30)).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                    shape = transform.createTransformedShape(shape);
                    this.shapeMap.put(image, shape);
                }
                return shape;
            }
            return null;
        }
    }

    public static final class IconSize
    implements Transformer {
        public static final int MIN_VERTEX_SIZE = 24;
        public static final int MAX_VERTEX_SIZE = 100;
        protected Map iconMap = new HashMap();
        protected boolean scale = false;
        protected int scaleRange = 1;
        protected int propFactor = 50;
        protected ComponentGroupMultiGraph graph;

        public IconSize(ComponentGroupMultiGraph graph) {
            this.graph = graph;
        }

        public Object transform(Object group) {
            Component agent = (Component)((GraphCanvas.AgentGroup)group).getSingelton();
            String iconname = null;
            iconname = agent.getState().equals("observed") ? "agent_standard" : (agent.getState().equals("ignored") ? "agent_standard" : (agent.getState().equals("dead") ? "agent_dead" : (agent.getState().equals("dummy") ? "agent_dummy" : "agent_unknown")));
            if (this.scale) {
                int highest = this.graph.getHighestVertexWeight() + 1;
                int degree = this.graph.degree(group) + 1;
                double factor = (double)(100 - this.propFactor) / (double)this.propFactor;
                double iconsize = 24.0 + Math.pow((double)degree / (double)highest, factor) * (double)this.scaleRange;
                Icon icon = (Icon)this.iconMap.get(iconname + (int)iconsize);
                if (icon == null) {
                    ImageIcon image = (ImageIcon)GraphCanvas.icons.getIcon(iconname + "_big");
                    icon = new ImageIcon(image.getImage().getScaledInstance((int)iconsize, (int)iconsize, 4));
                    this.iconMap.put(iconname + (int)iconsize, icon);
                }
                return icon;
            }
            return GraphCanvas.icons.getIcon(iconname + "_small");
        }

        public void setScaling(boolean scale) {
            this.scale = scale;
        }

        public boolean isScaling() {
            return this.scale;
        }

        public void setScaleRange(int scaleRange) {
            this.scaleRange = scaleRange;
        }

        public void setPropFactor(int value) {
            this.propFactor = value;
        }
    }

    public static final class LabelFont
    implements Transformer {
        public static final Font f = new Font("Helvetica", 0, 12);
        public static final Font b = new Font("Helvetica", 1, 12);
        protected boolean bold = false;

        public Object transform(Object group) {
            if (this.bold) {
                return b;
            }
            return f;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public boolean getBold() {
            return this.bold;
        }
    }

    public static final class Label
    implements Transformer {
        private boolean enabled;

        public Object transform(Object group) {
            if (this.enabled && ((GraphCanvas.AgentGroup)group).isSingelton()) {
                Component agent = (Component)((GraphCanvas.AgentGroup)group).getSingelton();
                String mls = agent.getId();
                return mls;
            }
            return null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

