/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.table;

import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.commons.collection.SortedList;
import jadex.tools.comanalyzer.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MessageTableModel
extends AbstractTableModel {
    public static final List COLUMN_HEADERS = new ArrayList();
    protected SortedList messages = new SortedList();

    public boolean addMessage(Message message) {
        this.messages.add((Object)message);
        int row = this.messages.size();
        this.fireTableRowsInserted(row, row);
        return true;
    }

    public boolean removeMessage(Message message) {
        int row = this.messages.indexOf((Object)message);
        this.messages.remove((Object)message);
        this.fireTableRowsDeleted(row, row);
        return true;
    }

    public void addMessages(Message[] messages) {
        this.messages.addAll((Collection)SUtil.arrayToList((Object)messages));
        this.fireTableDataChanged();
    }

    public void removeAllMessages() {
        this.messages.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.size();
    }

    @Override
    public int getRowCount() {
        return this.messages != null ? this.messages.size() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.messages == null || rowIndex < 0 || rowIndex >= this.messages.size()) {
            return null;
        }
        Message me = (Message)this.messages.get(rowIndex);
        ColumnHeader header = (ColumnHeader)COLUMN_HEADERS.get(columnIndex);
        return me.getParameter(header.getParamName());
    }

    @Override
    public String getColumnName(int columnIndex) {
        ColumnHeader header = (ColumnHeader)COLUMN_HEADERS.get(columnIndex);
        return header.getColumnName();
    }

    public Class getColumnClass(int columnIndex) {
        ColumnHeader header = (ColumnHeader)COLUMN_HEADERS.get(columnIndex);
        return header.getColumnClass();
    }

    public boolean containsMessage(Message message) {
        return this.messages.contains((Object)message);
    }

    public Message getMessage(int i) {
        return this.messages == null || i < 0 || i >= this.messages.size() ? null : (Message)this.messages.get(i);
    }

    static {
        COLUMN_HEADERS.add(new ColumnHeader("#", "seq-no", Long.class));
        COLUMN_HEADERS.add(new ColumnHeader("Sender", "sender", IComponentIdentifier.class));
        COLUMN_HEADERS.add(new ColumnHeader("Receiver", "receiver", IComponentIdentifier.class));
        COLUMN_HEADERS.add(new ColumnHeader("Peformative", "performative", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Content", "content", Object.class));
        COLUMN_HEADERS.add(new ColumnHeader("Conversation", "conversation_id", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Id", "x_message_id", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Ontology", "ontology", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Protocol", "protocol", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Receivers", "receivers", IComponentIdentifier[].class));
        COLUMN_HEADERS.add(new ColumnHeader("Encoding", "encoding", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Language", "language", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("In Reply To", "in_reply_to", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Reply By", "reply_by", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Reply With", "reply_with", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Reply To", "reply_to", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Date", "x_timestamp", String.class));
        COLUMN_HEADERS.add(new ColumnHeader("Duration", "duration", Long.class));
    }

    private static class ColumnHeader {
        private String columnName;
        private String paramName;
        private Class columnClass;

        public ColumnHeader(String columnName, String paramName, Class columnClass) {
            this.columnName = columnName;
            this.paramName = paramName;
            this.columnClass = columnClass;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getParamName() {
            return this.paramName;
        }
    }
}

