/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer.table;

import jadex.base.gui.jtable.ComponentIdentifierRenderer;
import jadex.base.gui.jtable.ComponentIdentifiersRenderer;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.commons.gui.jtable.DateTimeRenderer;
import jadex.commons.gui.jtable.ResizeableTableHeader;
import jadex.commons.gui.jtable.TableSorter;
import jadex.commons.gui.jtable.VisibilityTableColumnModel;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilterMenu;
import jadex.tools.comanalyzer.ToolCanvas;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.table.MessageTableModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableCanvas
extends ToolCanvas {
    protected boolean autoScroll = true;
    protected TableSorter sorter;
    protected MessageTableModel model = new MessageTableModel();
    protected JTable table;

    public TableCanvas(ToolTab tooltab) {
        super(tooltab);
        this.model.addTableModelListener(new TableChangedListener());
        this.sorter = new TableSorter((TableModel)this.model);
        this.table = new JTable((TableModel)this.sorter);
        this.table.setAutoResizeMode(0);
        this.table.setBackground(UIManager.getColor("List.background"));
        this.table.setPreferredScrollableViewportSize(new Dimension(800, 70));
        this.table.setDefaultRenderer(IComponentIdentifier.class, (TableCellRenderer)new ComponentIdentifierRenderer());
        this.table.setDefaultRenderer(IComponentIdentifier[].class, (TableCellRenderer)new ComponentIdentifiersRenderer());
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTimeRenderer());
        this.table.addMouseListener(new TableMouseListener(this.table));
        VisibilityTableColumnModel columnmodel = new VisibilityTableColumnModel();
        this.table.setColumnModel((TableColumnModel)columnmodel);
        this.table.createDefaultColumnsFromModel();
        columnmodel.setColumnChangeable(columnmodel.getColumn(0), false);
        ResizeableTableHeader header = new ResizeableTableHeader((TableColumnModel)columnmodel);
        header.setTable(this.table);
        header.setAutoResizingEnabled(false);
        header.setIncludeHeaderWidth(false);
        header.setAllColumnWidths(145, -1, -1);
        header.setColumnWidths(columnmodel.getColumn(0), 30, -1, -1);
        this.table.setTableHeader((JTableHeader)header);
        this.sorter.setTableHeader((JTableHeader)header);
        columnmodel.addMouseListener(this.table);
        JScrollPane main = new JScrollPane(this.table);
        main.getViewport().setBackground(UIManager.getColor("List.background"));
        this.setLayout(new BorderLayout());
        this.add("Center", main);
    }

    @Override
    public void updateMessage(Message message, boolean isPresent) {
        if (message.getEndpoints() != null) {
            if (!this.model.containsMessage(message)) {
                this.addMessage(message);
            }
        } else if (isPresent) {
            this.removeMessage(message);
        }
    }

    @Override
    public void removeMessage(Message message) {
        this.model.removeMessage(message);
    }

    @Override
    public void updateComponent(Component agent, boolean update) {
    }

    @Override
    public void removeComponent(Component agent) {
    }

    @Override
    public void repaintCanvas() {
    }

    @Override
    public void clear() {
        this.model.removeAllMessages();
    }

    public void addMessage(Message message) {
        this.model.addMessage(message);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public Message[] getSelectedMessages() {
        Message[] ret = null;
        int count = this.table.getSelectedRowCount();
        if (count > 0) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            int[] rows = this.table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                msgs.add(this.model.getMessage(this.sorter.modelIndex(rows[i])));
            }
            ret = msgs.toArray(new Message[msgs.size()]);
        }
        return ret;
    }

    private class TableMouseListener
    extends MouseAdapter {
        protected JTable table;

        public TableMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point p;
            int selectedRow;
            if (e.getButton() == 3 && (selectedRow = this.table.rowAtPoint(p = e.getPoint())) >= 0) {
                MessageFilterMenu mpopup;
                int[] rows = this.table.getSelectedRows();
                List rowlist = SUtil.arrayToList((Object)rows);
                if (rowlist.size() > 1 && rowlist.contains(selectedRow)) {
                    mpopup = new MessageFilterMenu(TableCanvas.this.tooltab.getPlugin(), TableCanvas.this.getSelectedMessages());
                } else {
                    ListSelectionModel selection = this.table.getSelectionModel();
                    selection.setSelectionInterval(selectedRow, selectedRow);
                    Message message = TableCanvas.this.model.getMessage(TableCanvas.this.sorter.modelIndex(selectedRow));
                    mpopup = new MessageFilterMenu(TableCanvas.this.tooltab.getPlugin(), message);
                }
                mpopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selectedRow;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (selectedRow = this.table.getSelectedRow()) >= 0) {
                Message message = TableCanvas.this.model.getMessage(TableCanvas.this.sorter.modelIndex(selectedRow));
                TableCanvas.this.tooltab.getToolPanel().showElementDetails(message.getParameters());
            }
        }
    }

    private final class TableChangedListener
    implements TableModelListener {
        private TableChangedListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (TableCanvas.this.autoScroll && e.getType() == 1) {
                TableCanvas.this.table.scrollRectToVisible(TableCanvas.this.table.getCellRect(TableCanvas.this.table.getRowCount() - 1, -1, true));
            }
        }
    }
}

