/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.featuredeps;

import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import jadex.bridge.component.DependencyResolver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class DepViewerPanel<T>
extends JPanel {
    protected DirectedSparseGraph g;
    protected VisualizationViewer vv;
    protected boolean showtxt = true;
    protected DependencyResolver<T> dr;
    protected Layout layout;

    public DepViewerPanel(DependencyResolver<T> dr) {
        this.setLayout(new BorderLayout());
        this.g = new DirectedSparseGraph();
        this.layout = new KKLayout((Graph)this.g);
        this.dr = dr;
        this.buildGraph(this.g);
        this.vv = new VisualizationViewer(this.layout, new Dimension(600, 600));
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderContext().setVertexLabelTransformer(new Transformer(){

            public Object transform(Object arg0) {
                return DepViewerPanel.this.showtxt ? arg0.toString() : null;
            }
        });
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer((Transformer)new ConstantTransformer((Object)Color.lightGray));
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.PICKING);
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DepViewerPanel.this.buildGraph(DepViewerPanel.this.g);
                DepViewerPanel.this.vv.repaint();
            }
        });
        this.add((Component)refresh, "South");
        this.vv.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DepViewerPanel.this.layout.setSize(DepViewerPanel.this.vv.getSize());
            }
        });
        this.add((Component)this.vv, "Center");
    }

    protected void buildGraph(DirectedSparseGraph g) {
        Object[] edges = g.getEdges().toArray();
        for (int i = 0; i < edges.length; ++i) {
            g.removeEdge(edges[i]);
        }
        Object[] vers = g.getVertices().toArray();
        for (int i = 0; i < vers.length; ++i) {
            g.removeVertex(vers[i]);
        }
        ArrayList todo = new ArrayList();
        Map nodes = this.dr.getNodes();
        for (Map.Entry node : nodes.entrySet()) {
            g.addVertex(node.getKey());
        }
        for (Map.Entry node : nodes.entrySet()) {
            String edge;
            for (Object n : ((DependencyResolver.NodeInfo)node.getValue()).getMyDeps()) {
                edge = n + "->" + node.getKey();
                if (g.containsEdge((Object)edge)) continue;
                g.addEdge((Object)edge, n, node.getKey());
            }
            for (Object n : ((DependencyResolver.NodeInfo)node.getValue()).getMyDeps()) {
                edge = node.getKey() + "->" + n;
                if (g.containsEdge((Object)edge)) continue;
                g.addEdge((Object)edge, n, node.getKey());
            }
        }
    }

    public static void main(String[] args) {
        DependencyResolver dr = new DependencyResolver();
        DepViewerPanel.createFrame("DR", dr);
        dr.addDependency((Object)"c", (Object)"a");
        dr.addDependency((Object)"d", (Object)"b");
        dr.addDependency((Object)"e", (Object)"c");
        dr.addDependency((Object)"e", (Object)"d");
        dr.addDependency((Object)"f", (Object)"a");
        dr.addDependency((Object)"f", (Object)"b");
        dr.addDependency((Object)"g", (Object)"e");
        dr.addDependency((Object)"g", (Object)"f");
        dr.addDependency((Object)"h", (Object)"g");
        dr.addDependency((Object)"i", (Object)"a");
        dr.addDependency((Object)"j", (Object)"b");
    }

    public static JFrame createFrame(String title, DependencyResolver dr) {
        JFrame f = new JFrame(title);
        f.getContentPane().setLayout(new BorderLayout());
        f.add("Center", new DepViewerPanel(dr));
        f.pack();
        f.setVisible(true);
        return f;
    }
}

