/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.javaparser.javaccimpl.ArgumentsNode;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.Node;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;
import java.util.Collection;
import java.util.Map;

public class CollectionNode
extends ExpressionNode {
    public CollectionNode(ParserImpl p, int id) {
        super(p, id);
    }

    @Override
    public void precompile() {
        if (this.jjtGetNumChildren() != 2) {
            throw new ParseException("Wrong number of child nodes: " + this);
        }
        ExpressionNode collnode = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode argsnode = (ExpressionNode)this.jjtGetChild(1);
        Class<?> clazz = null;
        if (collnode.getStaticType() != null) {
            this.setStaticType(collnode.getStaticType());
            clazz = collnode.getStaticType();
        }
        for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
            ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
            if (node instanceof ArgumentsNode) {
                if (node.jjtGetNumChildren() != 2) {
                    throw new ParseException("Wrong number of subnodes for map content: " + this);
                }
                if (clazz == null || Map.class.isAssignableFrom(clazz)) continue;
                throw new ParseException("Collection type not java.util.Map: " + this);
            }
            if (clazz == null || Collection.class.isAssignableFrom(clazz)) continue;
            throw new ParseException("Collection type not java.util.Collection: " + this);
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        ExpressionNode collnode = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode argsnode = (ExpressionNode)this.jjtGetChild(1);
        Object collection = collnode.getValue(fetcher);
        for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
            ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
            if (node instanceof ArgumentsNode) {
                ExpressionNode key = (ExpressionNode)node.jjtGetChild(0);
                ExpressionNode val = (ExpressionNode)node.jjtGetChild(1);
                ((Map)collection).put(key.getValue(fetcher), val.getValue(fetcher));
                continue;
            }
            ((Collection)collection).add(node.getValue(fetcher));
        }
        return collection;
    }

    @Override
    public String toPlainString() {
        String ret = this.jjtGetChild(0).toPlainString() + "{";
        Node argsnode = this.jjtGetChild(1);
        for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
            ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
            ret = node instanceof ArgumentsNode ? ret + node.subnodeToString(0) + "=" + node.subnodeToString(1) : ret + node.toPlainString();
            if (i >= argsnode.jjtGetNumChildren() - 1) continue;
            ret = ret + ", ";
        }
        ret = ret + "}";
        return ret;
    }
}

