/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;

public class ConditionalNode
extends ExpressionNode {
    public ConditionalNode(ParserImpl p, int id) {
        super(p, id);
    }

    @Override
    public void precompile() {
        if (this.jjtGetNumChildren() != 3) {
            throw new ParseException("Wrong number of subterms for expression: " + this);
        }
        ExpressionNode choice = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode node1 = (ExpressionNode)this.jjtGetChild(1);
        ExpressionNode node2 = (ExpressionNode)this.jjtGetChild(2);
        Class<?> type = choice.getStaticType();
        if (type != null && !type.equals(Boolean.class)) {
            throw new ParseException("First term not boolean: " + this);
        }
        if (choice.isConstant()) {
            try {
                boolean val = (Boolean)choice.getValue(null);
                if (val) {
                    if (node1.isConstant()) {
                        this.setConstantValue(node1.getValue(null));
                        this.setConstant(true);
                    } else {
                        this.setStaticType(node1.getStaticType());
                    }
                } else if (node2.isConstant()) {
                    this.setConstantValue(node2.getValue(null));
                    this.setConstant(true);
                } else {
                    this.setStaticType(node2.getStaticType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        ExpressionNode choice = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode node1 = (ExpressionNode)this.jjtGetChild(1);
        ExpressionNode node2 = (ExpressionNode)this.jjtGetChild(2);
        Object cval = choice.getValue(fetcher);
        boolean val = cval == null ? false : (Boolean)cval;
        Object ret = val ? node1.getValue(fetcher) : node2.getValue(fetcher);
        return ret;
    }

    @Override
    public String toPlainString() {
        return this.subnodeToString(0) + " ? " + this.subnodeToString(1) + " : " + this.subnodeToString(2);
    }
}

