/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.javaccimpl.Node;
import jadex.javaparser.javaccimpl.ParameterNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;
import jadex.javaparser.javaccimpl.ParserImplTreeConstants;
import jadex.javaparser.javaccimpl.SimpleNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ExpressionNode
extends SimpleNode
implements IParsedExpression {
    protected String text;
    protected String expressiontext;
    protected String[] imports;
    protected Class static_type;
    protected boolean constant;
    protected Object constant_value;

    public ExpressionNode(ParserImpl p, int id) {
        super(p, id);
        this.imports = p.getImports();
    }

    public void setExpressionText(String expressiontext) {
        this.expressiontext = expressiontext;
    }

    @Override
    public String getExpressionText() {
        return this.expressiontext;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void appendText(String text) {
        this.text = this.text == null ? text : this.text + text;
    }

    public void setStaticType(Class static_type) {
        this.static_type = static_type;
    }

    public void setConstantValue(Object constant_value) {
        this.constant_value = constant_value;
    }

    public Object getConstantValue() {
        return this.constant_value;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public String toString(String prefix) {
        return prefix + ParserImplTreeConstants.jjtNodeName[this.id] + "(" + this.text + ")";
    }

    @Override
    public String toPlainString() {
        return super.toString();
    }

    @Override
    public String toString() {
        return "<" + this.toPlainString() + ">";
    }

    protected String subnodeToString(int subnode) {
        Node node = this.jjtGetChild(subnode);
        if (node.jjtGetNumChildren() == 0) {
            return node.toPlainString();
        }
        return "(" + node.toPlainString() + ")";
    }

    public String getText() {
        return this.text;
    }

    @Override
    public abstract Object getValue(IValueFetcher var1);

    @Override
    public Class<?> getStaticType() {
        return this.static_type;
    }

    @Override
    public Set<String> getParameters() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (ParameterNode n : this.getUnboundParameterNodes()) {
            ret.add(n.getText());
        }
        return ret;
    }

    public ParameterNode[] getUnboundParameterNodes() {
        ParameterNode[] ret = new ParameterNode[]{};
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ret = (ParameterNode[])SUtil.joinArrays((Object[])new Object[]{ret, ((ExpressionNode)this.jjtGetChild(i)).getUnboundParameterNodes()});
        }
        return ret;
    }

    public void precompile() {
    }

    public void precompileTree() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ((ExpressionNode)this.jjtGetChild(i)).precompileTree();
        }
        this.precompile();
    }

    protected void throwParseException(Throwable ex) throws ParseException {
        Node root = this;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        throw new ParseException("Exception while parsing expression: " + root.toPlainString() + "\n" + sw);
    }

    protected void throwEvaluationException(Throwable ex) throws RuntimeException {
        Node root = this;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        throw new RuntimeException("Exception while evaluating expression: " + root.toPlainString() + "\n" + sw);
    }

    public boolean equals(Object o) {
        boolean ret = o != null && o.getClass().equals(this.getClass()) && this.jjtGetNumChildren() == ((ExpressionNode)o).jjtGetNumChildren();
        for (int i = 0; ret && i < this.jjtGetNumChildren(); ++i) {
            ret = this.jjtGetChild(i).equals(((ExpressionNode)o).jjtGetChild(i));
        }
        return ret;
    }

    public int hashCode() {
        int ret = 31 + this.getClass().hashCode();
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ret = ret * 31 + this.jjtGetChild(i).hashCode();
        }
        return ret;
    }
}

