/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IPropertyObject;
import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.javaparser.IMapAccess;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ReflectNode
extends ExpressionNode {
    public static final int CONSTRUCTOR = 1;
    public static final int STATIC_METHOD = 2;
    public static final int STATIC_FIELD = 3;
    public static final int METHOD = 4;
    public static final int FIELD = 5;
    protected int type;
    protected Class clazz;
    protected transient Class[] argtypes;
    protected transient Object[] args;
    protected transient Constructor[] constructors;
    protected transient Class reloadedclass;
    protected transient Method[] methods;
    protected transient Method accessor;
    protected transient Field field;
    protected boolean reloadable;

    public ReflectNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void precompile() {
        block43: {
            ExpressionNode argsnode;
            if ((this.type == 1 || this.type == 2 || this.type == 4) && this.jjtGetNumChildren() != 2 || (this.type == 3 || this.type == 5) && this.jjtGetNumChildren() != 1) {
                throw new ParseException("Wrong number of child nodes: " + this);
            }
            if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3 && this.type != 5) {
                throw new ParseException("Unknown node type " + this.type + ": " + this);
            }
            int child = 0;
            ExpressionNode type_or_value = (ExpressionNode)this.jjtGetChild(child++);
            ExpressionNode expressionNode = argsnode = this.jjtGetNumChildren() == child ? null : (ExpressionNode)this.jjtGetChild(child);
            if (this.type == 4 || this.type == 5) {
                this.clazz = type_or_value.getStaticType() != null ? type_or_value.getStaticType() : null;
            } else if (type_or_value != null && type_or_value.isConstant()) {
                try {
                    this.clazz = (Class)type_or_value.getValue(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.clazz != null && (this.clazz.getModifiers() & 1) == 0) {
                throw new ParseException("Cannot access member of nonpublic class: " + this.clazz);
            }
            if (this.type == 1 || this.type == 2 || this.type == 4) {
                this.argtypes = new Class[argsnode.jjtGetNumChildren()];
                this.args = new Object[this.argtypes.length];
                for (int i = 0; i < this.argtypes.length; ++i) {
                    ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                    Class<?> clazz = this.argtypes[i] = node.getStaticType() != null ? node.getStaticType() : null;
                    if (!node.isConstant()) continue;
                    try {
                        this.args[i] = node.getValue(null);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.type == 1 && this.clazz != null) {
                    this.setStaticType(this.clazz);
                    this.constructors = this.findConstructors(this.clazz, this.argtypes);
                    if (this.constructors.length == 0) {
                        throw new ParseException("No constructor found for: " + this.clazz + SUtil.arrayToString((Object)this.argtypes));
                    }
                } else if ((this.type == 2 || this.type == 4) && this.clazz != null) {
                    this.methods = this.findMethods(this.clazz, this.argtypes);
                    if (this.methods.length == 0) {
                        throw new ParseException("No " + this.getText() + " method found for: " + this.clazz + SUtil.arrayToString((Object)this.argtypes));
                    }
                    Class<?> retype = null;
                    for (int i = 0; i < this.methods.length; ++i) {
                        if (i == 0) {
                            retype = this.methods[i].getReturnType();
                            continue;
                        }
                        if (retype == this.methods[i].getReturnType()) continue;
                        retype = null;
                    }
                    if (retype != null) {
                        this.setStaticType(SReflect.getWrappedType(retype));
                    }
                }
            } else if ((this.type == 3 || this.type == 5) && this.clazz != null) {
                if (this.type == 3 && this.getText().equals("class")) {
                    this.setStaticType(Class.class);
                    this.setConstantValue(this.clazz);
                    this.setConstant(true);
                } else if (this.type == 5 && this.clazz.isArray() && this.getText().equals("length")) {
                    this.setStaticType(Integer.class);
                    if (type_or_value.isConstant()) {
                        try {
                            Object array = type_or_value.getValue(null);
                            this.setConstantValue(Array.getLength(array));
                            this.setConstant(true);
                        }
                        catch (Exception array) {}
                    }
                } else {
                    try {
                        this.field = SReflect.getCachedField((Class)this.clazz, (String)this.getText());
                        this.setStaticType(SReflect.getWrappedType(this.field.getType()));
                        if (this.type == 3 && !Modifier.isStatic(this.field.getModifiers())) {
                            throw new ParseException("Static reference to nonstatic field :" + this);
                        }
                        if (!Modifier.isFinal(this.field.getModifiers())) break block43;
                        try {
                            if (Modifier.isStatic(this.field.getModifiers())) {
                                this.setConstantValue(this.field.get(null));
                                this.setConstant(true);
                                break block43;
                            }
                            if (!type_or_value.isConstant()) break block43;
                            try {
                                Object value = type_or_value.getValue(null);
                                if (value == null) {
                                    throw new ParseException("Cannot reference nonstatic field of null value: " + this);
                                }
                                this.setConstantValue(this.field.get(value));
                                this.setConstant(true);
                            }
                            catch (ParseException e) {
                                throw e;
                            }
                            catch (Exception e) {
                            }
                        }
                        catch (IllegalAccessException e) {
                            throw new ParseException("Nonpublic field cannot be accessed: " + this);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        boolean found = false;
                        if (this.accessor == null && SReflect.isSupertype(Map.class, (Class)this.clazz)) {
                            try {
                                this.accessor = this.clazz.getMethod("get", Object.class);
                                this.args = new Object[]{this.getText()};
                                found = true;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                        if (found) break block43;
                        this.throwParseException(e);
                    }
                }
            }
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        int child = 0;
        ExpressionNode type_or_value = (ExpressionNode)this.jjtGetChild(child++);
        ExpressionNode argsnode = this.jjtGetNumChildren() == child ? null : (ExpressionNode)this.jjtGetChild(child);
        Object value = null;
        if (this.type == 1 || this.type == 2 || this.type == 4) {
            Object[] args = new Object[argsnode.jjtGetNumChildren()];
            if (this.args != null) {
                System.arraycopy(this.args, 0, args, 0, args.length);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = ((ExpressionNode)argsnode.jjtGetChild(i)).getValue(fetcher);
            }
            Class[] argtypes = new Class[argsnode.jjtGetNumChildren()];
            if (this.argtypes != null) {
                System.arraycopy(this.argtypes, 0, argtypes, 0, argtypes.length);
            }
            for (int i = 0; i < argtypes.length; ++i) {
                if (argtypes[i] != null || args[i] == null) continue;
                argtypes[i] = args[i].getClass();
            }
            if (this.type == 1) {
                try {
                    value = this.invokeConstructor((Class)type_or_value.getValue(fetcher), argtypes, args);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            } else if (this.type == 4 || this.type == 2) {
                Object ref = null;
                if (this.type == 2 && this.clazz == null) {
                    this.clazz = (Class)type_or_value.getValue(fetcher);
                } else {
                    ref = type_or_value.getValue(fetcher);
                    if (ref == null) {
                        throw new NullPointerException("Cannot invoke nonstatic method on null value: " + this);
                    }
                    if (this.clazz == null) {
                        this.clazz = ref.getClass();
                    }
                }
                try {
                    value = this.invokeMethod(ref, this.clazz, argtypes, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw SUtil.throwUnchecked((Throwable)e);
                }
            }
        } else if (this.type == 5 || this.type == 3) {
            Object ref;
            Object object = ref = this.type == 3 ? null : type_or_value.getValue(fetcher);
            if (this.type == 3 && this.getText().equals("class")) {
                value = type_or_value.getValue(fetcher);
            } else if (this.type == 5 && ref != null && ref.getClass().isArray() && this.getText().equals("length")) {
                value = Array.getLength(ref);
            } else if (this.type == 5 && ref instanceof IPropertyObject && ((IPropertyObject)ref).hasProperty(this.getText())) {
                value = ((IPropertyObject)ref).getProperty(this.getText());
            } else {
                if (this.type != 3 && ref == null) {
                    throw new NullPointerException("Cannot reference nonstatic field of null value: " + this + ", " + type_or_value.getValue(fetcher));
                }
                if (this.clazz == null) {
                    this.clazz = this.type == 3 ? (Class)type_or_value.getValue(fetcher) : ref.getClass();
                }
                try {
                    value = this.accessField(ref, this.clazz, fetcher);
                }
                catch (Exception e) {
                    throw new RuntimeException("" + this, e);
                }
            }
        }
        return value;
    }

    @Override
    public String toPlainString() {
        if (this.type == 1) {
            return "new " + this.jjtGetChild(0).toPlainString() + this.jjtGetChild(1).toPlainString();
        }
        if (this.type == 4 || this.type == 2) {
            return this.jjtGetChild(0).toPlainString() + "." + this.getText() + this.jjtGetChild(1).toPlainString();
        }
        return this.jjtGetChild(0).toPlainString() + "." + this.getText();
    }

    protected Constructor[] findConstructors(Class clazz, Class[] argtypes) {
        Constructor<?>[] cs = clazz.getConstructors();
        Class[][] paramtypes = new Class[cs.length][];
        for (int i = 0; i < cs.length; ++i) {
            paramtypes[i] = cs[i].getParameterTypes();
        }
        int[] matches = SReflect.matchArgumentTypes((Class[])argtypes, (Class[][])paramtypes);
        Constructor[] constructors = new Constructor[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            constructors[i] = cs[matches[i]];
        }
        return constructors;
    }

    protected Method[] findMethods(Class clazz, Class[] argtypes) {
        Method[] ms = SReflect.getMethods((Class)clazz, (String)this.getText());
        ArrayList<Method> ames = new ArrayList<Method>();
        for (int i = 0; i < ms.length; ++i) {
            if (this.type == 2 && !Modifier.isStatic(ms[i].getModifiers())) continue;
            ames.add(ms[i]);
        }
        ms = ames.toArray(new Method[ames.size()]);
        Class[][] paramtypes = new Class[ms.length][];
        for (int i = 0; i < ms.length; ++i) {
            paramtypes[i] = ms[i].getParameterTypes();
        }
        int[] matches = SReflect.matchArgumentTypes((Class[])argtypes, (Class[][])paramtypes);
        Method[] methods = new Method[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            methods[i] = ms[matches[i]];
        }
        return methods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object invokeConstructor(Class clazz, Class[] argtypes, Object[] args) throws Exception {
        Constructor con = null;
        if (this.constructors == null) {
            Constructor[] constructors = this.findConstructors(clazz, argtypes);
            if (constructors.length <= 0) throw new ParseException("No constructor found for: " + clazz + SUtil.arrayToString((Object)argtypes));
            con = constructors[0];
        } else {
            Class[][] paramtypes = new Class[this.constructors.length][];
            for (int i = 0; i < this.constructors.length; ++i) {
                paramtypes[i] = this.constructors[i].getParameterTypes();
            }
            int[] matches = SReflect.matchArgumentTypes((Class[])argtypes, (Class[][])paramtypes);
            if (matches.length <= 0) throw new RuntimeException("No constructor found for " + clazz + SUtil.arrayToString((Object)argtypes));
            con = this.constructors[matches[0]];
        }
        Object ret = null;
        try {
            return con.newInstance(SReflect.fillArguments((Object[])args, (Class[])con.getParameterTypes()));
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof Exception)) throw e;
            throw (Exception)e.getTargetException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object invokeMethod(Object ref, Class clazz, Class[] argtypes, Object[] args) throws Exception {
        Method method = null;
        if (this.methods == null) {
            Method[] methods = this.findMethods(clazz, argtypes);
            if (methods.length <= 0) throw new ParseException("No method found for term " + this + ": " + clazz + " " + this.getText() + SUtil.arrayToString((Object)argtypes));
            method = methods[0];
        } else {
            Class[][] paramtypes = new Class[this.methods.length][];
            for (int i = 0; i < this.methods.length; ++i) {
                paramtypes[i] = this.methods[i].getParameterTypes();
            }
            int[] matches = SReflect.matchArgumentTypes((Class[])argtypes, (Class[][])paramtypes);
            if (matches.length <= 0) throw new ParseException("No method found for: " + clazz + " " + this.getText() + SUtil.arrayToString((Object)argtypes));
            method = this.methods[matches[0]];
        }
        Method invmeth = this.getMethodForMethod(method);
        if (invmeth == null) {
            throw new ParseException("Method '" + method.getName() + "' declared on nonpublic class.");
        }
        Object ret = null;
        try {
            return invmeth.invoke(ref, SReflect.fillArguments((Object[])args, (Class[])invmeth.getParameterTypes()));
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof Exception)) throw e;
            throw (Exception)e.getTargetException();
        }
    }

    protected Object accessField(Object ref, Class clazz, IValueFetcher fetcher) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        boolean fetched = false;
        Object val = null;
        Field field0 = this.field;
        NoSuchFieldException nsfe = null;
        if (!fetched && field0 == null) {
            try {
                field0 = SReflect.getCachedField((Class)clazz, (String)this.getText());
                if (this.type == 3 && !Modifier.isStatic(field0.getModifiers())) {
                    throw new RuntimeException("Static reference to nonstatic field :" + this);
                }
            }
            catch (NoSuchFieldException e) {
                nsfe = e;
            }
        }
        Method accessor0 = this.accessor;
        Object[] args0 = this.args;
        if (!fetched && field0 == null && accessor0 == null && (SReflect.isSupertype(Map.class, (Class)clazz) || SReflect.isSupertype(IMapAccess.class, (Class)clazz))) {
            accessor0 = SReflect.getMethod((Class)clazz, (String)"get", (Class[])new Class[]{Object.class});
            if (accessor0 == null) {
                throw nsfe;
            }
            args0 = new Object[]{this.getText()};
        }
        if (!fetched) {
            try {
                val = accessor0 == null ? field0.get(ref) : accessor0.invoke(ref, args0);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e);
            }
        }
        return val;
    }

    protected Method getMethodForMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) == 0) {
            ArrayList classes = new ArrayList();
            if (clazz.getSuperclass() != null) {
                classes.add(clazz.getSuperclass());
            }
            classes.addAll(Arrays.asList(clazz.getInterfaces()));
            Method meth = null;
            while (meth == null && classes.size() > 0) {
                Class testclass = (Class)classes.remove(0);
                try {
                    if ((testclass.getModifiers() & 1) != 0) {
                        meth = testclass.getMethod(method.getName(), method.getParameterTypes());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (meth != null) continue;
                if (testclass.getSuperclass() != null) {
                    classes.add(testclass.getSuperclass());
                }
                classes.addAll(Arrays.asList(testclass.getInterfaces()));
            }
            method = meth;
        }
        return method;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.type == ((ReflectNode)o).type && SUtil.equals((Object)this.getText(), (Object)((ReflectNode)o).getText());
    }

    @Override
    public int hashCode() {
        int ret = super.hashCode();
        ret = ret * 31 + this.type;
        ret = ret * 31 + (this.getText() != null ? this.getText().hashCode() : 1);
        return ret;
    }
}

