/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.bean;

import jadex.commons.Base64;
import jadex.commons.SReflect;
import jadex.commons.Tuple;
import jadex.commons.Tuple2;
import jadex.commons.Tuple3;
import jadex.commons.collection.MultiCollection;
import jadex.commons.transformation.IStringObjectConverter;
import jadex.commons.transformation.binaryserializer.IErrorReporter;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeConverter;
import jadex.xml.AttributeInfo;
import jadex.xml.IContext;
import jadex.xml.IObjectObjectConverter;
import jadex.xml.IPostProcessor;
import jadex.xml.MappingInfo;
import jadex.xml.ObjectInfo;
import jadex.xml.SubObjectConverter;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.XMLInfo;
import jadex.xml.bean.BeanAccessInfo;
import jadex.xml.bean.BeanObjectReaderHandler;
import jadex.xml.bean.IBeanObjectCreator;
import jadex.xml.bean.MapEntry;
import jadex.xml.bean.STypeInfosAWT;
import jadex.xml.reader.AReader;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.XMLReaderFactory;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import jadex.xml.stax.XMLReporter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JavaReader {
    protected static volatile AReader reader;
    protected static volatile TypeInfoPathManager pathmanager;
    protected static volatile IObjectReaderHandler handler;

    public static Set<TypeInfo> joinTypeInfos(Set<TypeInfo> typeinfos) {
        Set<TypeInfo> ret = JavaReader.getTypeInfos();
        if (typeinfos != null) {
            ret.addAll(typeinfos);
        }
        return ret;
    }

    public static Set<TypeInfo> getTypeInfos() {
        HashSet<TypeInfo> typeinfos = new HashSet<TypeInfo>();
        try {
            IObjectObjectConverter entryconv = new IObjectObjectConverter(){

                @Override
                public Object convertObject(Object val, IContext context) {
                    return ((MapEntry)val).getValue();
                }
            };
            TypeInfo ti_lru = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "LRU")}), new ObjectInfo(Map.class), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("maxEntries", null))}, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("cleaner")), new SubobjectInfo(new XMLInfo("entry"), new AccessInfo("entry", null, null, null, (Object)new BeanAccessInfo(Map.class.getMethod("put", Object.class, Object.class), null, "", MapEntry.class.getMethod("getKey", new Class[0]))), new SubObjectConverter(entryconv, null), true, null)}));
            typeinfos.add(ti_lru);
            TypeInfo ti_map = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Map")}), new ObjectInfo(Map.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new XMLInfo("entry"), new AccessInfo("entry", null, null, null, (Object)new BeanAccessInfo(Map.class.getMethod("put", Object.class, Object.class), null, "", MapEntry.class.getMethod("getKey", new Class[0]))), new SubObjectConverter(entryconv, null), true, null)}));
            typeinfos.add(ti_map);
            TypeInfo ti_mapentry = new TypeInfo(new XMLInfo("entry"), new ObjectInfo(MapEntry.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("key")), new SubobjectInfo(new AccessInfo("value"))}));
            typeinfos.add(ti_mapentry);
            TypeInfo ti_mc = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:jadex.commons.collection", "MultiCollection")}), new ObjectInfo(MultiCollection.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new XMLInfo("entry"), new AccessInfo("entry", null, null, null, (Object)new BeanAccessInfo(MultiCollection.class.getMethod("put", Object.class, Collection.class), null, "", MapEntry.class.getMethod("getKey", new Class[0]))), new SubObjectConverter(entryconv, null), true, null)}));
            typeinfos.add(ti_mc);
            TypeInfo ti_list = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "List")}), new ObjectInfo(List.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("entries", null, null, null, (Object)new BeanAccessInfo(List.class.getMethod("add", Object.class), null)))}));
            typeinfos.add(ti_list);
            TypeInfo ti_set = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Set")}), new ObjectInfo(Set.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("entries", null, null, null, (Object)new BeanAccessInfo(Set.class.getMethod("add", Object.class), null)))}));
            typeinfos.add(ti_set);
            TypeInfo ti_emptyset = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-EmptySet")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Collections.EMPTY_SET;
                }
            }));
            typeinfos.add(ti_emptyset);
            TypeInfo ti_emptylist = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-EmptyList")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Collections.EMPTY_LIST;
                }
            }));
            typeinfos.add(ti_emptylist);
            TypeInfo ti_emptymap = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-EmptyMap")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Collections.EMPTY_MAP;
                }
            }));
            typeinfos.add(ti_emptymap);
            TypeInfo ti_unset = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-UnmodifiableSet")}), new ObjectInfo(HashSet.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("entries", null, null, null, (Object)new BeanAccessInfo(Set.class.getMethod("add", Object.class), null)))}));
            typeinfos.add(ti_unset);
            TypeInfo ti_unlist = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-UnmodifiableList")}), new ObjectInfo(ArrayList.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("entries", null, null, null, (Object)new BeanAccessInfo(List.class.getMethod("add", Object.class), null)))}));
            typeinfos.add(ti_unlist);
            TypeInfo ti_unmap = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Collections-UnmodifiableMap")}), new ObjectInfo(HashMap.class), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new XMLInfo("entry"), new AccessInfo("entry", null, null, null, (Object)new BeanAccessInfo(Map.class.getMethod("put", Object.class, Object.class), null, "", MapEntry.class.getMethod("getKey", new Class[0]))), new SubObjectConverter(entryconv, null), true, null)}));
            typeinfos.add(ti_unmap);
            TypeInfo ti_class = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Class")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return SReflect.classForName((String)rawattributes.get("classname"), (ClassLoader)context.getClassLoader());
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("classname", null, "ignore_readwrite"))}));
            typeinfos.add(ti_class);
            TypeInfo ti_timestamp = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.sql", "Timestamp")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    long time = Long.parseLong(rawattributes.get("time"));
                    return new Timestamp(time);
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("time", null))}));
            typeinfos.add(ti_timestamp);
            TypeInfo ti_date = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Date")}), new ObjectInfo(Date.class), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("time", null))}));
            typeinfos.add(ti_date);
            TypeInfo ti_calendar = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "Calendar")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    Class cl = SReflect.classForName((String)rawattributes.get("classname"), (ClassLoader)context.getClassLoader());
                    Calendar cal = (Calendar)cl.newInstance();
                    cal.setTime(new Date(Long.parseLong(rawattributes.get("time"))));
                    return cal;
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("time", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("classname", null, "ignore_readwrite"))}));
            typeinfos.add(ti_calendar);
            TypeInfo ti_string = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "String")}), new ObjectInfo(null, new IPostProcessor(){

                @Override
                public Object postProcess(IContext context, Object object) {
                    return object != null ? object : "";
                }

                @Override
                public int getPass() {
                    return 0;
                }
            }));
            typeinfos.add(ti_string);
            TypeInfo ti_boolean = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Boolean")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Boolean.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_boolean);
            TypeInfo ti_integer = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Integer")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Integer.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_integer);
            TypeInfo ti_double = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Double")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Double.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_double);
            TypeInfo ti_float = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Float")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Float.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_float);
            TypeInfo ti_long = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Long")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Long.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_long);
            TypeInfo ti_short = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Short")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Short.valueOf(rawattributes.get("content"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_short);
            TypeInfo ti_byte = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Byte")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    byte[] bytes = Base64.decode((byte[])rawattributes.get("content").getBytes("UTF-8"));
                    return bytes[0];
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_byte);
            TypeInfo ti_character = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Character")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return Character.valueOf(rawattributes.get("content").charAt(0));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_character);
            TypeInfo ti_url = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.net", "URL")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return new URL(rawattributes.get("protocol"), rawattributes.get("host"), Integer.parseInt(rawattributes.get("port")), rawattributes.get("file"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("protocol", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("host", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("port", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("file", null, "ignore_readwrite"))}));
            typeinfos.add(ti_url);
            TypeInfo ti_uri = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.net", "URI")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return new URI(rawattributes.get("uri"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("uri", null, "ignore_readwrite"))}));
            typeinfos.add(ti_uri);
            TypeInfo ti_level = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util.logging", "Level")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    String name = rawattributes.get("name");
                    Level ret = Level.parse(name);
                    return ret;
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("name", null, "ignore_readwrite"))}));
            typeinfos.add(ti_level);
            TypeInfo ti_record = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util.logging", "LogRecord")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    String name = rawattributes.get("level");
                    String msg = rawattributes.get("message");
                    Level level = Level.parse(name);
                    LogRecord ret = new LogRecord(level, msg);
                    return ret;
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("level", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("message", null, "ignore_readwrite"))}));
            typeinfos.add(ti_record);
            TypeInfo ti_inetaddr = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.net", "InetAddress")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    return InetAddress.getByName(rawattributes.get("hostAddress"));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("hostAddress", null, "ignore_readwrite"))}));
            typeinfos.add(ti_inetaddr);
            TypeInfo ti_enum = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Enum")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    String tmp = rawattributes.get("content");
                    int idx = tmp.indexOf("=");
                    String classname = tmp.substring(0, idx);
                    String name = tmp.substring(idx + 1);
                    Class clazz = SReflect.classForName((String)classname, (ClassLoader)context.getClassLoader());
                    return Enum.valueOf(clazz, name);
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("content", null, "ignore_readwrite"))}));
            typeinfos.add(ti_enum);
            TypeInfo ti_cert = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.security.cert", "Certificate")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    String type = rawattributes.get("type");
                    if (type == null) {
                        type = "X.509";
                    }
                    CertificateFactory cf = CertificateFactory.getInstance(type);
                    return cf.generateCertificate(new ByteArrayInputStream(Base64.decode((byte[])rawattributes.get("data").getBytes())));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("data", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("type", null, "ignore_readwrite"))}));
            typeinfos.add(ti_cert);
            IStringObjectConverter booleanconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    boolean[] ret = new boolean[val.length()];
                    for (int i = 0; i < val.length(); ++i) {
                        ret[i] = val.charAt(i) == '1';
                    }
                    return ret;
                }
            };
            TypeInfo ti_booleanarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "boolean__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(booleanconv, null))));
            typeinfos.add(ti_booleanarray);
            IStringObjectConverter bbooleanconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    Boolean[] ret = new Boolean[val.length()];
                    for (int i = 0; i < val.length(); ++i) {
                        ret[i] = val.charAt(i) == '1' ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return ret;
                }
            };
            TypeInfo ti_bbooleanarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Boolean__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(bbooleanconv, null))));
            typeinfos.add(ti_bbooleanarray);
            IStringObjectConverter intconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    int[] ret = new int[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Integer.parseInt(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_intarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "int__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(intconv, null))));
            typeinfos.add(ti_intarray);
            IStringObjectConverter integerconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    Integer[] ret = new Integer[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Integer.valueOf(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_integerarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Integer__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(integerconv, null))));
            typeinfos.add(ti_integerarray);
            IStringObjectConverter doubleconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, "_");
                    int len = Integer.parseInt(stok.nextToken());
                    double[] ret = new double[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Double.parseDouble(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_doublearray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "double__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(doubleconv, null))));
            typeinfos.add(ti_doublearray);
            IStringObjectConverter bdoubleconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, "_");
                    int len = Integer.parseInt(stok.nextToken());
                    Double[] ret = new Double[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Double.valueOf(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_bdoublerarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Double__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(bdoubleconv, null))));
            typeinfos.add(ti_bdoublerarray);
            IStringObjectConverter floatconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, "_");
                    int len = Integer.parseInt(stok.nextToken());
                    float[] ret = new float[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Float.parseFloat(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_floatarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "float__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(floatconv, null))));
            typeinfos.add(ti_floatarray);
            IStringObjectConverter bfloatconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, "_");
                    int len = Integer.parseInt(stok.nextToken());
                    Float[] ret = new Float[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Float.valueOf(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_bfloatarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Float__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(bfloatconv, null))));
            typeinfos.add(ti_bfloatarray);
            IStringObjectConverter longconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    long[] ret = new long[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Long.parseLong(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_longarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "long__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(longconv, null))));
            typeinfos.add(ti_longarray);
            IStringObjectConverter blongconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    Long[] ret = new Long[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Long.valueOf(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_blongarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Long__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(blongconv, null))));
            typeinfos.add(ti_blongarray);
            IStringObjectConverter shortconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    short[] ret = new short[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Short.parseShort(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_shortarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "short__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(shortconv, null))));
            typeinfos.add(ti_shortarray);
            IStringObjectConverter bshortconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    StringTokenizer stok = new StringTokenizer(val, ",");
                    int len = Integer.parseInt(stok.nextToken());
                    Short[] ret = new Short[len];
                    int i = 0;
                    while (stok.hasMoreTokens()) {
                        ret[i] = Short.valueOf(stok.nextToken());
                        ++i;
                    }
                    return ret;
                }
            };
            TypeInfo ti_bshortarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Short__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(bshortconv, null))));
            typeinfos.add(ti_bshortarray);
            IStringObjectConverter byteconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    return Base64.decode((byte[])val.getBytes());
                }
            };
            TypeInfo ti_bytearray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "byte__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(byteconv, null))));
            typeinfos.add(ti_bytearray);
            IStringObjectConverter bbyteconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    byte[] bytes = val.getBytes();
                    Byte[] bbytes = new Byte[bytes.length];
                    for (int i = 0; i < bytes.length; ++i) {
                        bbytes[i] = bytes[i];
                    }
                    return bbytes;
                }
            };
            TypeInfo ti_bbytearray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Byte__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(bbyteconv, null))));
            typeinfos.add(ti_bbytearray);
            IStringObjectConverter charconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    return val.toCharArray();
                }
            };
            TypeInfo ti_chararray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:", "char__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(charconv, null))));
            typeinfos.add(ti_chararray);
            IStringObjectConverter characterconv = new IStringObjectConverter(){

                public Object convertString(String val, Object context) {
                    char[] chars = val.toCharArray();
                    Character[] bchars = new Character[chars.length];
                    for (int i = 0; i < chars.length; ++i) {
                        bchars[i] = Character.valueOf(chars[i]);
                    }
                    return bchars;
                }
            };
            TypeInfo ti_characterarray = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Character__1")}), null, new MappingInfo(null, null, new AttributeInfo(new AccessInfo((String)null, (Object)"__this"), new AttributeConverter(characterconv, null))));
            typeinfos.add(ti_characterarray);
            TypeInfo ti_tuple = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:jadex.commons", "Tuple")}), new ObjectInfo(HashMap.class, new IPostProcessor(){

                @Override
                public Object postProcess(IContext context, Object object) {
                    Map map = (Map)object;
                    return new Tuple((Object[])map.get("entities"));
                }

                @Override
                public int getPass() {
                    return 0;
                }
            }), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("entities", (Object)"entities", null, null, (Object)new BeanAccessInfo("__this")))}));
            typeinfos.add(ti_tuple);
            TypeInfo ti_tuple2 = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:jadex.commons", "Tuple2")}), new ObjectInfo(HashMap.class, new IPostProcessor(){

                @Override
                public Object postProcess(IContext context, Object object) {
                    Map map = (Map)object;
                    return new Tuple2(map.get("firstEntity"), map.get("secondEntity"));
                }

                @Override
                public int getPass() {
                    return 0;
                }
            }), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("firstEntity", (Object)"firstEntity", null, null, (Object)new BeanAccessInfo("__this"))), new SubobjectInfo(new AccessInfo("secondEntity", (Object)"secondEntity", null, null, (Object)new BeanAccessInfo("__this")))}));
            typeinfos.add(ti_tuple2);
            TypeInfo ti_tuple3 = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:jadex.commons", "Tuple3")}), new ObjectInfo(HashMap.class, new IPostProcessor(){

                @Override
                public Object postProcess(IContext context, Object object) {
                    Map map = (Map)object;
                    return new Tuple3(map.get("firstEntity"), map.get("secondEntity"), map.get("thirdEntity"));
                }

                @Override
                public int getPass() {
                    return 0;
                }
            }), new MappingInfo(null, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("firstEntity", (Object)"firstEntity", null, null, (Object)new BeanAccessInfo("__this"))), new SubobjectInfo(new AccessInfo("secondEntity", (Object)"secondEntity", null, null, (Object)new BeanAccessInfo("__this"))), new SubobjectInfo(new AccessInfo("thirdEntity", (Object)"thirdEntity", null, null, (Object)new BeanAccessInfo("__this")))}));
            typeinfos.add(ti_tuple3);
            TypeInfo ti_uuid = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.util", "UUID")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    long msb = Long.parseLong(rawattributes.get("mostSignificantBits"));
                    long lsb = Long.parseLong(rawattributes.get("leastSignificantBits"));
                    return new UUID(msb, lsb);
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("mostSignificantBits", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("leastSignificantBits", null, "ignore_readwrite"))}));
            typeinfos.add(ti_uuid);
            TypeInfo ti_th = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "Throwable")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    Object ret = null;
                    String clname = rawattributes.get("class");
                    String msg = rawattributes.get("message");
                    Class cl = SReflect.findClass((String)clname, null, (ClassLoader)context.getClassLoader());
                    try {
                        Constructor con = cl.getConstructor(String.class);
                        ret = con.newInstance(msg);
                    }
                    catch (Exception e) {
                        Constructor con = cl.getConstructor(new Class[0]);
                        ret = con.newInstance(new Object[0]);
                    }
                    return ret;
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("class", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("message", null, "ignore_readwrite"))}, new SubobjectInfo[]{new SubobjectInfo(new AccessInfo("cause", null, null, null, (Object)new BeanAccessInfo(Exception.class.getMethod("initCause", Throwable.class), null)))}));
            typeinfos.add(ti_th);
            TypeInfo ti_ste = new TypeInfo(new XMLInfo(new QName[]{new QName("typeinfo:java.lang", "StackTraceElement")}), new ObjectInfo(new IBeanObjectCreator(){

                @Override
                public Object createObject(IContext context, Map<String, String> rawattributes) throws Exception {
                    String decl = rawattributes.get("className");
                    String mname = rawattributes.get("methodName");
                    String fname = rawattributes.get("fileName");
                    String num = rawattributes.get("lineNumber");
                    return new StackTraceElement(decl, mname, fname, Integer.parseInt(num));
                }
            }), new MappingInfo(null, new AttributeInfo[]{new AttributeInfo(new AccessInfo("className", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("methodName", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("fileName", null, "ignore_readwrite")), new AttributeInfo(new AccessInfo("lineNumber", null, "ignore_readwrite"))}));
            typeinfos.add(ti_ste);
            if (!SReflect.isAndroid()) {
                typeinfos.addAll(STypeInfosAWT.getReaderTypeInfos());
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return typeinfos;
    }

    public static <T> T objectFromXML(String val, ClassLoader classloader) {
        return JavaReader.objectFromXML(val, classloader, null, null);
    }

    public static Object objectFromByteArray(byte[] val, ClassLoader classloader, IErrorReporter rep) {
        return JavaReader.objectFromByteArray(val, classloader, null, null, rep);
    }

    public static Object objectFromInputStream(InputStream val, ClassLoader classloader, IErrorReporter rep) {
        return JavaReader.objectFromInputStream(val, classloader, null, null, rep);
    }

    public static <T> T objectFromXML(String val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        return (T)AReader.objectFromXML(JavaReader.getInstance(), val, classloader, manager == null ? JavaReader.getPathManager() : manager, handler == null ? JavaReader.getObjectHandler() : handler);
    }

    public static Object objectFromByteArray(byte[] val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler, final IErrorReporter rep) {
        return rep != null ? AReader.objectFromByteArray(JavaReader.getReader(new XMLReporter(){

            @Override
            public void report(String message, String errorType, Object relatedInformation, ILocation location) throws Exception {
                rep.exceptionOccurred((Exception)new RuntimeException(message));
            }
        }), val, classloader, manager == null ? JavaReader.getPathManager() : manager, handler == null ? JavaReader.getObjectHandler() : handler) : AReader.objectFromByteArray(JavaReader.getInstance(), val, classloader, manager == null ? JavaReader.getPathManager() : manager, handler == null ? JavaReader.getObjectHandler() : handler);
    }

    public static Object objectFromInputStream(InputStream val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler, final IErrorReporter rep) {
        return rep != null ? AReader.objectFromInputStream(JavaReader.getReader(new XMLReporter(){

            @Override
            public void report(String message, String errorType, Object relatedInformation, ILocation location) throws Exception {
                rep.exceptionOccurred((Exception)new RuntimeException(message));
            }
        }), val, classloader, manager == null ? JavaReader.getPathManager() : manager, handler == null ? JavaReader.getObjectHandler() : handler) : AReader.objectFromInputStream(JavaReader.getInstance(), val, classloader, manager == null ? JavaReader.getPathManager() : manager, handler == null ? JavaReader.getObjectHandler() : handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AReader getInstance() {
        if (reader != null) return reader;
        Class<JavaReader> clazz = JavaReader.class;
        synchronized (JavaReader.class) {
            if (reader != null) return reader;
            reader = XMLReaderFactory.getInstance().createReader(false, false, false, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return reader;
        }
    }

    private static AReader getReader(XMLReporter reporter) {
        return XMLReaderFactory.getInstance().createReader(false, false, false, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeInfoPathManager getPathManager() {
        if (pathmanager != null) return pathmanager;
        Class<JavaReader> clazz = JavaReader.class;
        synchronized (JavaReader.class) {
            if (pathmanager != null) return pathmanager;
            pathmanager = new TypeInfoPathManager(JavaReader.getTypeInfos());
            // ** MonitorExit[var0] (shouldn't be in output)
            return pathmanager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IObjectReaderHandler getObjectHandler() {
        if (handler != null) return handler;
        Class<JavaReader> clazz = JavaReader.class;
        synchronized (JavaReader.class) {
            if (handler != null) return handler;
            handler = new BeanObjectReaderHandler(JavaReader.getTypeInfos());
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }
}

