/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.xml.reader.AReader;
import jadex.xml.reader.IXMLReader;
import jadex.xml.stax.StaxReaderWrapper;
import jadex.xml.stax.StaxXMLReporterWrapper;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Reader
extends AReader {
    protected XMLInputFactory factory = XMLInputFactory.newInstance();

    public Reader() {
        this(false);
    }

    public Reader(boolean bulklink) {
        this(bulklink, false, null);
    }

    public Reader(boolean bulklink, boolean validate, XMLReporter reporter) {
        this(bulklink, validate, false, reporter);
    }

    public Reader(boolean bulklink, boolean validate, boolean coalescing, XMLReporter reporter) {
        super(bulklink, StaxXMLReporterWrapper.fromXMLReporter(reporter));
        try {
            this.factory.setProperty("javax.xml.stream.isValidating", validate ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            System.err.println("Error setting validation to " + validate);
        }
        try {
            this.factory.setProperty("javax.xml.stream.isCoalescing", coalescing ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            System.err.println("Error setting coalescing to " + coalescing);
        }
        if (reporter != null) {
            this.factory.setProperty("javax.xml.stream.reporter", reporter);
        } else {
            this.factory.setProperty("javax.xml.stream.reporter", new XMLReporter(){

                @Override
                public void report(String message, String error, Object related, Location location) throws XMLStreamException {
                    throw new XMLStreamException(message, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IXMLReader createXMLReader(InputStream input) {
        XMLStreamReader parser = null;
        XMLInputFactory xMLInputFactory = this.factory;
        synchronized (xMLInputFactory) {
            try {
                parser = this.factory.createXMLStreamReader(input);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return new StaxReaderWrapper(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IXMLReader createXMLReader(java.io.Reader input) {
        XMLStreamReader parser = null;
        XMLInputFactory xMLInputFactory = this.factory;
        synchronized (xMLInputFactory) {
            try {
                parser = this.factory.createXMLStreamReader(input);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return new StaxReaderWrapper(parser);
    }
}

