/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.xml.XMLInfo;
import jadex.xml.stax.QName;
import java.util.Comparator;

public class AbstractInfo {
    protected XMLInfo xmlinfo;
    protected QName[] xmlpathelementswithouttag;
    protected int id;
    protected static int idcnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractInfo(XMLInfo xmlinfo) {
        this.xmlinfo = xmlinfo;
        Class<AbstractInfo> clazz = AbstractInfo.class;
        synchronized (AbstractInfo.class) {
            this.id = idcnt++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public XMLInfo getXMLInfo() {
        return this.xmlinfo;
    }

    public String getXMLPath() {
        return this.xmlinfo != null ? this.xmlinfo.getXMLPath() : null;
    }

    public QName getXMLTag() {
        return this.xmlinfo != null && this.xmlinfo.getXMLPathElements() != null ? this.xmlinfo.getXMLPathElements()[this.xmlinfo.getXMLPathElements().length - 1] : null;
    }

    public QName[] getXMLPathElements() {
        return this.xmlinfo != null && this.xmlinfo.getXMLPathElements() != null ? this.xmlinfo.getXMLPathElements() : null;
    }

    public QName[] getXMLPathElementsWithoutElement() {
        if (this.xmlpathelementswithouttag == null && this.xmlinfo != null) {
            this.xmlpathelementswithouttag = new QName[this.xmlinfo.getXMLPathElements().length - 1];
            System.arraycopy(this.xmlinfo.getXMLPathElements(), 0, this.xmlpathelementswithouttag, 0, this.xmlinfo.getXMLPathElements().length - 1);
        }
        return this.xmlpathelementswithouttag;
    }

    public int getXMLPathDepth() {
        return this.xmlinfo != null && this.xmlinfo.getXMLPathElements() != null ? this.xmlinfo.getXMLPathElements().length - 1 : 0;
    }

    public IFilter<Object> getFilter() {
        return this.xmlinfo != null ? this.xmlinfo.getFilter() : null;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(SReflect.getInnerClassName(this.getClass()));
        if (this.xmlinfo != null && this.xmlinfo.getXMLPath() != null) {
            sbuf.append("(path=");
            sbuf.append(this.xmlinfo.getXMLPath());
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    public static final class SpecificityComparator
    implements Comparator<AbstractInfo> {
        @Override
        public int compare(AbstractInfo arg0, AbstractInfo arg1) {
            int ret = 0;
            if (arg0 != arg1) {
                AbstractInfo m1 = arg0;
                AbstractInfo m2 = arg1;
                ret = m2.getXMLPathDepth() - m1.getXMLPathDepth();
                if (ret == 0) {
                    int n = m1.getXMLPath() != null && m2.getXMLPath() == null ? 1 : (m1.getXMLPath() == null && m2.getXMLPath() != null ? -1 : (m1.getXMLPath() != null && m2.getXMLPath() != null ? (m2.getXMLPath().length() - m1.getXMLPath().length() != 0 ? m2.getXMLPath().length() - m1.getXMLPath().length() : m2.getXMLPath().compareTo(m1.getXMLPath())) : (ret = 0)));
                }
                if (ret == 0) {
                    int n = m1.getFilter() != null && m2.getFilter() == null ? 1 : (m1.getFilter() == null && m2.getFilter() != null ? -1 : (ret = m1.getFilter() != null && m2.getFilter() != null ? m2.getId() - m1.getId() : 0));
                }
                if (ret == 0) {
                    throw new RuntimeException("Info should differ: " + m1 + " " + m2);
                }
            }
            return ret;
        }
    }
}

