/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitClone
extends DefaultTask
implements AuthenticationSupported {
    private PasswordCredentials credentials = null;
    private Object uri = null;
    private Object remote = null;
    private boolean bare = false;
    private boolean checkout = true;
    private Object branch = null;
    private Collection<Object> branchesToClone = null;
    private boolean cloneAllBranches = true;
    private Object destinationPath = null;

    @TaskAction
    public void cloneRepo() {
        CloneCommand cmd = Git.cloneRepository();
        cmd.setCredentialsProvider(this.getCredentialsProvider());
        cmd.setURI(this.getUri().toString());
        cmd.setRemote(this.getRemote());
        cmd.setBare(this.getBare());
        cmd.setNoCheckout(!this.getCheckout());
        cmd.setBranch("refs/heads/" + this.getBranch());
        cmd.setBranchesToClone(this.getBranchesToClone());
        cmd.setCloneAllBranches(this.getCloneAllBranches());
        cmd.setDirectory(this.getDestinationDir());
        cmd.call();
    }

    @Input
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    private CredentialsProvider getCredentialsProvider() {
        if (this.getCredentials() == null || (this.getCredentials().getUsername() == null || this.getCredentials().getUsername().trim() == "") && (this.getCredentials().getPassword() == null || this.getCredentials().getPassword().trim() == "")) {
            return null;
        }
        return new UsernamePasswordCredentialsProvider(this.getCredentials().getUsername(), this.getCredentials().getPassword());
    }

    @Input
    public String getUri() {
        return ObjectUtil.unpackString(this.uri);
    }

    public void setUri(Object uri) {
        this.uri = uri;
    }

    @Input
    public String getRemote() {
        return this.remote == null ? "origin" : ObjectUtil.unpackString(this.remote);
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    @Input
    public boolean getBare() {
        return this.bare;
    }

    public void setBare(boolean bare) {
        this.bare = bare;
    }

    @Input
    public boolean getCheckout() {
        return this.checkout;
    }

    public void setCheckout(boolean checkout) {
        this.checkout = checkout;
    }

    @Input
    public String getBranch() {
        return this.branch == null ? "master" : ObjectUtil.unpackString(this.branch);
    }

    public void setBranch(Object branch) {
        this.branch = branch;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.getProject().file(this.destinationPath);
    }

    public void setDestinationPath(Object destinationPath) {
        this.destinationPath = destinationPath;
    }

    @Input
    public Collection<String> getBranchesToClone() {
        if (this.branchesToClone == null) {
            return Arrays.asList(this.getBranch());
        }
        HashSet<String> branches = new HashSet<String>();
        for (Object branch : this.branchesToClone) {
            branches.add(ObjectUtil.unpackString(branch));
        }
        return branches;
    }

    public void branchesToClone(Object ... branches) {
        if (this.branchesToClone == null) {
            this.branchesToClone = new ArrayList<Object>();
        }
        Collections.addAll(this.branchesToClone, branches);
    }

    public void setBranchesToClone(Collection<? extends Object> branchesToClone) {
        this.branchesToClone = branchesToClone;
        this.setCloneAllBranches(false);
    }

    @Input
    public boolean getCloneAllBranches() {
        return this.cloneAllBranches;
    }

    public void setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
    }
}

