/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;

public class VarInfo {
    protected Set<Var> projectVars;
    protected int distinctLevel;

    public VarInfo(Set<Var> projectVars, int distinctLevel) {
        this.projectVars = projectVars;
        this.distinctLevel = distinctLevel;
    }

    public Set<Var> getProjectVars() {
        return this.projectVars;
    }

    public int getDistinctLevel() {
        return this.distinctLevel;
    }

    public String toString() {
        return "VarInfo [projectVars=" + this.projectVars + ", distinctLevel=" + this.distinctLevel + "]";
    }

    public VarInfo applyTransform(NodeTransform nodeTransform) {
        Set<Var> vars = this.projectVars.stream().map(v -> (Var)nodeTransform.apply(v)).collect(Collectors.toSet());
        VarInfo result = new VarInfo(vars, this.distinctLevel);
        return result;
    }
}

