/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformReplaceConstants
extends TransformCopy {
    protected Generator<Var> generator;
    protected boolean omitDefaultGraphFilter;

    public TransformReplaceConstants(Generator<Var> generator, boolean omitDefaultGraphFilter) {
        this.generator = generator;
        this.omitDefaultGraphFilter = omitDefaultGraphFilter;
    }

    public static Triple listToTriple(List<Node> nodes) {
        return new Triple(nodes.get(0), nodes.get(1), nodes.get(2));
    }

    public static List<Node> tripleToList(Triple triple) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(triple.getSubject());
        result.add(triple.getPredicate());
        result.add(triple.getObject());
        return result;
    }

    public static Op transform(Op op) {
        Collection mentionedVars = OpVars.mentionedVars((Op)op);
        Set oldVisibleVars = OpVars.visibleVars((Op)op);
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((String)"v", (Collection)mentionedVars);
        TransformReplaceConstants transform = new TransformReplaceConstants((Generator<Var>)gen, false);
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public static Node transform(Map<Node, Var> nodeToVar, Node node, boolean isGraphNode, Generator<Var> generator, ExprList filters, boolean omitDefaultGraphFilter) {
        Node result;
        if (node.isConcrete()) {
            Var var = nodeToVar.get(node);
            if (var == null) {
                var = (Var)generator.next();
                nodeToVar.put(node, var);
                if (!(omitDefaultGraphFilter && isGraphNode && node.equals((Object)Quad.defaultGraphNodeGenerated))) {
                    E_Equals condition = new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)node));
                    filters.add((Expr)condition);
                }
            }
            result = var;
        } else {
            result = node;
        }
        return result;
    }

    public Op transform(OpQuadPattern op) {
        Set newVisibleVars;
        Set oldVisibleVars;
        HashMap<Node, Var> nodeToVar = new HashMap<Node, Var>();
        ExprList filters = new ExprList();
        BasicPattern triples = new BasicPattern();
        boolean retainDefaultGraphNode = true;
        Node graphNode = retainDefaultGraphNode && op.getGraphNode().equals((Object)Quad.defaultGraphNodeGenerated) ? Quad.defaultGraphNodeGenerated : TransformReplaceConstants.transform(nodeToVar, op.getGraphNode(), true, this.generator, filters, this.omitDefaultGraphFilter);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Triple triple : op.getBasicPattern().getList()) {
            for (Node node : TransformReplaceConstants.tripleToList(triple)) {
                Node n = TransformReplaceConstants.transform(nodeToVar, node, false, this.generator, filters, this.omitDefaultGraphFilter);
                nodes.add(n);
            }
            Triple t = TransformReplaceConstants.listToTriple(nodes);
            triples.add(t);
            nodes.clear();
        }
        OpQuadPattern result = new OpQuadPattern(graphNode, triples);
        if (!filters.isEmpty()) {
            result = OpFilter.filterBy((ExprList)filters, (Op)result);
        }
        if (!(oldVisibleVars = OpVars.visibleVars((Op)op)).equals(newVisibleVars = OpVars.visibleVars((Op)result))) {
            result = new OpProject((Op)result, new ArrayList(oldVisibleVars));
        }
        return result;
    }
}

