/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.utils.ExprHolder;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jena_sparql_api.utils.VarExprListUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.util.ExprUtils;

public class DistinctExtendFilter {
    protected Map<Var, Expr> postDistinctVarDefs;
    protected Map<Var, Expr> preDistinctVarDefs;
    protected ExprHolder filter;

    public Op toOp(Op result) {
        if (this.filter.getExpr().equals((Object)NodeValue.TRUE)) {
            result = OpFilter.filter((Expr)this.filter.getExpr(), (Op)result);
        }
        result = OpUtils.applyExtendProject(result, this.preDistinctVarDefs);
        if (this.postDistinctVarDefs != null) {
            result = OpDistinct.create((Op)result);
            result = OpUtils.applyExtendProject(result, this.postDistinctVarDefs);
        }
        return result;
    }

    public static Map<Var, Expr> createIdentityMap(Collection<Var> vars) {
        Map result = vars.stream().distinct().collect(Collectors.toMap(v -> v, v -> new ExprVar(v), (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        return result;
    }

    public DistinctExtendFilter(Map<Var, Expr> preDistinctVarDefs, Map<Var, Expr> postDistinctVarDefs, ExprHolder filter) {
        this.preDistinctVarDefs = preDistinctVarDefs;
        this.postDistinctVarDefs = postDistinctVarDefs;
        this.filter = filter;
    }

    public static DistinctExtendFilter create(Collection<Var> initialVars) {
        Map<Var, Expr> map = DistinctExtendFilter.createIdentityMap(initialVars);
        DistinctExtendFilter result = new DistinctExtendFilter(map, null, ExprHolder.from((Expr)NodeValue.TRUE));
        return result;
    }

    public DistinctExtendFilter applyProject(Collection<Var> projectVars) {
        Map<Var, Expr> varDefs = this.postDistinctVarDefs != null ? this.postDistinctVarDefs : this.preDistinctVarDefs;
        boolean isValidRequest = varDefs.keySet().containsAll(projectVars);
        varDefs.keySet().retainAll(projectVars);
        return this;
    }

    public DistinctExtendFilter applyDistinct() {
        if (this.postDistinctVarDefs != null) {
            this.preDistinctVarDefs = DistinctExtendFilter.expandDefs(this.postDistinctVarDefs, this.preDistinctVarDefs);
        }
        this.postDistinctVarDefs = new LinkedHashMap<Var, Expr>();
        for (Map.Entry<Var, Expr> e : this.preDistinctVarDefs.entrySet()) {
            this.postDistinctVarDefs.put(e.getKey(), (Expr)new ExprVar(e.getKey()));
        }
        return this;
    }

    public DistinctExtendFilter applyExtend(VarExprList extend) {
        Map map = extend.getExprs();
        this.applyExtend(map);
        return this;
    }

    public DistinctExtendFilter applyExtend(Map<Var, Expr> extend) {
        Map<Var, Expr> tmp = this.postDistinctVarDefs == null ? extend : DistinctExtendFilter.expandDefs(extend, this.postDistinctVarDefs);
        tmp = DistinctExtendFilter.expandDefs(tmp, this.preDistinctVarDefs);
        if (this.postDistinctVarDefs == null) {
            this.preDistinctVarDefs.putAll(tmp);
        } else {
            this.postDistinctVarDefs.putAll(tmp);
        }
        return this;
    }

    public DistinctExtendFilter applyFilter(ExprList contribExprs) {
        for (Expr expr : contribExprs) {
            this.applyFilter(expr);
        }
        return this;
    }

    public DistinctExtendFilter applyFilter(Expr contribExpr) {
        ExprHolder eh;
        Set<Var> availableVars;
        Set mentionedVars = contribExpr.getVarsMentioned();
        Sets.SetView errVars = Sets.difference((Set)mentionedVars, availableVars = this.postDistinctVarDefs != null ? this.postDistinctVarDefs.keySet() : this.preDistinctVarDefs.keySet());
        if (!errVars.isEmpty()) {
            throw new RuntimeException("Reference to unavailable vars: " + errVars + ", available: " + availableVars);
        }
        Expr expandedExpr = this.expandExpr(contribExpr);
        Expr currentExpr = this.filter.getExpr();
        Expr expr = NodeValue.TRUE.equals((Object)currentExpr) ? expandedExpr : new E_LogicalAnd(currentExpr, expandedExpr);
        this.filter = eh = ExprHolder.from(expr);
        return this;
    }

    public static String toString(Map.Entry<Var, Expr> e) {
        Var v = e.getKey();
        Expr x = e.getValue();
        String result = x.isVariable() && x.asVar().equals((Object)v) ? "" + v : "(" + x + " AS " + v + ")";
        return result;
    }

    public static String toString(Map<Var, Expr> varDefs) {
        String result = String.join((CharSequence)" ", varDefs.entrySet().stream().map(DistinctExtendFilter::toString).collect(Collectors.toList()));
        return result;
    }

    public String toString() {
        String result = "";
        if (this.postDistinctVarDefs != null) {
            result = result + "SELECT " + DistinctExtendFilter.toString(this.postDistinctVarDefs) + " {\n";
        }
        result = result + "SELECT " + (this.postDistinctVarDefs != null ? "DISTINCT " : "") + DistinctExtendFilter.toString(this.preDistinctVarDefs) + " {\n";
        result = result + "FILTER(" + this.filter.getExpr() + ")\n";
        if (this.postDistinctVarDefs != null) {
            result = result + "}\n";
        }
        return result;
    }

    public Expr expandExpr(Expr expr) {
        Expr result = this.postDistinctVarDefs != null ? DistinctExtendFilter.expandExpr(expr, this.postDistinctVarDefs) : expr;
        result = DistinctExtendFilter.expandExpr(expr, this.preDistinctVarDefs);
        return result;
    }

    public static Map<Var, Expr> expandDefs(Map<Var, Expr> src, Map<Var, Expr> varDefs) {
        ExprTransform exprTransform = VarExprListUtils.createExprTransform(varDefs);
        Map result = src.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Expr expr = (Expr)e.getValue();
            Expr r = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
            return r;
        }, (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        return result;
    }

    public static Expr expandExpr(Expr expr, Map<Var, Expr> varDefs) {
        ExprTransform exprTransform = VarExprListUtils.createExprTransform(varDefs);
        Expr result = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
        return result;
    }

    public boolean isDistinct() {
        boolean result = this.postDistinctVarDefs != null;
        return result;
    }

    public ExprHolder getFilter() {
        return this.filter;
    }

    public Map<Var, Expr> getPreDistinctVarDefs() {
        return this.preDistinctVarDefs;
    }

    public Map<Var, Expr> getPostDistinctVarDefs() {
        return this.postDistinctVarDefs;
    }

    public DistinctExtendFilter applyNodeTransform(NodeTransform nodeTransform) {
        Map preMap = null;
        if (this.preDistinctVarDefs != null) {
            preMap = VarExprListUtils.applyNodeTransform(this.preDistinctVarDefs, (NodeTransform)nodeTransform);
        }
        Map postMap = null;
        if (this.postDistinctVarDefs != null) {
            postMap = VarExprListUtils.applyNodeTransform(this.preDistinctVarDefs, (NodeTransform)nodeTransform);
        }
        Expr tmp = this.filter.getExpr().applyNodeTransform(nodeTransform);
        ExprHolder eh = ExprHolder.from(tmp);
        DistinctExtendFilter result = new DistinctExtendFilter(preMap, postMap, eh);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.postDistinctVarDefs == null ? 0 : this.postDistinctVarDefs.hashCode());
        result = 31 * result + (this.preDistinctVarDefs == null ? 0 : this.preDistinctVarDefs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistinctExtendFilter other = (DistinctExtendFilter)obj;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.postDistinctVarDefs == null ? other.postDistinctVarDefs != null : !this.postDistinctVarDefs.equals(other.postDistinctVarDefs)) {
            return false;
        }
        return !(this.preDistinctVarDefs == null ? other.preDistinctVarDefs != null : !this.preDistinctVarDefs.equals(other.preDistinctVarDefs));
    }

    public static void main(String[] args) {
        DistinctExtendFilter def = DistinctExtendFilter.create(new LinkedHashSet<Var>(Arrays.asList(Vars.s, Vars.p, Vars.o)));
        def.applyExtend(Collections.singletonMap(Vars.s, ExprUtils.parse((String)"?p + ?o")));
        def.applyDistinct();
        def.applyFilter(ExprUtils.parse((String)"?s = ?p"));
        def.applyDistinct();
        def.applyDistinct();
        def.applyDistinct();
        System.out.println(def);
    }
}

