/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.FeatureMap;
import org.aksw.commons.collections.FeatureMapImpl;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.algebra.analysis.VarInfo;
import org.aksw.jena_sparql_api.algebra.transform.TransformDistributeJoinOverUnion;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jena_sparql_api.algebra.utils.ConjunctiveQuery;
import org.aksw.jena_sparql_api.algebra.utils.ExprHolder;
import org.aksw.jena_sparql_api.algebra.utils.OpExtConjunctiveQuery;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jena_sparql_api.algebra.utils.PatternSummary;
import org.aksw.jena_sparql_api.algebra.utils.ProjectedOp;
import org.aksw.jena_sparql_api.algebra.utils.ProjectedQuadFilterPattern;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPattern;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPatternCanonical;
import org.aksw.jena_sparql_api.algebra.utils.VarOccurrence;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.DnfUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.NfUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorImpl2;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgebraUtils {
    private static final Logger logger = LoggerFactory.getLogger(AlgebraUtils.class);

    public static Op createCachingOp(Op subOp, Node storageRef) {
        boolean silent = false;
        OpService result = new OpService(storageRef, subOp, silent);
        return result;
    }

    public static QuadFilterPatternCanonical fromQuery(Query query) {
        ProjectedOp op = AlgebraUtils.toProjectedOp(query);
        Op resOp = op.getResidualOp();
        QuadFilterPatternCanonical result = AlgebraUtils.extractQuadFilterPatternCanonical(resOp);
        return result;
    }

    public static ProjectedOp toProjectedOp(Query query) {
        Op current;
        Op op = Algebra.compile((Query)query);
        while (!(current = op).equals(op = TransformDistributeJoinOverUnion.transform(current))) {
        }
        op = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)op);
        op = Algebra.toQuadForm((Op)op);
        ProjectedOp result = AlgebraUtils.cutProjection(op);
        return result;
    }

    public static QuadFilterPatternCanonical removeDefaultGraphFilter(QuadFilterPatternCanonical qfpc) {
        Set<Quad> quads = qfpc.getQuads();
        Set<Set<Expr>> cnf = qfpc.getFilterCnf();
        Map varToNode = CnfUtils.getConstants(cnf);
        Map<Var, Node> candMap = varToNode.entrySet().stream().filter(e -> Quad.defaultGraphIRI.equals(e.getValue()) || Quad.defaultGraphNodeGenerated.equals(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<Var> candVars = candMap.keySet();
        for (Quad quad : quads) {
            Node[] nodes = QuadUtils.quadToArray((Quad)quad);
            for (int i = 1; i < 4; ++i) {
                Node node = nodes[i];
                candVars.remove(node);
            }
        }
        Set<Set<Expr>> newCnf = cnf.stream().filter(clause -> {
            Map.Entry e = CnfUtils.extractEquality((Collection)clause);
            boolean r = !candMap.entrySet().contains(e);
            return r;
        }).collect(Collectors.toSet());
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(quads, ExprHolder.fromCnf(newCnf));
        return result;
    }

    public static ProjectedQuadFilterPattern optimizeFilters(ProjectedQuadFilterPattern pqfp) {
        PatternSummary summary = AlgebraUtils.summarize(pqfp.getQuadFilterPattern());
        QuadFilterPatternCanonical qfpc = summary.getCanonicalPattern();
        QuadFilterPatternCanonical optimized = AlgebraUtils.optimizeFilters(qfpc.getQuads(), qfpc.getFilterCnf(), pqfp.getProjectVars());
        QuadFilterPattern qfp = optimized.toQfp();
        ProjectedQuadFilterPattern result = new ProjectedQuadFilterPattern(pqfp.getProjectVars(), qfp, false);
        return result;
    }

    public static QuadFilterPatternCanonical optimizeFilters(Collection<Quad> quads, Set<Set<Expr>> cnf, Set<Var> projection) {
        Map varToNode = CnfUtils.getConstants(cnf);
        Set optVars = varToNode.keySet();
        optVars.remove(projection);
        HashSet<Quad> newQuads = new HashSet<Quad>();
        for (Quad quad : quads) {
            Node[] nodeArray = QuadUtils.quadToArray((Quad)quad);
            for (int i = 0; i < 4; ++i) {
                Node node = nodeArray[i];
                Node subst = (Node)varToNode.get(node);
                nodeArray[i] = subst == null ? node : subst;
            }
            Quad newQuad = QuadUtils.arrayToQuad((Node[])nodeArray);
            newQuads.add(newQuad);
        }
        HashSet<Set<Expr>> newCnf = new HashSet<Set<Expr>>();
        for (Set<Expr> set : cnf) {
            Map.Entry equality = CnfUtils.extractEquality(set);
            boolean retainClause = equality == null || !optVars.contains(equality.getKey());
            if (!retainClause) continue;
            newCnf.add(set);
        }
        QuadFilterPatternCanonical quadFilterPatternCanonical = new QuadFilterPatternCanonical(newQuads, ExprHolder.fromCnf(newCnf));
        return quadFilterPatternCanonical;
    }

    public static OpService wrapWithServiceOld(Op patternOp, Node serviceNode, Op executionOp) {
        boolean silent = false;
        OpUnion union = new OpUnion(patternOp, executionOp);
        Query subQuery = OpAsQuery.asQuery((Op)union);
        ElementSubQuery subElement = new ElementSubQuery(subQuery);
        ElementService elt = new ElementService(serviceNode, (Element)subElement, silent);
        OpService result = new OpService(serviceNode, (Op)union, elt, silent);
        return result;
    }

    public static Set<Set<Expr>> normalize(Quad quad, Set<Set<Expr>> nf) {
        List componentVars = Vars.gspo;
        HashMap<Var, Var> renameMap = new HashMap<Var, Var>();
        HashSet<Set<E_Equals>> extra = new HashSet<Set<E_Equals>>();
        for (int i = 0; i < 4; ++i) {
            Node tmp = QuadUtils.getNode((Quad)quad, (int)i);
            if (i == 0 && (Quad.defaultGraphNodeGenerated.equals((Object)tmp) || Quad.defaultGraphIRI.equals((Object)tmp))) continue;
            if (!tmp.isVariable()) {
                throw new RuntimeException("Expected variable normalized quad, got: " + quad);
            }
            Var quadVar = (Var)tmp;
            Var componentVar = (Var)componentVars.get(i);
            Var priorComponentVar = (Var)renameMap.get(quadVar);
            if (priorComponentVar != null) {
                extra.add(Collections.singleton(new E_Equals((Expr)new ExprVar(priorComponentVar), (Expr)new ExprVar(componentVar))));
                continue;
            }
            renameMap.put(quadVar, componentVar);
        }
        NodeTransformRenameMap transform = new NodeTransformRenameMap(renameMap);
        Set result = ClauseUtils.applyNodeTransformSet(nf, (NodeTransform)transform);
        result.addAll(extra);
        return result;
    }

    public static Set<Set<Expr>> add(Quad quad, Set<Set<Expr>> cnf) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : cnf) {
            Set clauseVars = ClauseUtils.getVarsMentioned(clause);
            Set exprVars = QuadUtils.getVarsMentioned((Quad)quad);
            boolean isApplicable = exprVars.containsAll(clauseVars);
            if (!isApplicable) continue;
            result.add(clause);
        }
        return result;
    }

    public static ProjectedOp cutProjectionAndNormalize(Op op, Rewrite opNormalizer) {
        ProjectedOp projectedOp = AlgebraUtils.cutProjection(op);
        Op normalizedOp = opNormalizer.rewrite(projectedOp.getResidualOp());
        ProjectedOp result = new ProjectedOp(projectedOp.getProjection(), normalizedOp);
        return result;
    }

    public static ProjectedOp cutProjection(Op op) {
        Op residualOp = op;
        LinkedHashSet<Var> projectVars = null;
        int distinctLevel = 0;
        if (residualOp instanceof OpDistinct) {
            distinctLevel = 2;
            residualOp = ((OpDistinct)residualOp).getSubOp();
        }
        if (residualOp instanceof OpProject) {
            OpProject tmp = (OpProject)residualOp;
            projectVars = new LinkedHashSet<Var>(tmp.getVars());
            residualOp = tmp.getSubOp();
        }
        ProjectedOp result = projectVars == null ? new ProjectedOp(new VarInfo(OpUtils.visibleNamedVars(residualOp), 0), residualOp) : new ProjectedOp(new VarInfo(projectVars, distinctLevel), residualOp);
        return result;
    }

    public static ProjectedQuadFilterPattern transform(Query query) {
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = TransformReplaceConstants.transform(op);
        ProjectedQuadFilterPattern result = AlgebraUtils.transform(op);
        return result;
    }

    public static QuadFilterPatternCanonical transform2(Query query) {
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        ProjectedQuadFilterPattern pqfp = AlgebraUtils.transform(op = TransformReplaceConstants.transform(op));
        QuadFilterPatternCanonical result = pqfp == null ? null : AlgebraUtils.canonicalize2(pqfp.getQuadFilterPattern(), (Generator<Var>)VarGeneratorImpl2.create((String)"v"));
        return result;
    }

    public static ProjectedQuadFilterPattern transform(Element element) {
        Op op = Algebra.compile((Element)element);
        op = Algebra.toQuadForm((Op)op);
        ProjectedQuadFilterPattern result = AlgebraUtils.transform(op);
        return result;
    }

    public static QuadFilterPatternCanonical extractQuadFilterPatternCanonical(Op op) {
        QuadFilterPatternCanonical result;
        QuadFilterPattern qfp = AlgebraUtils.extractQuadFilterPattern(op);
        if (qfp != null) {
            VarGeneratorImpl2 generator = VarGeneratorImpl2.create();
            result = AlgebraUtils.canonicalize2(qfp, (Generator<Var>)generator);
        } else {
            result = null;
        }
        return result;
    }

    public static ConjunctiveQuery tryExtractConjunctiveQuery(Op op, Generator<Var> generator) {
        OpDistinct opDistinct = null;
        OpProject opProject = null;
        boolean consumeDistinct = false;
        boolean consumeProject = false;
        if (consumeDistinct && op instanceof OpDistinct) {
            opDistinct = (OpDistinct)op;
            op = opDistinct.getSubOp();
        }
        if (consumeProject && op instanceof OpProject) {
            opProject = (OpProject)op;
            op = opProject.getSubOp();
        }
        QuadFilterPattern qfp = AlgebraUtils.extractQuadFilterPattern(op);
        ConjunctiveQuery result = null;
        if (qfp != null) {
            boolean isDistinct = opDistinct != null;
            Set projectVars = opProject == null ? OpVars.visibleVars((Op)op) : new LinkedHashSet(opProject.getVars());
            VarInfo varInfo = new VarInfo(projectVars, isDistinct ? 2 : 0);
            QuadFilterPatternCanonical qfpc = AlgebraUtils.canonicalize2(qfp, generator);
            result = new ConjunctiveQuery(varInfo, qfpc);
        }
        return result;
    }

    public static QuadFilterPattern extractQuadFilterPattern(Op op) {
        QuadFilterPattern result = null;
        OpFilter opFilter = op instanceof OpFilter ? (OpFilter)op : (OpFilter)OpFilter.filter((Expr)NodeValue.TRUE, (Op)op);
        if ((op = opFilter.getSubOp()) instanceof OpGraph) {
            OpGraph opGraph = (OpGraph)op;
            Node graphNode = opGraph.getNode();
            Set filterVars = ExprVars.getVarsMentioned((ExprList)opFilter.getExprs());
            op = graphNode.isVariable() && !filterVars.contains(graphNode) ? opGraph.getSubOp() : null;
        }
        if (op instanceof OpQuadPattern) {
            OpQuadPattern opQuadPattern = (OpQuadPattern)opFilter.getSubOp();
            QuadPattern quadPattern = opQuadPattern.getPattern();
            List quads = quadPattern.getList();
            ExprList exprs = opFilter.getExprs();
            Expr expr = ExprUtils.andifyBalanced((Iterable)exprs);
            result = new QuadFilterPattern(quads, expr);
        }
        return result;
    }

    public static ProjectedQuadFilterPattern transform(Op op) {
        QuadFilterPattern qfp;
        ProjectedQuadFilterPattern result = null;
        HashSet<Var> projectVars = null;
        boolean isDistinct = false;
        if (op instanceof OpDistinct) {
            isDistinct = true;
            op = ((OpDistinct)op).getSubOp();
        }
        if (op instanceof OpProject) {
            OpProject tmp = (OpProject)op;
            projectVars = new HashSet<Var>(tmp.getVars());
            op = tmp.getSubOp();
        }
        if ((qfp = AlgebraUtils.extractQuadFilterPattern(op)) != null) {
            if (projectVars == null) {
                projectVars = new HashSet(OpVars.mentionedVars((Op)op));
            }
            result = new ProjectedQuadFilterPattern(projectVars, qfp, isDistinct);
        }
        return result;
    }

    public static Map<Quad, Set<Set<Expr>>> quadToCnf(QuadFilterPattern qfp) {
        HashMap<Quad, Set<Set<Expr>>> result = new HashMap<Quad, Set<Set<Expr>>>();
        Expr expr = qfp.getExpr();
        if (expr == null) {
            expr = NodeValue.TRUE;
        }
        Set filterCnf = CnfUtils.toSetCnf((Expr)expr);
        HashSet<Quad> quads = new HashSet<Quad>(qfp.getQuads());
        for (Quad quad : quads) {
            Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
            HashSet<Set> cnf = new HashSet<Set>();
            for (Set clause : filterCnf) {
                Set clauseVars = ClauseUtils.getVarsMentioned((Iterable)clause);
                boolean containsAll = quadVars.containsAll(clauseVars);
                if (!containsAll) continue;
                cnf.add(clause);
            }
            result.put(quad, cnf);
        }
        return result;
    }

    public static OpExtConjunctiveQuery tryCreateCqfpOld(Op op, Generator<Var> generator) {
        ConjunctiveQuery cq = AlgebraUtils.tryExtractConjunctiveQuery(op, generator);
        OpExtConjunctiveQuery result = cq == null ? null : new OpExtConjunctiveQuery(cq);
        return result;
    }

    public static Op tryCreateCqfp(Op op, Generator<Var> generator) {
        ConjunctiveQuery cq = AlgebraUtils.tryExtractConjunctiveQuery(op, generator);
        OpExtConjunctiveQuery result = null;
        if (cq != null) {
            LinkedHashSet<Set<Expr>> conjunctive = new LinkedHashSet<Set<Expr>>();
            LinkedHashSet<Set<Expr>> disjunctive = new LinkedHashSet<Set<Expr>>();
            Set<Set<Expr>> cnf = cq.getPattern().getExprHolder().getCnf();
            for (Set<Expr> clause : cnf) {
                if (clause.size() == 1) {
                    conjunctive.add(clause);
                    continue;
                }
                disjunctive.add(clause);
            }
            LinkedHashSet<Var> requiredVars = new LinkedHashSet<Var>(cq.getProjection().getProjectVars());
            Set vars = NfUtils.getVarsMentioned(disjunctive);
            requiredVars.addAll(vars);
            QuadFilterPatternCanonical qfpc = new QuadFilterPatternCanonical(cq.getPattern().getQuads(), ExprHolder.fromCnf(conjunctive));
            cq = new ConjunctiveQuery(new VarInfo(requiredVars, 0), qfpc);
            result = new OpExtConjunctiveQuery(cq);
            if (!disjunctive.isEmpty()) {
                Expr expr = DnfUtils.toExpr(disjunctive);
                result = OpFilter.filterDirect((Expr)expr, (Op)result);
                if (!requiredVars.equals(cq.getProjection().getProjectVars())) {
                    result = new OpProject((Op)result, new ArrayList<Var>(cq.getProjection().getProjectVars()));
                }
            }
            if (cq.getProjection().getDistinctLevel() != 0) {
                result = new OpDistinct((Op)result);
            }
        }
        return result;
    }

    public static QuadFilterPatternCanonical canonicalize2(QuadFilterPattern qfp, Generator<Var> generator) {
        Set dnf = DnfUtils.toSetDnf((Expr)qfp.getExpr());
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(new LinkedHashSet<Quad>(qfp.getQuads()), ExprHolder.fromDnf(dnf));
        return result;
    }

    public static QuadFilterPatternCanonical canonicalize2old(QuadFilterPattern qfp, Generator<Var> generator) {
        QuadFilterPatternCanonical tmp = AlgebraUtils.replaceConstants(qfp.getQuads(), generator);
        tmp = AlgebraUtils.removeDefaultGraphFilter(tmp);
        Set cnf = CnfUtils.toSetCnf((Expr)qfp.getExpr());
        cnf.addAll(tmp.getFilterCnf());
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(tmp.getQuads(), ExprHolder.fromCnf(cnf));
        return result;
    }

    public static QuadFilterPatternCanonical canonicalize(QuadFilterPatternCanonical qfpc, Generator<Var> generator) {
        QuadFilterPatternCanonical tmp = AlgebraUtils.replaceConstants(qfpc.getQuads(), generator);
        HashSet<Set<Expr>> newCnf = new HashSet<Set<Expr>>();
        newCnf.addAll(qfpc.getFilterCnf());
        newCnf.addAll(tmp.getFilterCnf());
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(tmp.getQuads(), ExprHolder.fromCnf(newCnf));
        return result;
    }

    public static QuadFilterPatternCanonical replaceConstants(Iterable<Quad> quads, Generator<Var> generator) {
        HashSet<Set<Expr>> cnf = new HashSet<Set<Expr>>();
        HashMap<Node, Var> constantToVar = new HashMap<Node, Var>();
        LinkedHashSet<Quad> newQuads = new LinkedHashSet<Quad>();
        for (Quad quad : quads) {
            Node[] nodes = QuadUtils.quadToArray((Quad)quad);
            for (int i = 0; i < 4; ++i) {
                Node node = nodes[i];
                if (node.isVariable()) continue;
                Var v = (Var)constantToVar.get(node);
                if (v == null) {
                    v = (Var)generator.next();
                    constantToVar.put(node, v);
                    E_Equals expr = new E_Equals((Expr)new ExprVar(v), (Expr)NodeValue.makeNode((Node)node));
                    cnf.add(Collections.singleton(expr));
                }
                nodes[i] = v;
            }
            Quad newQuad = QuadUtils.arrayToQuad((Node[])nodes);
            newQuads.add(newQuad);
        }
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(newQuads, ExprHolder.fromCnf(cnf));
        return result;
    }

    public static PatternSummary summarize(QuadFilterPattern originalPattern) {
        Expr expr = originalPattern.getExpr();
        LinkedHashSet<Quad> quads = new LinkedHashSet<Quad>(originalPattern.getQuads());
        Set filterDnf = DnfUtils.toSetDnf((Expr)expr, (boolean)true);
        IBiSetMultimap<Quad, Set<Set<Expr>>> quadToDnf = AlgebraUtils.createMapQuadsToFilters(quads, filterDnf);
        IBiSetMultimap<Var, VarOccurrence> varOccurrences = AlgebraUtils.createMapVarOccurrences(quadToDnf, false);
        QuadFilterPatternCanonical canonicalPattern = new QuadFilterPatternCanonical(quads, ExprHolder.fromDnf(filterDnf));
        PatternSummary result = new PatternSummary(originalPattern, canonicalPattern, quadToDnf, varOccurrences);
        return result;
    }

    private static IBiSetMultimap<Var, VarOccurrence> createMapVarOccurrences(IBiSetMultimap<Quad, Set<Set<Expr>>> quadToCnf, boolean pruneVarOccs) {
        Set quads = quadToCnf.keySet();
        BiHashMultimap varOccurrences = new BiHashMultimap();
        for (Quad quad : quads) {
            Set quadCnf = (Set)quadToCnf.get((Object)quad).iterator().next();
            for (int j = 0; j < 4; ++j) {
                Var var = (Var)QuadUtils.getNode((Quad)quad, (int)j);
                VarOccurrence varOccurence = new VarOccurrence(quadCnf, j);
                varOccurrences.put((Object)var, (Object)varOccurence);
            }
        }
        if (pruneVarOccs) {
            Iterator it = varOccurrences.asMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashSet<Set<Set<Expr>>> varQuadCnfs = new HashSet<Set<Set<Expr>>>();
                for (VarOccurrence varOccurrence : (Collection)entry.getValue()) {
                    varQuadCnfs.add(varOccurrence.getQuadCnf());
                    if (varQuadCnfs.size() <= 1) continue;
                    break;
                }
                if (varQuadCnfs.size() != 1) continue;
                it.remove();
            }
        }
        return varOccurrences;
    }

    public static IBiSetMultimap<Quad, Set<Set<Expr>>> createMapQuadsToFilters(QuadFilterPatternCanonical qfpc) {
        Set<Quad> quads = qfpc.getQuads();
        Set<Set<Object>> filterDnf = qfpc.getFilterDnf();
        if (filterDnf == null) {
            filterDnf = Collections.singleton(Collections.emptySet());
        }
        IBiSetMultimap<Quad, Set<Set<Expr>>> result = AlgebraUtils.createMapQuadsToFilters(quads, filterDnf);
        return result;
    }

    public static IBiSetMultimap<Quad, Set<Set<Expr>>> createMapQuadsToFilters(Set<Quad> quads, Set<Set<Expr>> filterDnf) {
        BiHashMultimap quadToDnf = new BiHashMultimap();
        for (Quad quad : quads) {
            Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
            Set<Set<Expr>> dnf = new HashSet<Set<Expr>>();
            for (Set<Expr> clause : filterDnf) {
                HashSet<Expr> cnf = new HashSet<Expr>();
                for (Expr expr : clause) {
                    Set exprVars = ExprVars.getVarsMentioned((Expr)expr);
                    boolean containsAll = quadVars.containsAll(exprVars);
                    if (!containsAll) continue;
                    cnf.add(expr);
                }
                dnf.add(cnf);
            }
            dnf = AlgebraUtils.normalize(quad, dnf);
            quadToDnf.put((Object)quad, dnf);
        }
        return quadToDnf;
    }

    public static Expr createExpr(ResultSet rs, Map<Var, Var> varMap) {
        if (rs.getResultVars().size() != 1) {
            throw new RuntimeException("Not supported yet");
        }
        String varName = (String)rs.getResultVars().iterator().next();
        Var var = Var.alloc((String)varName);
        Set<Node> nodes = AlgebraUtils.getResultSetCol(rs, var);
        ExprList exprs = AlgebraUtils.nodesToExprs(nodes);
        Var inVar = varMap.get(var);
        ExprVar ev = new ExprVar(inVar);
        E_OneOf result = new E_OneOf((Expr)ev, exprs);
        return result;
    }

    public static Set<Node> getResultSetCol(ResultSet rs, Var v) {
        HashSet<Node> result = new HashSet<Node>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public static ExprList nodesToExprs(Iterable<Node> nodes) {
        ExprList result = new ExprList();
        for (Node node : nodes) {
            NodeValue expr = NodeValue.makeNode((Node)node);
            result.add((Expr)expr);
        }
        return result;
    }

    public static SetMultimap<Quad, Quad> quadJoinSummary(List<Quad> sub) {
        Node[] tmp = new Node[4];
        HashMultimap result = HashMultimap.create();
        for (int i = 0; i < sub.size(); ++i) {
            Quad a = sub.get(i);
            for (int j = i + 1; j < sub.size(); ++j) {
                Quad b = sub.get(j);
                for (int k = 0; k < 4; ++k) {
                    Node c;
                    Node nb;
                    Node na = QuadUtils.getNode((Quad)a, (int)k);
                    boolean isEqual = na.equals((Object)(nb = QuadUtils.getNode((Quad)b, (int)k)));
                    tmp[k] = c = isEqual ? NodeValue.TRUE.asNode() : NodeValue.FALSE.asNode();
                }
                Quad summary = QuadUtils.create((Node[])tmp);
                result.put((Object)summary, (Object)a);
                result.put((Object)summary, (Object)b);
            }
        }
        return result;
    }

    public static Set<Var> getRefVars(Query query) {
        return null;
    }

    public static FeatureMap<Expr, Multimap<Expr, Expr>> indexDnf(Set<Set<Expr>> dnf) {
        if (dnf == null) {
            dnf = Collections.singleton(Collections.emptySet());
        }
        FeatureMapImpl result = new FeatureMapImpl();
        for (Set<Object> clause : dnf) {
            HashMultimap exprSigToExpr = HashMultimap.create();
            HashSet<Expr> clauseSig = new HashSet<Expr>();
            for (Expr expr : clause) {
                Expr exprSig = ExprUtils.signaturize((Expr)expr);
                exprSigToExpr.put((Object)exprSig, (Object)expr);
                clauseSig.add(exprSig);
            }
            result.put(clauseSig, (Object)exprSigToExpr);
        }
        return result;
    }
}

