/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import java.util.Map;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.lookup.CountInfo;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.ListServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;

public class ListServiceResourceShape
implements ListService<Concept, Node, DatasetGraph> {
    private QueryExecutionFactory qef;
    private ResourceShape resourceShape;
    private boolean isLeftJoin;

    public ListServiceResourceShape(QueryExecutionFactory qef, ResourceShape resourceShape, boolean isLeftJoin) {
        this.qef = qef;
        this.resourceShape = resourceShape;
        this.isLeftJoin = isLeftJoin;
    }

    public Map<Node, DatasetGraph> fetchData(Concept concept, Long limit, Long offset) {
        MappedConcept mappedConcept = ResourceShape.createMappedConcept2((ResourceShape)this.resourceShape, (Concept)concept, (boolean)false);
        ListService ls = ListServiceUtils.createListServiceMappedConcept((QueryExecutionFactory)this.qef, (MappedConcept)mappedConcept, (boolean)this.isLeftJoin);
        Map result = ls.fetchData((Object)concept, limit, offset);
        return result;
    }

    public CountInfo fetchCount(Concept concept, Long itemLimit, Long rowLimit) {
        CountInfo result = ServiceUtils.fetchCountConcept((QueryExecutionFactory)this.qef, (Concept)concept, (Long)itemLimit, (Long)rowLimit);
        return result;
    }

    public static ListServiceResourceShape create(QueryExecutionFactory qef, ResourceShape resourceShape, boolean isLeftJoin) {
        ListServiceResourceShape result = new ListServiceResourceShape(qef, resourceShape, isLeftJoin);
        return result;
    }
}

