/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.cli.main;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;

public class JobParametersJsonUtils {
    public static void processArg(JobParametersBuilder builder, String key, JsonPrimitive p, boolean isIdentifying) {
        if (p.isBoolean()) {
            boolean tmp = p.getAsBoolean();
            Long v = tmp ? 1L : 0L;
            builder.addLong(key, v, isIdentifying);
        } else if (p.isString()) {
            String tmp = p.getAsString();
            builder.addString(key, tmp, isIdentifying);
        } else if (p.isNumber()) {
            Number tmp;
            Number n = p.getAsNumber();
            if (n instanceof LazilyParsedNumber) {
                LazilyParsedNumber lpn = (LazilyParsedNumber)n;
                String tmp2 = lpn.toString();
                boolean endsWithDotZero = tmp2.endsWith(".0");
                if (tmp2 != null && tmp2.contains(".") && !endsWithDotZero) {
                    n = Double.parseDouble(tmp2);
                } else {
                    if (endsWithDotZero) {
                        tmp2 = tmp2.substring(0, tmp2.length() - 2);
                    }
                    n = Long.parseLong(tmp2);
                }
            }
            if (n instanceof Integer || n instanceof Long || n instanceof BigDecimal) {
                tmp = n.longValue();
                builder.addLong(key, tmp, isIdentifying);
            } else if (n instanceof Float || n instanceof Double) {
                tmp = n.doubleValue();
                builder.addDouble(key, (Double)tmp, isIdentifying);
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
    }

    public static void processArg(JobParametersBuilder builder, String key, JsonElement json, Set<String> identifyingKeys) {
        JsonObject obj = json.getAsJsonObject();
        JsonElement value = obj.get("value");
        JsonElement tmpIdent = obj.get("ident");
        boolean isIdent = tmpIdent != null ? tmpIdent.getAsBoolean() : false;
        JsonPrimitive p = value.getAsJsonPrimitive();
        JobParametersJsonUtils.processArg(builder, key, p, isIdent);
    }

    public static JobParameters toJobParameters(JsonElement json, Set<String> identifyingKeys) {
        JobParametersBuilder builder = new JobParametersBuilder();
        JobParametersJsonUtils.toJobParameters(builder, json, identifyingKeys);
        JobParameters result = builder.toJobParameters();
        return result;
    }

    public static void toJobParameters(JobParametersBuilder builder, JsonElement json, Set<String> identifyingKeys) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement val = (JsonElement)entry.getValue();
                    JobParametersJsonUtils.processArg(builder, key, val, identifyingKeys);
                }
            } else {
                throw new RuntimeException("Invalid job parameters config: " + json);
            }
        }
    }
}

