/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.cli.main;

import com.google.common.base.Function;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.aksw.commons.util.StreamUtils;
import org.aksw.gson.utils.JsonProcessorKey;
import org.aksw.gson.utils.JsonTransformerRewrite;
import org.aksw.gson.utils.JsonVisitor;
import org.aksw.gson.utils.JsonVisitorRewrite;
import org.aksw.gson.utils.JsonWalker;
import org.aksw.jena_sparql_api.batch.BatchWorkflowManager;
import org.aksw.jena_sparql_api.batch.JenaExtensionBatch;
import org.aksw.jena_sparql_api.batch.ListServiceResourceShape;
import org.aksw.jena_sparql_api.batch.QueryTransformConstructGroupedGraph;
import org.aksw.jena_sparql_api.batch.cli.main.JsonVisitorRewriteJobParameters;
import org.aksw.jena_sparql_api.batch.cli.main.JsonVisitorRewriteKeys;
import org.aksw.jena_sparql_api.batch.config.ConfigBatchJobDynamic;
import org.aksw.jena_sparql_api.batch.config.ConfigParsersCore;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteBeanClassName;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteBeanDefinition;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteClass;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteHop;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteJson;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewritePrefixes;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteShape;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSimpleJob;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSparqlFile;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSparqlPipe;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSparqlService;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSparqlStep;
import org.aksw.jena_sparql_api.batch.json.rewriters.JsonVisitorRewriteSparqlUpdate;
import org.aksw.jena_sparql_api.batch.step.FactoryBeanStepLog;
import org.aksw.jena_sparql_api.batch.step.FactoryBeanStepSparqlCount;
import org.aksw.jena_sparql_api.batch.to_review.MapTransformerSimple;
import org.aksw.jena_sparql_api.beans.json.JsonProcessorContext;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.ListServiceUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceListService;
import org.aksw.jena_sparql_api.lookup.LookupServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.modifier.ModifierDatasetGraphEnrich;
import org.aksw.jena_sparql_api.modifier.ModifierDatasetGraphSparqlUpdate;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeParserJsonObject;
import org.aksw.jena_sparql_api.utils.DatasetGraphUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.aksw.spring.json.ContextProcessorJsonUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class MainBatchWorkflow {
    private static final Logger logger = LoggerFactory.getLogger(MainBatchWorkflow.class);
    public static String jsonFn = "http://jsa.aksw.org/fn/json/";
    public static String httpFn = "http://jsa.aksw.org/fn/http/";
    public static String termFn = "http://jsa.aksw.org/fn/term/";
    public static String tmpNs = "http://jsa.aksw.org/tmp/";

    public static void mainXml() throws Exception {
        ClassPathXmlApplicationContext test = new ClassPathXmlApplicationContext("testList.xml");
        List<String> allBeans = Arrays.asList(test.getBeanDefinitionNames());
        System.out.println("Got " + allBeans.size() + " beans: " + allBeans);
    }

    public static void foo() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String script1 = "function hello(name) {print ('Hello, ' + name);}";
        engine.eval(script1);
        Invocable inv = (Invocable)((Object)engine);
        inv.invokeFunction("hello", "Scripting!!");
    }

    public static void main(String[] args) throws Exception {
        String str = MainBatchWorkflow.readResource("job-fetch-data-4-threads.js");
        StringReader reader = new StringReader(str);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        jsonReader.setLenient(true);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement o = (JsonElement)gson.fromJson(jsonReader, JsonElement.class);
        String canon = gson.toJson(o);
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        Logger scriptLogger = LoggerFactory.getLogger((String)(MainBatchWorkflow.class.getName() + "-ScriptEngine"));
        engine.put("logger", logger);
        ScriptContext ctx = engine.getContext();
        engine.eval(MainBatchWorkflow.readResource("js/lib/lodash/4.3.0/lodash.js"));
        engine.eval(MainBatchWorkflow.readResource("js/src/rewrite-master.js"));
        List<String> rewriterResourceNames = Arrays.asList("js/src/rewriters/RewriterSparqlHop.js", "js/src/rewriters/RewriterJson.js", "js/src/rewriters/RewriterPrefixes.js", "js/src/rewriters/RewriterSparqlFile.js", "js/src/rewriters/RewriterSparqlCount.js", "js/src/rewriters/RewriterSparqlService.js", "js/src/rewriters/RewriterSparqlStep.js", "js/src/rewriters/RewriterSparqlUpdate.js", "js/src/rewriters/RewriterBeanClassName.js", "js/src/rewriters/RewriterBeanDefinition.js", "js/src/rewriters/RewriterSparqlPipe.js", "js/src/rewriters/RewriterSimpleJob.js");
        String base = "src/main/resources/";
        for (String name : rewriterResourceNames) {
            engine.eval("load('" + base + "/" + name + "')");
        }
        Invocable inv = (Invocable)((Object)engine);
        Object tmpJsonStr = inv.invokeFunction("performRewrite", canon);
        String jsonStr = (String)tmpJsonStr;
        String prettyJsonStr = gson.toJson(gson.fromJson(jsonStr, Object.class));
        System.out.println("RESULT\n--------------------------------------------");
        System.out.println(prettyJsonStr);
        System.exit(0);
        ApplicationContext baseContext = MainBatchWorkflow.initBaseContext(null);
        JenaExtensionBatch.initJenaExtensions(baseContext);
        MainBatchWorkflow.mainContext(baseContext);
    }

    public static PrefixMapping getDefaultPrefixMapping() {
        PrefixMappingImpl result = new PrefixMappingImpl();
        MainBatchWorkflow.addDefaultPrefixMapping((PrefixMapping)result);
        return result;
    }

    public static void addDefaultPrefixMapping(PrefixMapping pm) {
        pm.setNsPrefix("rdf", RDF.getURI());
        pm.setNsPrefix("rdfs", RDFS.getURI());
        pm.setNsPrefix("owl", OWL.getURI());
        pm.setNsPrefix("geom", "http://geovocab.org/geometry#");
        pm.setNsPrefix("ogc", "http://www.opengis.net/ont/geosparql#");
        pm.setNsPrefix("nominatim", "http://jsa.aksw.org/fn/nominatim/");
        pm.setNsPrefix("xsd", XSD.getURI());
        pm.setNsPrefix("json", jsonFn);
        pm.setNsPrefix("http", httpFn);
        pm.setNsPrefix("term", termFn);
        pm.setNsPrefix("tmp", tmpNs);
    }

    public static ApplicationContext initBaseContext(ApplicationContext appContext) {
        AnnotationConfigApplicationContext coreContext = new AnnotationConfigApplicationContext();
        coreContext.setParent(appContext);
        coreContext.register(new Class[]{ConfigParsersCore.class});
        coreContext.refresh();
        AnnotationConfigApplicationContext baseContext = new AnnotationConfigApplicationContext();
        baseContext.setParent((ApplicationContext)coreContext);
        baseContext.register(new Class[]{ConfigBatchJobDynamic.class});
        baseContext.refresh();
        return baseContext;
    }

    public static void copyScopes(GenericApplicationContext targetCtx, GenericApplicationContext sourceCtx) {
        for (String scopeName : sourceCtx.getBeanFactory().getRegisteredScopeNames()) {
            Scope scope = sourceCtx.getBeanFactory().getRegisteredScope(scopeName);
            targetCtx.getBeanFactory().registerScope(scopeName, scope);
        }
    }

    public static AnnotationConfigApplicationContext initBatchContext(ApplicationContext baseContext) {
        AnnotationConfigApplicationContext batchContext = new AnnotationConfigApplicationContext();
        batchContext.setParent(baseContext);
        MainBatchWorkflow.copyScopes((GenericApplicationContext)batchContext, (GenericApplicationContext)baseContext);
        return batchContext;
    }

    public static AnnotationConfigApplicationContext initContext(ApplicationContext baseContext, JsonElement json) throws Exception {
        AnnotationConfigApplicationContext result = MainBatchWorkflow.initBatchContext(baseContext);
        JsonProcessorKey contextPreprocessor = new JsonProcessorKey();
        JsonProcessorContext contextProcessor = new JsonProcessorContext((ApplicationContext)result);
        JsonVisitorRewriteJobParameters subVisitor = new JsonVisitorRewriteJobParameters();
        JsonVisitorRewriteKeys visitor = JsonVisitorRewriteKeys.create((Function<JsonElement, JsonElement>)JsonTransformerRewrite.create((JsonVisitor)subVisitor, (boolean)false));
        json = MainBatchWorkflow.rewrite(json);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String str = gson.toJson(json);
        logger.debug("Final JSON specification: " + str);
        contextProcessor.process(json);
        return result;
    }

    public static BeanDefinition beanDefinitionOfType(BeanDefinitionRegistry context, Class<?> clazz) {
        String[] names;
        BeanDefinition result = null;
        for (String name : names = context.getBeanDefinitionNames()) {
            Class c;
            BeanDefinition bd = context.getBeanDefinition(name);
            String className = bd.getBeanClassName();
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unexpected non-fatal expection", (Throwable)e);
                continue;
            }
            if (FactoryBean.class.isAssignableFrom(c)) {
                FactoryBean fb;
                try {
                    fb = (FactoryBean)c.newInstance();
                }
                catch (Exception e) {
                    logger.warn("Unexpected non-fatal exception", (Throwable)e);
                    continue;
                }
                c = fb.getObjectType();
            }
            if (c == null || !clazz.isAssignableFrom(c)) continue;
            result = bd;
            break;
        }
        return result;
    }

    public static JsonElement rewrite(JsonElement json) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonStr = gson.toJson(json);
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        Logger scriptLogger = LoggerFactory.getLogger((String)(MainBatchWorkflow.class.getName() + "-ScriptEngine"));
        engine.put("logger", logger);
        ScriptContext ctx = engine.getContext();
        engine.eval(MainBatchWorkflow.readResource("js/lib/lodash/4.3.0/lodash.js"));
        engine.eval(MainBatchWorkflow.readResource("js/src/rewrite-master.js"));
        List<String> rewriterResourceNames = Arrays.asList("js/src/rewriters/RewriterJson.js", "js/src/rewriters/RewriterPrefixes.js", "js/src/rewriters/RewriterSparqlFile.js", "js/src/rewriters/RewriterSparqlCount.js", "js/src/rewriters/RewriterSparqlService.js", "js/src/rewriters/RewriterSparqlStep.js", "js/src/rewriters/RewriterSparqlHop.js", "js/src/rewriters/RewriterSparqlUpdate.js", "js/src/rewriters/RewriterBeanClassName.js", "js/src/rewriters/RewriterBeanDefinition.js", "js/src/rewriters/RewriterSparqlPipe.js");
        String base = "/home/raven/Projects/Eclipse/jena-sparql-api-parent/jena-sparql-api-batch/src/main/resources/";
        for (String name : rewriterResourceNames) {
            engine.eval("load('" + base + "/" + name + "')");
        }
        Invocable inv = (Invocable)((Object)engine);
        Object tmpJsonOutStr = inv.invokeFunction("performRewrite", jsonStr);
        String jsonOutStr = (String)tmpJsonOutStr;
        StringReader reader = new StringReader(jsonOutStr);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        jsonReader.setLenient(true);
        JsonElement result = (JsonElement)gson.fromJson(jsonReader, JsonElement.class);
        String canon = gson.toJson(result);
        System.out.println(canon);
        return result;
    }

    public static JsonElement rewriteOld(JsonElement json) {
        List<JsonVisitorRewrite> rewriters = Arrays.asList(new JsonVisitorRewrite[]{new JsonVisitorRewriteSparqlService(), new JsonVisitorRewriteShape(), new JsonVisitorRewriteJson(), new JsonVisitorRewriteSparqlStep(), new JsonVisitorRewriteSimpleJob(), new JsonVisitorRewriteSparqlFile(), new JsonVisitorRewriteSparqlPipe(), new JsonVisitorRewriteSparqlUpdate(), new JsonVisitorRewritePrefixes(), new JsonVisitorRewriteHop(), new JsonVisitorRewriteClass("$dataSource", DriverManagerDataSource.class.getName()), new JsonVisitorRewriteClass("$log", FactoryBeanStepLog.class.getName()), new JsonVisitorRewriteClass("$sparqlCount", FactoryBeanStepSparqlCount.class.getName()), new JsonVisitorRewriteBeanClassName(), new JsonVisitorRewriteBeanDefinition()});
        JsonElement result = JsonWalker.rewriteUntilNoChange((JsonElement)json, rewriters);
        return result;
    }

    public static void mainContext(ApplicationContext baseContext) throws Exception {
        JsonElement jobJson = MainBatchWorkflow.readJsonElementFromResource("workflow.js");
        AnnotationConfigApplicationContext batchContext = MainBatchWorkflow.initContext(baseContext, jobJson);
        JobOperator jobOperator = (JobOperator)batchContext.getBean(JobOperator.class);
        Job job = (Job)batchContext.getBean(Job.class);
        System.out.println("STEP: " + ((SimpleJob)job).getStepNames());
        List<String> allBeans = Arrays.asList(batchContext.getBeanDefinitionNames());
        System.out.println("Got " + allBeans.size() + " beans: " + allBeans);
        System.out.println("Job: " + job);
        BatchWorkflowManager manager = (BatchWorkflowManager)batchContext.getBean(BatchWorkflowManager.class);
        JobExecution exec = manager.launch(job, new JobParameters());
        Thread.sleep(3000L);
        System.out.println("Waited for 3 sec");
        for (Throwable t : exec.getAllFailureExceptions()) {
            t.printStackTrace();
        }
    }

    public static void main1(String[] args) throws Exception {
        String str = "      Prefix o: <http://fp7-pp.publicdata.eu/ontology/>\n\t\t\tPrefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n\t            Construct where {\n\t              ?s\n\t                o:funding [\n\t                  o:partner [\n\t                    o:address [\n\t                      o:country [ rdfs:label ?col ] ;\n\t                      o:city [ rdfs:label ?cil ]\n\t                    ]\n\t                  ]\n\t                ]\n\t            }\n";
        Query q = QueryFactory.create((String)str, (Syntax)Syntax.syntaxSPARQL_11);
        MappedConcept<DatasetGraph> mc = QueryTransformConstructGroupedGraph.query2(q, Vars.s);
        QueryExecutionFactory qef = (QueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://fp7-pp.publicdata.eu/sparql", (String[])new String[]{"http://fp7-pp.publicdata.eu/"}).create();
        System.out.println(mc);
        LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, mc);
        Map map = (Map)ls.apply(Arrays.asList(NodeFactory.createURI((String)"http://fp7-pp.publicdata.eu/resource/project/231648"), NodeFactory.createURI((String)"http://fp7-pp.publicdata.eu/resource/project/231549")));
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("=====================================");
            System.out.println(entry.getKey());
            DatasetGraphUtils.write((PrintStream)System.out, (DatasetGraph)((DatasetGraph)entry.getValue()));
        }
    }

    public static void write(PrintStream out, Map<Node, DatasetGraph> map) {
        for (Map.Entry<Node, DatasetGraph> entry : map.entrySet()) {
            System.out.println("=====================================");
            System.out.println(entry.getKey());
            DatasetGraphUtils.write((PrintStream)out, (DatasetGraph)entry.getValue());
        }
    }

    public static void main3(String[] args) throws Exception {
        HashMap<String, MapTransformerSimple> keyToTransformer = new HashMap<String, MapTransformerSimple>();
        keyToTransformer.put("$concept", new MapTransformerSimple());
        PrefixMapping pm = MainBatchWorkflow.getDefaultPrefixMapping();
        String testx = "Prefix ex: <http://example.org/> Insert { ?s ex:osmId ?o ; ex:o ?oet ; ex:i ?oei } Where { ?s ex:locationString ?l . Bind(nominatim:geocode(?l) As ?x) . Bind(str(json:path(?x, '$[0].osm_type')) As ?oet) . Bind(str(json:path(?x, '$[0].osm_id')) As ?oei) . Bind(uri(concat('http://linkedgeodata.org/triplify/', ?oet, ?oei)) As ?o) }";
        UpdateRequest test = new UpdateRequest();
        test.setPrefixMapping(pm);
        UpdateFactory.parse((UpdateRequest)test, (String)testx);
        ResourceShapeParserJsonObject parser = new ResourceShapeParserJsonObject(pm);
        Map json = (Map)MainBatchWorkflow.readJsonResource("workflow.js");
        String str = (String)json.get("locationString");
        ModifierDatasetGraphSparqlUpdate m = new ModifierDatasetGraphSparqlUpdate(str);
        ResourceShape rs = parser.parse(json.get("shape"));
        ResourceShape lgdShape = parser.parse(json.get("lgdShape"));
        System.out.println(lgdShape);
        Concept concept = Concept.parse((String)"?s | Filter(?s = <http://fp7-pp.publicdata.eu/resource/project/257943> || ?s = <http://fp7-pp.publicdata.eu/resource/project/256975>)");
        MappedConcept mappedConcept = ResourceShape.createMappedConcept2((ResourceShape)rs, (Concept)concept, (boolean)false);
        System.out.println(mappedConcept);
        MappedConcept mcLgdShape = ResourceShape.createMappedConcept2((ResourceShape)lgdShape, null, (boolean)false);
        QueryExecutionFactory qef = (QueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://fp7-pp.publicdata.eu/sparql", (String[])new String[]{"http://fp7-pp.publicdata.eu/"}).create();
        QueryExecutionFactory qefLgd = (QueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://linkedgeodata.org/sparql", (String[])new String[]{"http://linkedgeodata.org"}).create();
        String osmIdToLgd = "Insert { ?s tmp:enrich ?o } Where { ?s tmp:osmId ?id ; tmp:osmEntityType ?et. Bind(concat('http://linkedgeodata.org/triplify/', ?et, ?et) As ?x) }";
        String enrichToSameAs = "Modify Insert { ?s owl:sameAs ?o } Delete { ?s tmp:enrich ?o } Where { ?s tmp:enrich ?o }";
        String fuse1 = "Modify Insert { ?s ?p ?o } Delete { ?x ?p ?o } Where { ?x tmp:fuse ?s ; ?s ?p ?o }";
        LookupServiceListService lsLgdX = LookupServiceListService.create((ListService)ListServiceResourceShape.create(qefLgd, lgdShape, true));
        Concept enrich = Concept.parse((String)"?id | ?s ex:osmId ?id", (PrefixMapping)pm);
        ModifierDatasetGraphEnrich lgdEnrich = new ModifierDatasetGraphEnrich((LookupService<Node, DatasetGraph>)lsLgdX, enrich);
        ListService ls = ListServiceUtils.createListServiceMappedConcept((QueryExecutionFactory)qef, (MappedConcept)mappedConcept, (boolean)true);
        Map nodeToDatasetGraph = ls.fetchData((Object)concept, null, null);
        ModifierDatasetGraphSparqlUpdate modi = new ModifierDatasetGraphSparqlUpdate(test);
        for (Map.Entry entry : nodeToDatasetGraph.entrySet()) {
            m.apply(entry.getValue());
            modi.apply(entry.getValue());
            lgdEnrich.apply(entry.getValue());
            System.out.println("=====================================");
            System.out.println(entry.getKey());
            DatasetGraphUtils.write((PrintStream)System.out, (DatasetGraph)((DatasetGraph)entry.getValue()));
        }
    }

    public static <T> T readJsonResource(String r) throws IOException {
        String str = MainBatchWorkflow.readResource(r);
        T result = MainBatchWorkflow.readJson(str);
        return result;
    }

    public static <T> T readJson(String str) throws IOException {
        Object tmp;
        Gson gson = new Gson();
        StringReader reader = new StringReader(str);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        jsonReader.setLenient(true);
        Object result = tmp = gson.fromJson(jsonReader, Object.class);
        return (T)result;
    }

    public static String readResource(String r) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource resource = resolver.getResource(r);
        InputStream in = resource.getInputStream();
        String result = StreamUtils.toString((InputStream)in);
        return result;
    }

    public static JsonElement readJsonElementFromResource(String r) throws IOException {
        String str = MainBatchWorkflow.readResource(r);
        JsonElement result = MainBatchWorkflow.readJsonElement(str);
        return result;
    }

    public static JsonElement readJsonElement(String str) throws IOException {
        Gson gson = new Gson();
        StringReader reader = new StringReader(str);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        jsonReader.setLenient(true);
        JsonElement result = (JsonElement)gson.fromJson(jsonReader, JsonElement.class);
        return result;
    }

    public static void main2(String[] args) throws Exception {
        HashMap<String, String> classAliasMap = new HashMap<String, String>();
        classAliasMap.put("QueryExecutionFactoryHttp", QueryExecutionFactoryHttp.class.getCanonicalName());
        String str = MainBatchWorkflow.readResource("workflow.json");
        Map data = (Map)MainBatchWorkflow.readJson(str);
        System.out.println(data);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        ContextProcessorJsonUtils.processContext((ApplicationContext)context, ((Map)data.get("job")).get("context"), classAliasMap);
        context.refresh();
        System.out.println("Test");
        BatchWorkflowManager workflowManager = BatchWorkflowManager.createTestInstance();
    }
}

