/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.cli.main;

import com.google.common.base.Supplier;
import java.io.InputStream;
import java.util.Iterator;
import org.aksw.jena_sparql_api.utils.ExtendedIteratorClosable;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SupplierExtendedIteratorTriples
implements Supplier<ExtendedIterator<Triple>> {
    protected String fileNameOrUrl;
    protected Lang langHint;

    public SupplierExtendedIteratorTriples(String fileNameOrUrl) {
        this(fileNameOrUrl, null);
    }

    public SupplierExtendedIteratorTriples(String fileNameOrUrl, Lang langHint) {
        this.fileNameOrUrl = fileNameOrUrl;
        this.langHint = langHint;
    }

    public ExtendedIterator<Triple> get() {
        TypedInputStream tis = RDFDataMgr.open((String)this.fileNameOrUrl);
        Lang lang = RDFDataMgr.determineLang((String)this.fileNameOrUrl, null, (Lang)this.langHint);
        String base = tis.getBaseURI();
        Iterator itTriple = RDFDataMgr.createIteratorTriples((InputStream)tis, (Lang)lang, (String)base);
        ExtendedIteratorClosable result = ExtendedIteratorClosable.create((Iterator)itTriple, (AutoCloseable)tis);
        return result;
    }
}

